/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.maxhenkel.pipez.corelib.helpers.Pair;
import de.maxhenkel.pipez.recipes.ModRecipes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CopyNbtRecipe
extends SpecialRecipe {
    private Ingredient ingredient;

    public CopyNbtRecipe(ResourceLocation recipeID, Ingredient ingredient) {
        super(recipeID);
        this.ingredient = ingredient;
    }

    public Pair<ItemStack, List<ItemStack>> getResult(CraftingInventory inv) {
        ItemStack source = null;
        ArrayList<ItemStack> toCopy = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (this.ingredient.test(stack)) {
                if (source == null && stack.func_77942_o()) {
                    source = stack;
                    continue;
                }
                toCopy.add(stack);
                continue;
            }
            return new Pair(null, new ArrayList());
        }
        return new Pair(source, toCopy);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        Pair<ItemStack, List<ItemStack>> result = this.getResult(inv);
        if (result.getKey() == null) {
            return false;
        }
        if (result.getValue().stream().allMatch(stack -> stack.func_77973_b().equals(((ItemStack)result.getKey()).func_77973_b()))) {
            return result.getKey() != null && result.getValue().size() > 0;
        }
        return result.getValue().size() == 1;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        Pair<ItemStack, List<ItemStack>> result = this.getResult(inv);
        if (result.getKey() == null) {
            return ItemStack.field_190927_a;
        }
        if (result.getValue().stream().allMatch(stack -> stack.func_77973_b().equals(((ItemStack)result.getKey()).func_77973_b()))) {
            ItemStack res = result.getKey().func_77946_l();
            res.func_190920_e(1 + result.getValue().size());
            return res;
        }
        if (result.getValue().size() == 1) {
            ItemStack stack2 = result.getValue().get(0).func_77946_l();
            stack2.func_190920_e(1);
            stack2.func_77982_d(result.getKey().func_77978_p().func_74737_b());
            return stack2;
        }
        return ItemStack.field_190927_a;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        Pair<ItemStack, List<ItemStack>> result = this.getResult(inv);
        if (result.getKey() == null) {
            return super.func_179532_b((IInventory)inv);
        }
        if (result.getValue().stream().allMatch(stack -> stack.func_77973_b().equals(((ItemStack)result.getKey()).func_77973_b()))) {
            return super.func_179532_b((IInventory)inv);
        }
        if (result.getValue().size() == 1) {
            NonNullList res = super.func_179532_b((IInventory)inv);
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                if (!inv.func_70301_a(i).equals(result.getKey())) continue;
                ItemStack r = result.getKey().func_77946_l();
                r.func_190920_e(1);
                res.set(i, (Object)r);
                break;
            }
            return res;
        }
        return super.func_179532_b((IInventory)inv);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return ModRecipes.COPY_NBT;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 2 && height >= 2;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<CopyNbtRecipe> {
        public static final ResourceLocation NAME = new ResourceLocation("pipez", "copy_nbt");

        public CopyNbtRecipe read(ResourceLocation recipeId, JsonObject json) {
            return new CopyNbtRecipe(recipeId, Ingredient.func_199802_a((JsonElement)json.get("item")));
        }

        public CopyNbtRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            return new CopyNbtRecipe(recipeId, Ingredient.func_199566_b((PacketBuffer)buffer));
        }

        public void write(PacketBuffer buffer, CopyNbtRecipe recipe) {
            recipe.ingredient.func_199564_a(buffer);
        }
    }
}

