/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.utils;

import de.maxhenkel.pipez.DirectionalPosition;
import de.maxhenkel.pipez.corelib.tag.SingleElementTag;
import de.maxhenkel.pipez.utils.Filter;
import java.util.UUID;
import net.minecraft.fluid.Fluid;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidFilter
extends Filter<Fluid> {
    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = new CompoundNBT();
        if (this.tag != null) {
            if (this.tag instanceof SingleElementTag) {
                ResourceLocation key = ForgeRegistries.FLUIDS.getKey(((SingleElementTag)this.tag).getElement());
                if (key != null) {
                    compound.func_74778_a("Fluid", key.toString());
                }
            } else {
                compound.func_74778_a("Tag", this.tag.func_230234_a_().toString());
            }
        }
        if (this.destination != null) {
            compound.func_218657_a("Destination", (INBT)this.destination.serializeNBT());
        }
        if (this.invert) {
            compound.func_74757_a("Invert", true);
        }
        compound.func_186854_a("ID", this.id);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        Fluid fluid;
        this.tag = null;
        if (compound.func_150297_b("Fluid", 8) && (fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(compound.func_74779_i("Fluid")))) != null) {
            this.tag = new SingleElementTag<Fluid>(fluid);
        }
        if (compound.func_150297_b("Tag", 8)) {
            this.tag = FluidTags.createOptional((ResourceLocation)new ResourceLocation(compound.func_74779_i("Tag")));
        }
        this.metadata = null;
        this.exactMetadata = false;
        if (compound.func_150297_b("Destination", 10)) {
            this.destination = new DirectionalPosition();
            this.destination.deserializeNBT(compound.func_74775_l("Destination"));
        }
        this.invert = compound.func_150297_b("Invert", 1) ? compound.func_74767_n("Invert") : false;
        this.id = compound.func_150297_b("ID", 11) ? compound.func_186857_a("ID") : UUID.randomUUID();
    }
}

