/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.inputs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.annotations.NonNull;
import mekanism.api.recipes.inputs.InputIngredient;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraftforge.common.crafting.NBTIngredient;

public abstract class ItemStackIngredient
implements InputIngredient<ItemStack> {
    public static ItemStackIngredient from(@Nonnull ItemStack stack) {
        return ItemStackIngredient.from(stack, stack.func_190916_E());
    }

    public static ItemStackIngredient from(@Nonnull ItemStack stack, int amount) {
        NBTIngredient ingredient = stack.func_77942_o() ? new NBTIngredient(stack){} : Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack});
        return ItemStackIngredient.from((Ingredient)ingredient, amount);
    }

    public static ItemStackIngredient from(@Nonnull IItemProvider item) {
        return ItemStackIngredient.from(item, 1);
    }

    public static ItemStackIngredient from(@Nonnull IItemProvider item, int amount) {
        return ItemStackIngredient.from(new ItemStack(item), amount);
    }

    public static ItemStackIngredient from(@Nonnull ITag<Item> itemTag) {
        return ItemStackIngredient.from(itemTag, 1);
    }

    public static ItemStackIngredient from(@Nonnull ITag<Item> itemTag, int amount) {
        return ItemStackIngredient.from(Ingredient.func_199805_a(itemTag), amount);
    }

    public static ItemStackIngredient from(@Nonnull Ingredient ingredient) {
        return ItemStackIngredient.from(ingredient, 1);
    }

    public static ItemStackIngredient from(@Nonnull Ingredient ingredient, int amount) {
        return new Single(ingredient, amount);
    }

    public static ItemStackIngredient read(PacketBuffer buffer) {
        IngredientType type = (IngredientType)buffer.func_179257_a(IngredientType.class);
        if (type == IngredientType.SINGLE) {
            return Single.read(buffer);
        }
        return Multi.read(buffer);
    }

    public static ItemStackIngredient deserialize(@Nullable JsonElement json) {
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Ingredient cannot be null");
        }
        if (json.isJsonArray()) {
            JsonArray jsonArray = json.getAsJsonArray();
            int size = jsonArray.size();
            if (size == 0) {
                throw new JsonSyntaxException("Ingredient array cannot be empty, at least one ingredient must be defined");
            }
            if (size > 1) {
                ItemStackIngredient[] ingredients = new ItemStackIngredient[size];
                for (int i = 0; i < size; ++i) {
                    ingredients[i] = ItemStackIngredient.deserialize(jsonArray.get(i));
                }
                return ItemStackIngredient.createMulti(ingredients);
            }
            json = jsonArray.get(0);
        }
        if (!json.isJsonObject()) {
            throw new JsonSyntaxException("Expected item to be object or array of objects");
        }
        JsonObject jsonObject = json.getAsJsonObject();
        int amount = 1;
        if (jsonObject.has("amount")) {
            JsonElement count = jsonObject.get("amount");
            if (!JSONUtils.func_188175_b((JsonElement)count)) {
                throw new JsonSyntaxException("Expected amount to be a number that is one or larger.");
            }
            amount = count.getAsJsonPrimitive().getAsInt();
            if (amount < 1) {
                throw new JsonSyntaxException("Expected amount to larger than or equal to one");
            }
        }
        JsonArray jsonelement = JSONUtils.func_151202_d((JsonObject)jsonObject, (String)"ingredient") ? JSONUtils.func_151214_t((JsonObject)jsonObject, (String)"ingredient") : JSONUtils.func_152754_s((JsonObject)jsonObject, (String)"ingredient");
        Ingredient ingredient = Ingredient.func_199802_a((JsonElement)jsonelement);
        return ItemStackIngredient.from(ingredient, amount);
    }

    public static ItemStackIngredient createMulti(ItemStackIngredient ... ingredients) {
        if (ingredients.length != 0 && ingredients.length == 1) {
            return ingredients[0];
        }
        ArrayList<ItemStackIngredient> cleanedIngredients = new ArrayList<ItemStackIngredient>();
        for (ItemStackIngredient ingredient : ingredients) {
            if (ingredient instanceof Multi) {
                cleanedIngredients.addAll(Arrays.asList(((Multi)ingredient).ingredients));
                continue;
            }
            cleanedIngredients.add(ingredient);
        }
        return new Multi(cleanedIngredients.toArray(new ItemStackIngredient[0]));
    }

    private static enum IngredientType {
        SINGLE,
        MULTI;

    }

    public static class Multi
    extends ItemStackIngredient {
        private final ItemStackIngredient[] ingredients;

        protected Multi(ItemStackIngredient ... ingredients) {
            this.ingredients = ingredients;
        }

        @Override
        public boolean test(@Nonnull ItemStack stack) {
            return Arrays.stream(this.ingredients).anyMatch(ingredient -> ingredient.test(stack));
        }

        @Override
        public boolean testType(@Nonnull ItemStack stack) {
            return Arrays.stream(this.ingredients).anyMatch(ingredient -> ingredient.testType(stack));
        }

        @Override
        @Nonnull
        public ItemStack getMatchingInstance(@Nonnull ItemStack stack) {
            for (ItemStackIngredient ingredient : this.ingredients) {
                ItemStack matchingInstance = ingredient.getMatchingInstance(stack);
                if (matchingInstance.func_190926_b()) continue;
                return matchingInstance;
            }
            return ItemStack.field_190927_a;
        }

        @Override
        public long getNeededAmount(@Nonnull ItemStack stack) {
            for (ItemStackIngredient ingredient : this.ingredients) {
                long amount = ingredient.getNeededAmount(stack);
                if (amount <= 0L) continue;
                return amount;
            }
            return 0L;
        }

        @Override
        @Nonnull
        public List<@NonNull ItemStack> getRepresentations() {
            ArrayList<@NonNull ItemStack> representations = new ArrayList<ItemStack>();
            for (ItemStackIngredient ingredient : this.ingredients) {
                representations.addAll(ingredient.getRepresentations());
            }
            return representations;
        }

        @Override
        public void write(PacketBuffer buffer) {
            buffer.func_179249_a((Enum)IngredientType.MULTI);
            buffer.func_150787_b(this.ingredients.length);
            for (ItemStackIngredient ingredient : this.ingredients) {
                ingredient.write(buffer);
            }
        }

        @Override
        @Nonnull
        public JsonElement serialize() {
            JsonArray json = new JsonArray();
            for (ItemStackIngredient ingredient : this.ingredients) {
                json.add(ingredient.serialize());
            }
            return json;
        }

        public static ItemStackIngredient read(PacketBuffer buffer) {
            ItemStackIngredient[] ingredients = new ItemStackIngredient[buffer.func_150792_a()];
            for (int i = 0; i < ingredients.length; ++i) {
                ingredients[i] = ItemStackIngredient.read(buffer);
            }
            return Multi.createMulti(ingredients);
        }
    }

    public static class Single
    extends ItemStackIngredient {
        @Nonnull
        private final Ingredient ingredient;
        private final int amount;

        public Single(@Nonnull Ingredient ingredient, int amount) {
            this.ingredient = Objects.requireNonNull(ingredient);
            this.amount = amount;
        }

        @Override
        public boolean test(@Nonnull ItemStack stack) {
            return this.testType(stack) && stack.func_190916_E() >= this.amount;
        }

        @Override
        public boolean testType(@Nonnull ItemStack stack) {
            return this.ingredient.test(stack);
        }

        @Override
        @Nonnull
        public ItemStack getMatchingInstance(@Nonnull ItemStack stack) {
            if (this.test(stack)) {
                ItemStack matching = stack.func_77946_l();
                matching.func_190920_e(this.amount);
                return matching;
            }
            return ItemStack.field_190927_a;
        }

        @Override
        public long getNeededAmount(@Nonnull ItemStack stack) {
            return this.testType(stack) ? (long)this.amount : 0L;
        }

        @Override
        @Nonnull
        public List<@NonNull ItemStack> getRepresentations() {
            ArrayList<@NonNull ItemStack> representations = new ArrayList<ItemStack>();
            for (ItemStack stack : this.ingredient.func_193365_a()) {
                if (stack.func_190916_E() == this.amount) {
                    representations.add(stack);
                    continue;
                }
                ItemStack copy = stack.func_77946_l();
                copy.func_190920_e(this.amount);
                representations.add(copy);
            }
            return representations;
        }

        @Override
        public void write(PacketBuffer buffer) {
            buffer.func_179249_a((Enum)IngredientType.SINGLE);
            this.ingredient.func_199564_a(buffer);
            buffer.func_150787_b(this.amount);
        }

        @Override
        @Nonnull
        public JsonElement serialize() {
            JsonObject json = new JsonObject();
            if (this.amount > 1) {
                json.addProperty("amount", (Number)this.amount);
            }
            json.add("ingredient", this.ingredient.func_200304_c());
            return json;
        }

        public static Single read(PacketBuffer buffer) {
            return new Single(Ingredient.func_199566_b((PacketBuffer)buffer), buffer.func_150792_a());
        }
    }
}

