/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.inputs.chemical;

import com.google.gson.JsonElement;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.providers.ISlurryProvider;
import mekanism.api.recipes.inputs.chemical.ChemicalIngredientDeserializer;
import mekanism.api.recipes.inputs.chemical.ChemicalIngredientInfo;
import mekanism.api.recipes.inputs.chemical.ChemicalStackIngredient;
import mekanism.api.recipes.inputs.chemical.IChemicalStackIngredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;

public interface SlurryStackIngredient
extends IChemicalStackIngredient<Slurry, SlurryStack> {
    public static SlurryStackIngredient from(@Nonnull SlurryStack instance) {
        return SlurryStackIngredient.from((ISlurryProvider)instance.getType(), instance.getAmount());
    }

    public static SlurryStackIngredient from(@Nonnull ISlurryProvider slurry, long amount) {
        return new Single(slurry.getStack(amount));
    }

    public static SlurryStackIngredient from(@Nonnull ITag<Slurry> tag, long amount) {
        return new Tagged(tag, amount);
    }

    public static SlurryStackIngredient read(PacketBuffer buffer) {
        return ChemicalIngredientDeserializer.SLURRY.read(buffer);
    }

    public static SlurryStackIngredient deserialize(@Nullable JsonElement json) {
        return ChemicalIngredientDeserializer.SLURRY.deserialize(json);
    }

    public static SlurryStackIngredient createMulti(SlurryStackIngredient ... ingredients) {
        return (SlurryStackIngredient)ChemicalIngredientDeserializer.SLURRY.createMulti(ingredients);
    }

    @Override
    default public ChemicalIngredientInfo<Slurry, SlurryStack> getIngredientInfo() {
        return ChemicalIngredientInfo.SLURRY;
    }

    public static class Multi
    extends ChemicalStackIngredient.MultiIngredient<Slurry, SlurryStack, SlurryStackIngredient>
    implements SlurryStackIngredient {
        protected Multi(SlurryStackIngredient ... ingredients) {
            super((IChemicalStackIngredient[])ingredients);
        }
    }

    public static class Tagged
    extends ChemicalStackIngredient.TaggedIngredient<Slurry, SlurryStack>
    implements SlurryStackIngredient {
        protected Tagged(@Nonnull ITag<Slurry> tag, long amount) {
            super(tag, amount);
        }
    }

    public static class Single
    extends ChemicalStackIngredient.SingleIngredient<Slurry, SlurryStack>
    implements SlurryStackIngredient {
        protected Single(@Nonnull SlurryStack stack) {
            super(stack);
        }
    }
}

