/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.blocks.tileentity;

import de.maxhenkel.pipez.blocks.tileentity.UpgradeTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.types.EnergyPipeType;
import de.maxhenkel.pipez.blocks.tileentity.types.FluidPipeType;
import de.maxhenkel.pipez.blocks.tileentity.types.ItemPipeType;
import de.maxhenkel.pipez.blocks.tileentity.types.PipeType;
import de.maxhenkel.pipez.corelib.CachedMap;
import de.maxhenkel.pipez.utils.DummyFluidHandler;
import de.maxhenkel.pipez.utils.DummyItemHandler;
import de.maxhenkel.pipez.utils.PipeEnergyStorage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class PipeLogicTileEntity
extends UpgradeTileEntity {
    protected PipeType<?>[] types;
    protected final int[][] rrIndex;
    protected CachedMap<Direction, PipeEnergyStorage> energyCache;

    public PipeLogicTileEntity(BlockEntityType<?> tileEntityTypeIn, PipeType<?>[] types, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        this.types = types;
        this.rrIndex = new int[Direction.values().length][types.length];
        this.energyCache = new CachedMap();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.f_58859_) {
            return super.getCapability(cap, side);
        }
        if (cap == CapabilityEnergy.ENERGY && this.hasType(EnergyPipeType.INSTANCE)) {
            if (side != null && this.isExtracting(side)) {
                return LazyOptional.of(() -> this.energyCache.get(side, () -> new PipeEnergyStorage(this, side))).cast();
            }
        } else if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.hasType(FluidPipeType.INSTANCE)) {
            if (side == null || this.isExtracting(side)) {
                return LazyOptional.of(() -> DummyFluidHandler.INSTANCE).cast();
            }
        } else if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.hasType(ItemPipeType.INSTANCE) && (side == null || this.isExtracting(side))) {
            return LazyOptional.of(() -> DummyItemHandler.INSTANCE).cast();
        }
        return super.getCapability(cap, side);
    }

    public boolean hasType(PipeType<?> type) {
        for (PipeType<?> t : this.types) {
            if (t != type) continue;
            return true;
        }
        return false;
    }

    public int getRoundRobinIndex(Direction direction, PipeType<?> pipeType) {
        return this.rrIndex[direction.m_122411_()][this.getIndex(pipeType)];
    }

    public void setRoundRobinIndex(Direction direction, PipeType<?> pipeType, int value) {
        this.rrIndex[direction.m_122411_()][this.getIndex(pipeType)] = value;
    }

    public boolean isEnabled(Direction side, PipeType<?> pipeType) {
        UpgradeTileEntity.RedstoneMode redstoneMode = this.getRedstoneMode(side, pipeType);
        return redstoneMode != UpgradeTileEntity.RedstoneMode.ALWAYS_OFF;
    }

    public int getPreferredPipeIndex(Direction side) {
        for (int i = 0; i < this.types.length; ++i) {
            if (!this.isEnabled(side, this.types[i])) continue;
            return i;
        }
        return 0;
    }

    public boolean shouldWork(Direction side, PipeType<?> pipeType) {
        UpgradeTileEntity.RedstoneMode redstoneMode = this.getRedstoneMode(side, pipeType);
        if (redstoneMode.equals(UpgradeTileEntity.RedstoneMode.ALWAYS_OFF)) {
            return false;
        }
        if (redstoneMode.equals(UpgradeTileEntity.RedstoneMode.OFF_WHEN_POWERED)) {
            return !this.isRedstonePowered();
        }
        if (redstoneMode.equals(UpgradeTileEntity.RedstoneMode.ON_WHEN_POWERED)) {
            return this.isRedstonePowered();
        }
        return true;
    }

    public boolean isRedstonePowered() {
        return this.f_58857_.m_46753_(this.f_58858_);
    }

    public PipeType<?>[] getPipeTypes() {
        return this.types;
    }

    public int getIndex(PipeType<?> pipeType) {
        for (int i = 0; i < this.getPipeTypes().length; ++i) {
            PipeType<?> type = this.getPipeTypes()[i];
            if (type != pipeType) continue;
            return i;
        }
        return 0;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.f_58857_.f_46443_) {
            return;
        }
        for (PipeType<?> pipeType : this.getPipeTypes()) {
            pipeType.tick(this);
        }
        if (this.hasType(EnergyPipeType.INSTANCE)) {
            for (PipeType<?> pipeType : Direction.values()) {
                if (!this.isExtracting((Direction)pipeType)) continue;
                PipeEnergyStorage energyStorage = this.energyCache.get((Direction)pipeType, () -> new PipeEnergyStorage(this, (Direction)side));
                energyStorage.tick();
            }
        }
    }

    @Override
    public boolean canInsert(BlockEntity tileEntity, Direction direction) {
        for (PipeType<?> type : this.types) {
            if (!type.canInsert(tileEntity, direction)) continue;
            return true;
        }
        return false;
    }
}

