/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.blocks.tileentity;

import de.maxhenkel.pipez.DirectionalPosition;
import de.maxhenkel.pipez.blocks.PipeBlock;
import de.maxhenkel.pipez.corelib.blockentity.ITickableBlockEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class PipeTileEntity
extends BlockEntity
implements ITickableBlockEntity {
    @Nullable
    protected List<Connection> connectionCache;
    protected boolean[] extractingSides = new boolean[Direction.values().length];
    protected boolean[] disconnectedSides = new boolean[Direction.values().length];
    private int invalidateCountdown;

    public PipeTileEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public List<Connection> getConnections() {
        if (this.f_58857_ == null) {
            return new ArrayList<Connection>();
        }
        if (this.connectionCache == null) {
            this.updateCache();
            if (this.connectionCache == null) {
                return new ArrayList<Connection>();
            }
        }
        return this.connectionCache;
    }

    public static void markPipesDirty(Level world, BlockPos pos) {
        ArrayList<BlockPos> travelPositions = new ArrayList<BlockPos>();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        Block block = world.m_8055_(pos).m_60734_();
        if (!(block instanceof PipeBlock)) {
            return;
        }
        PipeBlock pipeBlock = (PipeBlock)block;
        PipeTileEntity pipeTe = pipeBlock.getTileEntity((LevelAccessor)world, pos);
        if (pipeTe != null) {
            for (Direction side : Direction.values()) {
                if (!pipeTe.isExtracting(side) || pipeBlock.canConnectTo((LevelAccessor)world, pos, side)) continue;
                pipeTe.setExtracting(side, false);
                if (pipeTe.hasReasonToStay()) continue;
                pipeBlock.setHasData(world, pos, false);
            }
        }
        travelPositions.add(pos);
        PipeTileEntity.addToDirtyList(world, pos, pipeBlock, travelPositions, queue);
        while (queue.size() > 0) {
            BlockPos blockPos = queue.removeFirst();
            block = world.m_8055_(blockPos).m_60734_();
            if (!(block instanceof PipeBlock)) continue;
            PipeTileEntity.addToDirtyList(world, blockPos, (PipeBlock)block, travelPositions, queue);
        }
        for (BlockPos p : travelPositions) {
            BlockEntity te = world.m_7702_(p);
            if (!(te instanceof PipeTileEntity)) continue;
            PipeTileEntity pipe = (PipeTileEntity)te;
            pipe.connectionCache = null;
        }
    }

    private static void addToDirtyList(Level world, BlockPos pos, PipeBlock pipeBlock, List<BlockPos> travelPositions, LinkedList<BlockPos> queue) {
        for (Direction direction : Direction.values()) {
            BlockPos p;
            if (!pipeBlock.isConnected((LevelAccessor)world, pos, direction) || travelPositions.contains(p = pos.m_142300_(direction)) || queue.contains(p)) continue;
            travelPositions.add(p);
            queue.add(p);
        }
    }

    private void updateCache() {
        BlockState blockState = this.m_58900_();
        if (!(blockState.m_60734_() instanceof PipeBlock)) {
            this.connectionCache = null;
            return;
        }
        if (!this.isExtracting()) {
            this.connectionCache = null;
            return;
        }
        HashMap<DirectionalPosition, Integer> connections = new HashMap<DirectionalPosition, Integer>();
        HashMap<BlockPos, Integer> queue = new HashMap<BlockPos, Integer>();
        ArrayList<BlockPos> travelPositions = new ArrayList<BlockPos>();
        this.addToQueue(this.f_58857_, this.f_58858_, queue, travelPositions, connections, 1);
        while (queue.size() > 0) {
            Map.Entry blockPosIntegerEntry = (Map.Entry)queue.entrySet().stream().findAny().get();
            this.addToQueue(this.f_58857_, (BlockPos)blockPosIntegerEntry.getKey(), queue, travelPositions, connections, (Integer)blockPosIntegerEntry.getValue());
            travelPositions.add((BlockPos)blockPosIntegerEntry.getKey());
            queue.remove(blockPosIntegerEntry.getKey());
        }
        this.connectionCache = connections.entrySet().stream().map(entry -> new Connection(((DirectionalPosition)entry.getKey()).getPos(), ((DirectionalPosition)entry.getKey()).getDirection(), (Integer)entry.getValue())).collect(Collectors.toList());
    }

    public void addToQueue(Level world, BlockPos position, Map<BlockPos, Integer> queue, List<BlockPos> travelPositions, Map<DirectionalPosition, Integer> insertPositions, int distance) {
        Block block = world.m_8055_(position).m_60734_();
        if (!(block instanceof PipeBlock)) {
            return;
        }
        PipeBlock pipeBlock = (PipeBlock)block;
        for (Direction direction : Direction.values()) {
            if (!pipeBlock.isConnected((LevelAccessor)world, position, direction)) continue;
            BlockPos p = position.m_142300_(direction);
            DirectionalPosition dp = new DirectionalPosition(p, direction.m_122424_());
            if (this.canInsert(position, direction)) {
                if (!insertPositions.containsKey(dp)) {
                    insertPositions.put(dp, distance);
                    continue;
                }
                if (insertPositions.get(dp) <= distance) continue;
                insertPositions.put(dp, distance);
                continue;
            }
            if (travelPositions.contains(p) || queue.containsKey(p)) continue;
            queue.put(p, distance + 1);
        }
    }

    public boolean canInsert(BlockPos pos, Direction direction) {
        PipeTileEntity pipe;
        BlockEntity te = this.f_58857_.m_7702_(pos);
        if (te instanceof PipeTileEntity && (pipe = (PipeTileEntity)te).isExtracting(direction)) {
            return false;
        }
        BlockEntity tileEntity = this.f_58857_.m_7702_(pos.m_142300_(direction));
        if (tileEntity == null) {
            return false;
        }
        if (tileEntity instanceof PipeTileEntity) {
            return false;
        }
        return this.canInsert(tileEntity, direction.m_122424_());
    }

    public abstract boolean canInsert(BlockEntity var1, Direction var2);

    @Override
    public void tick() {
        if (this.invalidateCountdown > 0) {
            --this.invalidateCountdown;
            if (this.invalidateCountdown <= 0) {
                this.connectionCache = null;
            }
        }
    }

    public boolean isExtracting(Direction side) {
        return this.extractingSides[side.m_122411_()];
    }

    public boolean isExtracting() {
        for (boolean extract : this.extractingSides) {
            if (!extract) continue;
            return true;
        }
        return false;
    }

    public boolean hasReasonToStay() {
        if (this.isExtracting()) {
            return true;
        }
        for (boolean disconnected : this.disconnectedSides) {
            if (!disconnected) continue;
            return true;
        }
        return false;
    }

    public void setExtracting(Direction side, boolean extracting) {
        this.extractingSides[side.m_122411_()] = extracting;
        this.m_6596_();
    }

    public boolean isDisconnected(Direction side) {
        return this.disconnectedSides[side.m_122411_()];
    }

    public void setDisconnected(Direction side, boolean disconnected) {
        this.disconnectedSides[side.m_122411_()] = disconnected;
        this.m_6596_();
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.extractingSides = new boolean[Direction.values().length];
        ListTag extractingList = compound.m_128437_("ExtractingSides", 1);
        if (extractingList.size() >= this.extractingSides.length) {
            for (int i = 0; i < this.extractingSides.length; ++i) {
                ByteTag b = (ByteTag)extractingList.get(i);
                this.extractingSides[i] = b.m_7063_() != 0;
            }
        }
        this.disconnectedSides = new boolean[Direction.values().length];
        ListTag disconnectedList = compound.m_128437_("DisconnectedSides", 1);
        if (disconnectedList.size() >= this.disconnectedSides.length) {
            for (int i = 0; i < this.disconnectedSides.length; ++i) {
                ByteTag b = (ByteTag)disconnectedList.get(i);
                this.disconnectedSides[i] = b.m_7063_() != 0;
            }
        }
        this.invalidateCountdown = 5;
    }

    public CompoundTag m_6945_(CompoundTag compound) {
        ListTag extractingList = new ListTag();
        for (boolean extractingSide : this.extractingSides) {
            extractingList.add((Object)ByteTag.m_128273_((boolean)extractingSide));
        }
        compound.m_128365_("ExtractingSides", (Tag)extractingList);
        ListTag disconnectedList = new ListTag();
        for (boolean disconnected : this.disconnectedSides) {
            disconnectedList.add((Object)ByteTag.m_128273_((boolean)disconnected));
        }
        compound.m_128365_("DisconnectedSides", (Tag)disconnectedList);
        return super.m_6945_(compound);
    }

    public ClientboundBlockEntityDataPacket m_7033_() {
        return new ClientboundBlockEntityDataPacket(this.f_58858_, 1, this.m_5995_());
    }

    public void onDataPacket(net.minecraft.network.Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    public CompoundTag m_5995_() {
        return this.m_6945_(new CompoundTag());
    }

    public static class Connection {
        private final BlockPos pos;
        private final Direction direction;
        private final int distance;

        public Connection(BlockPos pos, Direction direction, int distance) {
            this.pos = pos;
            this.direction = direction;
            this.distance = distance;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public int getDistance() {
            return this.distance;
        }

        public String toString() {
            return "Connection{pos=" + this.pos + ", direction=" + this.direction + ", distance=" + this.distance + "}";
        }
    }
}

