/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.blocks.tileentity.configuration;

import de.maxhenkel.pipez.blocks.tileentity.types.PipeType;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public abstract class CachedPipeConfiguration<T> {
    private Map<PipeType<?>, T>[] cachedValues;
    protected Supplier<NonNullList<ItemStack>> upgradeInventory;
    protected String key;
    protected Function<PipeType<?>, T> defaultValue;
    protected Runnable onDirty;

    public CachedPipeConfiguration(Supplier<NonNullList<ItemStack>> upgradeInventory, String key, Function<PipeType<?>, T> defaultValue, Runnable onDirty) {
        this.upgradeInventory = upgradeInventory;
        this.key = key;
        this.defaultValue = defaultValue;
        this.onDirty = onDirty;
        this.cachedValues = new HashMap[Direction.values().length];
    }

    public T getValue(Direction side, PipeType<?> pipeType) {
        Map<PipeType<?>, T> map = this.cachedValues[side.ordinal()];
        if (map == null) {
            map = new HashMap();
            this.cachedValues[side.ordinal()] = map;
        }
        if (map.containsKey(pipeType)) {
            return map.get(pipeType);
        }
        ItemStack stack = (ItemStack)this.upgradeInventory.get().get(side.ordinal());
        if (stack.m_41619_() || !stack.m_41782_()) {
            return this.putDefault(pipeType, map);
        }
        CompoundTag tag = stack.m_41783_();
        if (!tag.m_128425_(pipeType.getKey(), 10)) {
            return this.putDefault(pipeType, map);
        }
        CompoundTag compound = tag.m_128469_(pipeType.getKey());
        if (!compound.m_128441_(this.key)) {
            return this.putDefault(pipeType, map);
        }
        T value = this.deserialize(pipeType, compound.m_128423_(this.key));
        if (value == null) {
            return this.putDefault(pipeType, map);
        }
        map.put(pipeType, value);
        return value;
    }

    public T putDefault(PipeType<?> pipeType, Map<PipeType<?>, T> map) {
        T def = this.defaultValue.apply(pipeType);
        map.put(pipeType, def);
        return def;
    }

    public void setValue(Direction side, PipeType<?> pipeType, T value) {
        CompoundTag compound;
        ItemStack stack;
        Map<PipeType<?>, T> map = this.cachedValues[side.ordinal()];
        if (map == null) {
            map = new HashMap();
            this.cachedValues[side.ordinal()] = map;
        }
        if ((stack = (ItemStack)this.upgradeInventory.get().get(side.ordinal())).m_41619_()) {
            return;
        }
        map.put(pipeType, value);
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128425_(pipeType.getKey(), 10)) {
            compound = tag.m_128469_(pipeType.getKey());
        } else {
            compound = new CompoundTag();
            tag.m_128365_(pipeType.getKey(), (Tag)compound);
        }
        compound.m_128365_(this.key, this.serialize(value));
        this.onDirty.run();
    }

    public void invalidate() {
        for (Map<PipeType<?>, T> map : this.cachedValues) {
            if (map == null) continue;
            map.clear();
        }
    }

    public abstract Tag serialize(T var1);

    @Nullable
    public abstract T deserialize(PipeType<?> var1, Tag var2);
}

