/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.FluidFilter;
import de.maxhenkel.pipez.ItemFilter;
import de.maxhenkel.pipez.Main;
import de.maxhenkel.pipez.Upgrade;
import de.maxhenkel.pipez.blocks.tileentity.PipeLogicTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.types.PipeType;
import de.maxhenkel.pipez.corelib.inventory.ScreenBase;
import de.maxhenkel.pipez.corelib.tag.SingleElementTag;
import de.maxhenkel.pipez.gui.CycleIconButton;
import de.maxhenkel.pipez.gui.ExtractContainer;
import de.maxhenkel.pipez.gui.FilterList;
import de.maxhenkel.pipez.gui.UpgradeSlot;
import de.maxhenkel.pipez.net.CycleDistributionMessage;
import de.maxhenkel.pipez.net.CycleFilterModeMessage;
import de.maxhenkel.pipez.net.CycleRedstoneModeMessage;
import de.maxhenkel.pipez.net.EditFilterMessage;
import de.maxhenkel.pipez.net.RemoveFilterMessage;
import de.maxhenkel.pipez.net.UpdateFilterMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidUtil;

public class ExtractScreen
extends ScreenBase<ExtractContainer> {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("pipez", "textures/gui/container/extract.png");
    private CycleIconButton redstoneButton;
    private CycleIconButton sortButton;
    private CycleIconButton filterButton;
    private Button addFilterButton;
    private Button editFilterButton;
    private Button removeFilterButton;
    private ScreenBase.HoverArea redstoneArea;
    private ScreenBase.HoverArea sortArea;
    private ScreenBase.HoverArea filterArea;
    private ScreenBase.HoverArea[] tabs;
    private PipeType<?>[] pipeTypes;
    private int currentindex;
    private FilterList filterList;

    public ExtractScreen(ExtractContainer container, Inventory playerInventory, Component title) {
        super(BACKGROUND, container, playerInventory, title);
        this.f_97726_ = 176;
        this.f_97727_ = 196;
        this.pipeTypes = container.getPipe().getPipeTypes();
        if (this.pipeTypes.length > 1) {
            this.tabs = new ScreenBase.HoverArea[this.pipeTypes.length];
        }
        this.currentindex = container.getIndex();
        if (this.currentindex < 0) {
            this.currentindex = ((ExtractContainer)this.m_6262_()).getPipe().getPreferredPipeIndex(((ExtractContainer)this.m_6262_()).getSide());
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.hoverAreas.clear();
        this.m_169413_();
        PipeLogicTileEntity pipe = ((ExtractContainer)this.m_6262_()).getPipe();
        Direction side = ((ExtractContainer)this.m_6262_()).getSide();
        this.filterList = new FilterList(this, 32, 8, 136, 66, () -> pipe.getFilters(side, this.pipeTypes[this.currentindex]));
        Supplier<Integer> redstoneModeIndex = () -> pipe.getRedstoneMode(((ExtractContainer)this.m_6262_()).getSide(), this.pipeTypes[this.currentindex]).ordinal();
        List<CycleIconButton.Icon> redstoneModeIcons = Arrays.asList(new CycleIconButton.Icon(BACKGROUND, 176, 16), new CycleIconButton.Icon(BACKGROUND, 192, 16), new CycleIconButton.Icon(BACKGROUND, 208, 16), new CycleIconButton.Icon(BACKGROUND, 224, 16));
        this.redstoneButton = new CycleIconButton(this.f_97735_ + 7, this.f_97736_ + 7, redstoneModeIcons, redstoneModeIndex, button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new CycleRedstoneModeMessage(this.currentindex)));
        Supplier<Integer> distributionIndex = () -> pipe.getDistribution(((ExtractContainer)this.m_6262_()).getSide(), this.pipeTypes[this.currentindex]).ordinal();
        List<CycleIconButton.Icon> distributionIcons = Arrays.asList(new CycleIconButton.Icon(BACKGROUND, 176, 0), new CycleIconButton.Icon(BACKGROUND, 192, 0), new CycleIconButton.Icon(BACKGROUND, 208, 0), new CycleIconButton.Icon(BACKGROUND, 224, 0));
        this.sortButton = new CycleIconButton(this.f_97735_ + 7, this.f_97736_ + 31, distributionIcons, distributionIndex, button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new CycleDistributionMessage(this.currentindex)));
        Supplier<Integer> filterModeIndex = () -> this.pipeTypes[this.currentindex].hasFilter() ? pipe.getFilterMode(((ExtractContainer)this.m_6262_()).getSide(), this.pipeTypes[this.currentindex]).ordinal() : 0;
        List<CycleIconButton.Icon> filterModeIcons = Arrays.asList(new CycleIconButton.Icon(BACKGROUND, 176, 32), new CycleIconButton.Icon(BACKGROUND, 192, 32));
        this.filterButton = new CycleIconButton(this.f_97735_ + 7, this.f_97736_ + 55, filterModeIcons, filterModeIndex, button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new CycleFilterModeMessage(this.currentindex)));
        this.addFilterButton = new Button(this.f_97735_ + 31, this.f_97736_ + 79, 40, 20, (Component)new TranslatableComponent("message.pipez.filter.add"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new EditFilterMessage(this.pipeTypes[this.currentindex].createFilter(), this.currentindex)));
        this.editFilterButton = new Button(this.f_97735_ + 80, this.f_97736_ + 79, 40, 20, (Component)new TranslatableComponent("message.pipez.filter.edit"), button -> {
            if (this.filterList.getSelected() >= 0) {
                Main.SIMPLE_CHANNEL.sendToServer((Object)new EditFilterMessage(pipe.getFilters(side, this.pipeTypes[this.currentindex]).get(this.filterList.getSelected()), this.currentindex));
            }
        });
        this.removeFilterButton = new Button(this.f_97735_ + 129, this.f_97736_ + 79, 40, 20, (Component)new TranslatableComponent("message.pipez.filter.remove"), button -> {
            if (this.filterList.getSelected() >= 0) {
                Main.SIMPLE_CHANNEL.sendToServer((Object)new RemoveFilterMessage(pipe.getFilters(side, this.pipeTypes[this.currentindex]).get(this.filterList.getSelected()).getId(), this.currentindex));
            }
        });
        this.m_142416_(this.redstoneButton);
        this.m_142416_(this.sortButton);
        this.m_142416_(this.filterButton);
        this.m_142416_(this.addFilterButton);
        this.m_142416_(this.editFilterButton);
        this.m_142416_(this.removeFilterButton);
        if (this.hasTabs()) {
            for (int i = 0; i < this.pipeTypes.length; ++i) {
                int tabIndex = i;
                this.tabs[i] = new ScreenBase.HoverArea(-23, 5 + 25 * i, 24, 24, () -> {
                    ArrayList<FormattedCharSequence> tooltip = new ArrayList<FormattedCharSequence>();
                    tooltip.add(new TranslatableComponent(this.pipeTypes[tabIndex].getTranslationKey()).m_7532_());
                    return tooltip;
                });
                this.hoverAreas.add(this.tabs[i]);
            }
        }
        this.redstoneArea = new ScreenBase.HoverArea(7, 7, 20, 20, () -> {
            if (this.redstoneButton.f_93623_) {
                return Arrays.asList(new TranslatableComponent("tooltip.pipez.redstone_mode", new Object[]{new TranslatableComponent("tooltip.pipez.redstone_mode." + pipe.getRedstoneMode(side, this.pipeTypes[this.currentindex]).getName())}).m_7532_());
            }
            return Collections.emptyList();
        });
        this.sortArea = new ScreenBase.HoverArea(7, 31, 20, 20, () -> {
            if (this.sortButton.f_93623_) {
                return Arrays.asList(new TranslatableComponent("tooltip.pipez.distribution", new Object[]{new TranslatableComponent("tooltip.pipez.distribution." + pipe.getDistribution(side, this.pipeTypes[this.currentindex]).getName())}).m_7532_());
            }
            return Collections.emptyList();
        });
        this.filterArea = new ScreenBase.HoverArea(7, 55, 20, 20, () -> {
            if (this.filterButton.f_93623_) {
                return Arrays.asList(new TranslatableComponent("tooltip.pipez.filter_mode", new Object[]{new TranslatableComponent("tooltip.pipez.filter_mode." + pipe.getFilterMode(side, this.pipeTypes[this.currentindex]).getName())}).m_7532_());
            }
            return Collections.emptyList();
        });
        this.hoverAreas.add(this.redstoneArea);
        this.hoverAreas.add(this.sortArea);
        this.hoverAreas.add(this.filterArea);
        this.checkButtons();
    }

    protected void m_181908_() {
        super.m_181908_();
        this.checkButtons();
        this.filterList.tick();
    }

    private void checkButtons() {
        Upgrade upgrade = ((ExtractContainer)this.m_6262_()).getPipe().getUpgrade(((ExtractContainer)this.m_6262_()).getSide());
        if (upgrade == null) {
            this.redstoneButton.f_93623_ = false;
            this.sortButton.f_93623_ = false;
            this.filterButton.f_93623_ = false;
            this.addFilterButton.f_93623_ = false;
            this.editFilterButton.f_93623_ = false;
            this.removeFilterButton.f_93623_ = false;
        } else if (upgrade.equals((Object)Upgrade.BASIC)) {
            this.redstoneButton.f_93623_ = true;
            this.sortButton.f_93623_ = false;
            this.filterButton.f_93623_ = false;
            this.addFilterButton.f_93623_ = false;
            this.editFilterButton.f_93623_ = false;
            this.removeFilterButton.f_93623_ = false;
        } else if (upgrade.equals((Object)Upgrade.IMPROVED)) {
            this.redstoneButton.f_93623_ = true;
            this.sortButton.f_93623_ = true;
            this.filterButton.f_93623_ = false;
            this.addFilterButton.f_93623_ = false;
            this.editFilterButton.f_93623_ = false;
            this.removeFilterButton.f_93623_ = false;
        } else {
            this.redstoneButton.f_93623_ = true;
            this.sortButton.f_93623_ = true;
            this.filterButton.f_93623_ = this.pipeTypes[this.currentindex].hasFilter();
            this.addFilterButton.f_93623_ = this.pipeTypes[this.currentindex].hasFilter();
            this.editFilterButton.f_93623_ = this.filterList.getSelected() >= 0;
            this.removeFilterButton.f_93623_ = this.filterList.getSelected() >= 0;
        }
    }

    @Override
    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        super.m_7027_(matrixStack, mouseX, mouseY);
        this.f_96547_.m_92889_(matrixStack, this.f_169604_, 8.0f, (float)(this.f_97727_ - 96 + 3), 0x404040);
        this.filterList.drawGuiContainerForegroundLayer(matrixStack, mouseX, mouseY);
        this.drawHoverAreas(matrixStack, mouseX, mouseY);
    }

    @Override
    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(matrixStack, partialTicks, mouseX, mouseY);
        this.filterList.drawGuiContainerBackgroundLayer(matrixStack, partialTicks, mouseX, mouseY);
        if (this.hasTabs()) {
            int i;
            for (i = 0; i < this.pipeTypes.length; ++i) {
                if (i == this.currentindex) {
                    this.m_93228_(matrixStack, this.f_97735_ - 26 + 3, this.f_97736_ + 5 + 25 * i, 176, 48, 26, 24);
                    continue;
                }
                this.m_93228_(matrixStack, this.f_97735_ - 26 + 3, this.f_97736_ + 5 + 25 * i, 176, 72, 26, 24);
            }
            for (i = 0; i < this.pipeTypes.length; ++i) {
                if (i == this.currentindex) {
                    this.f_96542_.m_174229_((LivingEntity)this.f_96541_.f_91074_, this.pipeTypes[i].getIcon(), this.f_97735_ - 26 + 3 + 4, this.f_97736_ + 5 + 25 * i + 4, 0);
                    continue;
                }
                this.f_96542_.m_174229_((LivingEntity)this.f_96541_.f_91074_, this.pipeTypes[i].getIcon(), this.f_97735_ - 26 + 3 + 4 + 2, this.f_97736_ + 5 + 25 * i + 4, 0);
            }
        }
    }

    public int getTabsX() {
        return this.f_97735_ - this.getTabsWidth();
    }

    public int getTabsY() {
        return this.f_97736_ + 5;
    }

    public int getTabsHeight() {
        if (this.hasTabs()) {
            return 25 * this.tabs.length;
        }
        return 0;
    }

    public int getTabsWidth() {
        return 23;
    }

    public boolean hasTabs() {
        return this.tabs != null;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        Slot sl;
        if (this.filterList.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.hasTabs()) {
            for (int i = 0; i < this.tabs.length; ++i) {
                ScreenBase.HoverArea hoverArea = this.tabs[i];
                if (this.currentindex == i || !hoverArea.isHovered(this.f_97735_, this.f_97736_, (int)mouseX, (int)mouseY)) continue;
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                this.currentindex = i;
                this.m_7856_();
                return true;
            }
        }
        if (ExtractScreen.m_96638_() && (sl = this.getSlotUnderMouse()) != null && !(sl instanceof UpgradeSlot)) {
            this.addQuickFilter(sl.m_7993_());
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void addQuickFilter(ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return;
        }
        if (!this.filterButton.f_93623_) {
            return;
        }
        Filter<?> filter = this.pipeTypes[this.currentindex].createFilter();
        filter.setExactMetadata(true);
        if (filter instanceof ItemFilter) {
            filter.setTag(new SingleElementTag<Item>(stack.m_41720_()));
            if (stack.m_41782_()) {
                filter.setMetadata(stack.m_41783_().m_6426_());
            } else {
                filter.setMetadata(null);
            }
            Main.SIMPLE_CHANNEL.sendToServer((Object)new UpdateFilterMessage(filter, this.currentindex));
        } else if (filter instanceof FluidFilter) {
            FluidUtil.getFluidContained((ItemStack)stack).ifPresent(s -> {
                filter.setTag(new SingleElementTag<Fluid>(s.getFluid()));
                if (s.hasTag()) {
                    filter.setMetadata(s.getTag().m_6426_());
                } else {
                    filter.setMetadata(null);
                }
                Main.SIMPLE_CHANNEL.sendToServer((Object)new UpdateFilterMessage(filter, this.currentindex));
            });
        }
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.filterList.mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        return this.filterList.mouseScrolled(mouseX, mouseY, delta);
    }

    public <T extends GuiEventListener & Widget> T m_142416_(T p_169406_) {
        return (T)super.m_142416_(p_169406_);
    }

    public void addHoverArea(ScreenBase.HoverArea hoverArea) {
        this.hoverAreas.add(hoverArea);
    }
}

