/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.blocks.ModBlockEntityBlock;
import net.kaneka.planttech2.blocks.entity.CropsBlockEntity;
import net.kaneka.planttech2.blocks.entity.machine.CropAuraGeneratorBlockEntity;
import net.kaneka.planttech2.enums.EnumTemperature;
import net.kaneka.planttech2.enums.EnumTraitsInt;
import net.kaneka.planttech2.hashmaps.HashMapCropTraits;
import net.kaneka.planttech2.items.AdvancedAnalyserItem;
import net.kaneka.planttech2.items.AnalyserItem;
import net.kaneka.planttech2.items.CropRemover;
import net.kaneka.planttech2.registries.ModBlocks;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class CropBaseBlock
extends ModBlockEntityBlock {
    public static final IntegerProperty GROWSTATE = IntegerProperty.m_61631_((String)"growstate", (int)0, (int)7);
    private final String entryName;

    public CropBaseBlock(String entryName) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60910_().m_60978_(0.5f));
        this.entryName = entryName;
        this.setRegistryName(entryName + "_crop");
    }

    public void updateCrop(Level level, BlockPos pos, HashMapCropTraits traits) {
        BlockState state = level.m_8055_(pos);
        int growstate = (Integer)state.m_61143_((Property)GROWSTATE);
        if (growstate < 7 && this.canGrow(level, pos, traits)) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)GROWSTATE, (Comparable)Integer.valueOf(growstate + 1)));
        } else {
            List<BlockPos> neighborpos = this.getNeighborBlockPosRandom(pos);
            for (BlockPos blockpos : neighborpos) {
                if (level.m_8055_(blockpos).m_60734_() != ModBlocks.CROPBARS) continue;
                List<BlockPos> cropbarneighbors = this.getNeighborBlockPosRandomExeptOne(blockpos, pos);
                for (BlockPos possiblePartner : cropbarneighbors) {
                    BlockEntity BlockEntity2;
                    BlockState partnerState = level.m_8055_(possiblePartner);
                    if (!(partnerState.m_60734_() instanceof CropBaseBlock) || !((BlockEntity2 = level.m_7702_(possiblePartner)) instanceof CropsBlockEntity)) continue;
                    HashMapCropTraits partnertraits = ((CropsBlockEntity)BlockEntity2).getTraits();
                    level.m_46597_(blockpos, this.m_49966_());
                    BlockEntity blockEntity = level.m_7702_(blockpos);
                    if (!(blockEntity instanceof CropsBlockEntity)) continue;
                    CropsBlockEntity cbe = (CropsBlockEntity)blockEntity;
                    blockEntity = level.m_7702_(pos);
                    if (!(blockEntity instanceof CropsBlockEntity)) continue;
                    CropsBlockEntity cbe2 = (CropsBlockEntity)blockEntity;
                    cbe.setTraits(cbe2.getTraits().calculateNewTraits(partnertraits));
                    break;
                }
                if (level.m_8055_(blockpos).m_60734_() instanceof CropBaseBlock) break;
                level.m_46597_(blockpos, this.m_49966_());
                BlockEntity blockEntity = level.m_7702_(blockpos);
                if (!(blockEntity instanceof CropsBlockEntity)) break;
                CropsBlockEntity cbe = (CropsBlockEntity)blockEntity;
                blockEntity = level.m_7702_(pos);
                if (!(blockEntity instanceof CropsBlockEntity)) break;
                CropsBlockEntity cbe2 = (CropsBlockEntity)blockEntity;
                cbe.setTraits(cbe2.getTraits().copy());
                break;
            }
        }
    }

    public void updateCreative(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        int growstate = (Integer)state.m_61143_((Property)GROWSTATE);
        if (growstate < 7) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)GROWSTATE, (Comparable)Integer.valueOf(7)));
        }
    }

    private List<BlockPos> getNeighborBlockPosRandom(BlockPos pos) {
        ArrayList<BlockPos> neighbors = new ArrayList<BlockPos>();
        neighbors.add(pos.m_142127_());
        neighbors.add(pos.m_142126_());
        neighbors.add(pos.m_142128_());
        neighbors.add(pos.m_142125_());
        Collections.shuffle(neighbors);
        return neighbors;
    }

    private List<BlockPos> getNeighborBlockPosRandomExeptOne(BlockPos pos, BlockPos exept) {
        List<BlockPos> neighbors = this.getNeighborBlockPosRandom(pos);
        neighbors.remove(exept);
        return neighbors;
    }

    private boolean canGrow(Level level, BlockPos pos, HashMapCropTraits traits) {
        List<CropAuraGeneratorBlockEntity> generators = this.getCropAuraGeneratorInRadius(level, pos, 8);
        if (!this.enoughLight(level, pos, traits.getTrait(EnumTraitsInt.LIGHTSENSITIVITY), generators)) {
            return false;
        }
        if (!this.enoughWater(level, pos, traits.getTrait(EnumTraitsInt.WATERSENSITIVITY), generators)) {
            return false;
        }
        if (!this.rightSoil(level, pos, traits.getType(), generators)) {
            return false;
        }
        return this.rightTemperature(level, pos, traits.getType(), traits.getTrait(EnumTraitsInt.TEMPERATURETOLERANCE), generators);
    }

    public String[] canGrowString(Level level, BlockPos pos) {
        String[] messages = new String[10];
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CropsBlockEntity) {
            CropsBlockEntity cbe = (CropsBlockEntity)blockEntity;
            HashMapCropTraits traits = cbe.getTraits();
            List<CropAuraGeneratorBlockEntity> generators = this.getCropAuraGeneratorInRadius(level, pos, 8);
            if (!this.enoughLight(level, pos, traits.getTrait(EnumTraitsInt.LIGHTSENSITIVITY), generators)) {
                messages[1] = "Not enough light";
            }
            if (!this.enoughWater(level, pos, traits.getTrait(EnumTraitsInt.WATERSENSITIVITY), generators)) {
                messages[2] = "Not enough water";
            }
            if (!this.rightSoil(level, pos, traits.getType(), generators)) {
                messages[3] = "Not right soil";
            }
            if (!this.rightTemperature(level, pos, traits.getType(), traits.getTrait(EnumTraitsInt.TEMPERATURETOLERANCE), generators)) {
                messages[4] = "Not right temperature";
            }
        } else {
            messages[0] = "error";
        }
        return messages;
    }

    public boolean enoughLight(Level level, BlockPos pos, int lightsensitivity, List<CropAuraGeneratorBlockEntity> generators) {
        if (!level.isAreaLoaded(pos, 1)) {
            return false;
        }
        int extraLightValueDecrease = this.getCropAuraInRadiusInt(generators, generator -> generator.lightValueDecrease);
        return level.m_46849_(pos, 0) >= 14 - lightsensitivity - extraLightValueDecrease;
    }

    public boolean enoughWater(Level level, BlockPos pos, int waterSensitivity, List<CropAuraGeneratorBlockEntity> generators) {
        int extraWaterRangeDecrease = this.getCropAuraInRadiusInt(generators, generator -> generator.waterRangeDecrease);
        for (BlockPos blockpos$mutableblockpos : BlockPos.m_121940_((BlockPos)pos.m_142082_(-(waterSensitivity += extraWaterRangeDecrease + 1), 0, -waterSensitivity), (BlockPos)pos.m_142082_(waterSensitivity, -1, waterSensitivity))) {
            BlockState state = level.m_8055_(blockpos$mutableblockpos);
            if (state.m_60767_() != Material.f_76305_ && (!state.m_61138_((Property)BlockStateProperties.f_61362_) || !((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue())) continue;
            return true;
        }
        return false;
    }

    public boolean rightSoil(Level level, BlockPos pos, String name, List<CropAuraGeneratorBlockEntity> generators) {
        Block block = PlantTechMain.getCropList().getByName(name).getConfiguration().getSoil().get();
        Block soil = level.m_8055_(pos.m_7495_()).m_60734_();
        List<Block> extraSoils = this.getCropAuraInRadiusList(generators, generator -> generator.soil, block2 -> block2 != Blocks.f_50016_ && block2 != Blocks.f_50627_ && block2 != Blocks.f_50626_);
        return soil == block || soil == ModBlocks.UNIVERSAL_SOIL_INFUSED || extraSoils.contains(soil);
    }

    public boolean rightTemperature(Level level, BlockPos pos, String name, int tolerance, List<CropAuraGeneratorBlockEntity> generators) {
        List<EnumTemperature> extraTemperatures = this.getCropAuraInRadiusNonnullList(generators, generator -> generator.temperature);
        extraTemperatures.add(PlantTechMain.getCropList().getByName(name).getConfiguration().getTemperature());
        float biomeTemp = level.m_7062_().m_47881_(pos).m_47505_(pos);
        return EnumTemperature.inRange(biomeTemp, tolerance, extraTemperatures);
    }

    private List<CropAuraGeneratorBlockEntity> getCropAuraGeneratorInRadius(Level level, BlockPos centre, int radius) {
        ArrayList<CropAuraGeneratorBlockEntity> generators = new ArrayList<CropAuraGeneratorBlockEntity>();
        for (int x = centre.m_123341_() - radius; x < centre.m_123341_() + radius; ++x) {
            for (int y = centre.m_123342_(); y < centre.m_123342_() + 1; ++y) {
                for (int z = centre.m_123343_() - radius; z < centre.m_123343_() + radius; ++z) {
                    CropAuraGeneratorBlockEntity cagbe;
                    BlockEntity te = level.m_7702_(new BlockPos(x, y, z));
                    BlockEntity blockEntity = te;
                    if (!(blockEntity instanceof CropAuraGeneratorBlockEntity) || !(cagbe = (CropAuraGeneratorBlockEntity)blockEntity).consumeEnergy(25)) continue;
                    generators.add(cagbe);
                }
            }
        }
        return generators;
    }

    private int getCropAuraInRadiusInt(List<CropAuraGeneratorBlockEntity> generators, Function<CropAuraGeneratorBlockEntity, Integer> aura) {
        return this.getCropAuraInRadius(generators, aura, present -> true, (max, present) -> present > max).orElse(0);
    }

    private <T> Optional<T> getCropAuraInRadius(List<CropAuraGeneratorBlockEntity> generators, Function<CropAuraGeneratorBlockEntity, T> aura, Predicate<T> predicate, BiPredicate<T, T> compare) {
        Optional highestAura = Optional.empty();
        for (T machineAura : this.getCropAuraInRadiusList(generators, aura, predicate)) {
            if (highestAura.isPresent()) {
                if (!compare.test(highestAura.get(), machineAura)) continue;
                highestAura = Optional.of(machineAura);
                continue;
            }
            highestAura = Optional.of(machineAura);
        }
        return highestAura;
    }

    private <T> List<T> getCropAuraInRadiusNonnullList(List<CropAuraGeneratorBlockEntity> generators, Function<CropAuraGeneratorBlockEntity, T> aura) {
        return this.getCropAuraInRadiusList(generators, aura, Objects::nonNull);
    }

    private <T> List<T> getCropAuraInRadiusList(List<CropAuraGeneratorBlockEntity> generators, Function<CropAuraGeneratorBlockEntity, T> aura, Predicate<T> predicate) {
        ArrayList<T> auras = new ArrayList<T>();
        for (CropAuraGeneratorBlockEntity generator : generators) {
            T present = aura.apply(generator);
            if (!predicate.test(present)) continue;
            auras.add(present);
        }
        return auras;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{GROWSTATE});
    }

    public boolean removedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        return willHarvest && !player.m_7500_() || super.removedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, BlockEntity te, ItemStack stack) {
        super.m_6240_(level, player, pos, state, te, stack);
        level.m_46961_(pos, false);
    }

    public InteractionResult m_6227_(BlockState state, Level levelIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        int growstate = (Integer)state.m_61143_((Property)GROWSTATE);
        if (growstate > 6 && hand.equals((Object)InteractionHand.MAIN_HAND) && !levelIn.f_46443_) {
            ItemStack holdItem = player.m_21120_(InteractionHand.MAIN_HAND);
            if (!holdItem.m_41619_() && (holdItem.m_41720_() instanceof AnalyserItem || holdItem.m_41720_() instanceof AdvancedAnalyserItem || holdItem.m_41720_() instanceof CropRemover)) {
                return InteractionResult.PASS;
            }
            NonNullList drops = NonNullList.m_122779_();
            BlockEntity blockEntity = levelIn.m_7702_(pos);
            if (blockEntity instanceof CropsBlockEntity) {
                CropsBlockEntity cbe = (CropsBlockEntity)blockEntity;
                cbe.dropsRemoveOneSeed((NonNullList<ItemStack>)drops, growstate);
                for (ItemStack stack : drops) {
                    CropBaseBlock.m_49840_((Level)levelIn, (BlockPos)pos, (ItemStack)stack);
                }
                levelIn.m_46597_(pos, (BlockState)state.m_61124_((Property)GROWSTATE, (Comparable)Integer.valueOf(0)));
            }
        }
        return super.m_6227_(state, levelIn, pos, player, hand, ray);
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        ArrayList drops = Lists.newArrayList();
        int growstate = (Integer)state.m_61143_((Property)GROWSTATE);
        Vec3 vec3d = (Vec3)builder.m_78982_(LootContextParams.f_81460_);
        if (vec3d != null) {
            BlockPos pos = new BlockPos(vec3d);
            BlockEntity blockEntity = builder.m_78962_().m_7702_(pos);
            if (blockEntity instanceof CropsBlockEntity) {
                CropsBlockEntity cbe = (CropsBlockEntity)blockEntity;
                cbe.addDrops(drops, growstate);
                drops.add(new ItemStack((ItemLike)ModBlocks.CROPBARS));
            }
        }
        return drops;
    }

    @Override
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public String getEntryName() {
        return this.entryName;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new CropsBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState p_153213_, BlockEntityType<T> p_153214_) {
        return level.m_5776_() ? null : CropsBlockEntity::tick;
    }

    public static class ColorHandler
    implements BlockColor {
        public int m_92566_(BlockState state, BlockAndTintGetter blockDisplayReader, BlockPos pos, int tintindex) {
            if (tintindex == 0) {
                return PlantTechMain.getCropList().getByName(((CropBaseBlock)state.m_60734_()).getEntryName()).getSeedColor();
            }
            return -1;
        }
    }
}

