/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.kaneka.planttech2.blocks.baseclasses.BaseElectricFence;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ElectricFenceGate
extends Block {
    public static final DirectionProperty HORIZONTAL_FACING = DirectionProperty.m_61546_((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final BooleanProperty OPEN = BooleanProperty.m_61465_((String)"open");
    public static final BooleanProperty IS_TOP = BooleanProperty.m_61465_((String)"is_top");
    public static final VoxelShape FRAME_Z = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)1.0, (double)16.0, (double)10.0), (VoxelShape)Block.m_49796_((double)15.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0));
    public static final VoxelShape FRAME_X = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)1.0), (VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)15.0, (double)10.0, (double)16.0, (double)16.0));
    public static final VoxelShape FRAME_TOP_Z = Block.m_49796_((double)0.0, (double)15.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    public static final VoxelShape FRAME_TOP_X = Block.m_49796_((double)6.0, (double)15.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    public static final VoxelShape DOOR_CLOSE_Z = Block.m_49796_((double)1.0, (double)0.0, (double)7.0, (double)15.0, (double)16.0, (double)9.0);
    public static final VoxelShape DOOR_CLOSE_X = Block.m_49796_((double)7.0, (double)0.0, (double)1.0, (double)9.0, (double)16.0, (double)15.0);
    public static final VoxelShape DOOR_NEGATIVE_Z = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)16.0, (double)15.0);
    public static final VoxelShape DOOR_POSITIVE_Z = Block.m_49796_((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public static final VoxelShape DOOR_NEGATIVE_X = Block.m_49796_((double)1.0, (double)0.0, (double)13.0, (double)15.0, (double)16.0, (double)15.0);
    public static final VoxelShape DOOR_POSITIVE_X = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)3.0);

    public ElectricFenceGate(BlockBehaviour.Properties property) {
        super(property.m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)IS_TOP, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HORIZONTAL_FACING, OPEN, IS_TOP});
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor levelIn, BlockPos currentPos, BlockPos facingPos) {
        BlockState state;
        if (!this.checkValid(currentPos, (Level)levelIn)) {
            levelIn.m_46961_(currentPos, (Boolean)stateIn.m_61143_((Property)IS_TOP) == false);
        }
        if ((state = levelIn.m_8055_((Boolean)stateIn.m_61143_((Property)IS_TOP) != false ? currentPos.m_7495_() : currentPos.m_7494_())).m_60734_() instanceof ElectricFenceGate) {
            return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)HORIZONTAL_FACING, (Comparable)((Direction)state.m_61143_((Property)HORIZONTAL_FACING)))).m_61124_((Property)OPEN, (Comparable)((Boolean)state.m_61143_((Property)OPEN)))).m_61124_((Property)IS_TOP, (Comparable)((Boolean)stateIn.m_61143_((Property)IS_TOP)));
        }
        return stateIn;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        if (blockpos.m_123342_() < 255 && context.m_43725_().m_8055_(blockpos.m_7494_()).m_60629_(context)) {
            return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)HORIZONTAL_FACING, (Comparable)context.m_8125_())).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)IS_TOP, (Comparable)Boolean.valueOf(false));
        }
        return null;
    }

    public InteractionResult m_6227_(BlockState state, Level levelIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!this.checkValid(pos, levelIn)) {
            levelIn.m_46961_(pos, (Boolean)state.m_61143_((Property)IS_TOP) == false);
            return InteractionResult.FAIL;
        }
        if (!this.isPowered(levelIn, pos)) {
            return InteractionResult.FAIL;
        }
        levelIn.m_46597_(pos, (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)HORIZONTAL_FACING, (Comparable)((Direction)state.m_61143_((Property)HORIZONTAL_FACING)))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)OPEN) == false))).m_61124_((Property)IS_TOP, (Comparable)((Boolean)state.m_61143_((Property)IS_TOP))));
        levelIn.m_5898_(player, (Boolean)state.m_61143_((Property)OPEN) != false ? 1005 : 1011, pos, 0);
        return InteractionResult.SUCCESS;
    }

    private boolean isPowered(Level level, BlockPos pos) {
        return BaseElectricFence.calculatePower(level, pos) > 0;
    }

    public void m_6402_(Level levelIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        levelIn.m_46597_(pos.m_7494_(), (BlockState)((BlockState)((BlockState)state.m_61124_((Property)HORIZONTAL_FACING, (Comparable)((Direction)state.m_61143_((Property)HORIZONTAL_FACING)))).m_61124_((Property)OPEN, (Comparable)((Boolean)state.m_61143_((Property)OPEN)))).m_61124_((Property)IS_TOP, (Comparable)Boolean.valueOf(true)));
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter levelIn, BlockPos pos, CollisionContext context) {
        return this.m_5940_(state, levelIn, pos, context);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter levelIn, BlockPos pos, CollisionContext context) {
        VoxelShape shape;
        Direction facing = (Direction)state.m_61143_((Property)HORIZONTAL_FACING);
        boolean open = (Boolean)state.m_61143_((Property)OPEN);
        boolean top = (Boolean)state.m_61143_((Property)IS_TOP);
        switch (facing) {
            default: {
                shape = DOOR_CLOSE_Z;
                if (!open) break;
                shape = top ? this.toTopShape(DOOR_NEGATIVE_Z) : DOOR_NEGATIVE_Z;
                break;
            }
            case SOUTH: {
                shape = DOOR_CLOSE_Z;
                if (!open) break;
                shape = top ? this.toTopShape(DOOR_POSITIVE_Z) : DOOR_POSITIVE_Z;
                break;
            }
            case WEST: {
                shape = DOOR_CLOSE_X;
                if (!open) break;
                shape = top ? this.toTopShape(DOOR_NEGATIVE_X) : DOOR_NEGATIVE_X;
                break;
            }
            case EAST: {
                shape = DOOR_CLOSE_X;
                if (!open) break;
                shape = top ? this.toTopShape(DOOR_POSITIVE_X) : DOOR_POSITIVE_X;
            }
        }
        switch (facing.m_122434_()) {
            default: {
                shape = this.add(shape, FRAME_Z);
                if (!top) break;
                shape = this.add(shape, FRAME_TOP_Z);
                break;
            }
            case X: {
                shape = this.add(shape, FRAME_X);
                if (!top) break;
                shape = this.add(shape, FRAME_TOP_X);
            }
        }
        return shape;
    }

    private VoxelShape add(VoxelShape shape, VoxelShape shape2) {
        return Shapes.m_83110_((VoxelShape)shape, (VoxelShape)shape2);
    }

    private VoxelShape toTopShape(VoxelShape shape) {
        AABB aabb = shape.m_83215_();
        return Block.m_49796_((double)(aabb.f_82288_ * 16.0), (double)(aabb.f_82289_ * 16.0 - 1.0), (double)(aabb.f_82290_ * 16.0), (double)(aabb.f_82291_ * 16.0), (double)(aabb.f_82292_ * 16.0 - 1.0), (double)(aabb.f_82293_ * 16.0));
    }

    private boolean checkValid(BlockPos pos, Level level) {
        BlockState state = level.m_8055_(pos);
        BlockState state2 = level.m_8055_((Boolean)state.m_61143_((Property)IS_TOP) != false ? pos.m_7495_() : pos.m_7494_());
        return state2.m_60734_() instanceof ElectricFenceGate && state.m_61143_((Property)IS_TOP) != state2.m_61143_((Property)IS_TOP);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter levelIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)new TextComponent("can be dismantled by wrench"));
    }
}

