/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.kaneka.planttech2.registries.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;

public class GrowingBlock
extends Block {
    public static final IntegerProperty GROWINGSTATE = IntegerProperty.m_61631_((String)"growingstate", (int)0, (int)6);
    protected final Supplier<Block> blockSupplier;
    protected boolean growAlone;

    public GrowingBlock(Supplier<Block> blockSupplier, boolean growAlone) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(SoundType.f_56743_).m_60978_(0.9f).m_60977_());
        this.blockSupplier = blockSupplier;
        this.growAlone = growAlone;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)GROWINGSTATE, (Comparable)Integer.valueOf(0)));
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random rand) {
        if (this.growAlone) {
            this.grow(state, level, pos);
        }
    }

    public void grow(BlockState state, ServerLevel level, BlockPos pos) {
        int i = (Integer)state.m_61143_((Property)GROWINGSTATE);
        if (i < 6) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)GROWINGSTATE, (Comparable)Integer.valueOf(i + 1)));
        } else {
            this.placeBlock(level, pos, state);
        }
    }

    protected void placeBlock(ServerLevel level, BlockPos pos, BlockState state) {
        level.m_46597_(pos, this.getBlock().m_49966_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{GROWINGSTATE});
    }

    public Block getBlock() {
        return this.blockSupplier.get();
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        ArrayList drops = Lists.newArrayList();
        Block block = state.m_60734_();
        if (block == ModBlocks.COMPRESSOR_GROWING || block == ModBlocks.MACHINEBULBREPROCESSOR_GROWING || block == ModBlocks.SEEDSQUEEZER_GROWING || block == ModBlocks.INFUSER_GROWING || block == ModBlocks.IDENTIFIER_GROWING) {
            drops.add(new ItemStack((ItemLike)ModBlocks.MACHINESHELL_IRON));
        } else if (block == ModBlocks.MACHINESHELL_IRON_GROWING) {
            drops.add(new ItemStack((ItemLike)Blocks.f_50075_));
        } else if (block == ModBlocks.MACHINESHELL_PLANTIUM_GROWING) {
            drops.add(new ItemStack((ItemLike)ModBlocks.PLANTIUM_BLOCK));
        } else {
            drops.add(new ItemStack((ItemLike)ModBlocks.MACHINESHELL_PLANTIUM));
        }
        return drops;
    }
}

