/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.baseclasses;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.kaneka.planttech2.blocks.machines.EnergySupplierBlock;
import net.kaneka.planttech2.registries.ModDamageSources;
import net.kaneka.planttech2.registries.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class BaseElectricFence
extends Block {
    public static final IntegerProperty ELECTRIC_POWER = IntegerProperty.m_61631_((String)"electric_power", (int)0, (int)15);

    public BaseElectricFence(BlockBehaviour.Properties property) {
        super(property.m_60955_().m_60953_(p -> 6));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ELECTRIC_POWER});
    }

    public static int calculatePower(Level levelIn, BlockPos pos) {
        int fencePower = 0;
        for (Direction direction : Direction.values()) {
            int power;
            BlockState state = levelIn.m_8055_(pos.m_142300_(direction));
            Block block = state.m_60734_();
            if (block instanceof EnergySupplierBlock && ((Boolean)state.m_61143_((Property)EnergySupplierBlock.SUPPLYING)).booleanValue()) {
                return 15;
            }
            if (!(block instanceof BaseElectricFence) || !state.m_61138_((Property)ELECTRIC_POWER) || (power = ((Integer)state.m_61143_((Property)ELECTRIC_POWER)).intValue()) <= fencePower) continue;
            fencePower = power - 1;
        }
        return fencePower;
    }

    public void m_7892_(BlockState state, Level levelIn, BlockPos pos, Entity entityIn) {
        if ((Integer)state.m_61143_((Property)ELECTRIC_POWER) > 0 && levelIn.m_46467_() % 8L == 0L) {
            if (entityIn instanceof LivingEntity) {
                if (levelIn.m_46471_() && levelIn.m_45527_(pos)) {
                    entityIn.m_6469_(ModDamageSources.ELECTRIC_FENCE, 5.0f);
                    if (levelIn.f_46443_) {
                        this.doCollideAnimation(pos, levelIn, 1, ParticleTypes.f_123755_, SoundEvents.f_11937_, 0.75f, 50.0f);
                    }
                } else {
                    entityIn.m_6469_(ModDamageSources.ELECTRIC_FENCE, 2.5f);
                    if (levelIn.f_46443_) {
                        this.doCollideAnimation(pos, levelIn, 1, ParticleTypes.f_123762_, SoundEvents.f_11937_, 0.55f, 20.0f);
                    }
                }
            } else {
                entityIn.m_142687_(Entity.RemovalReason.KILLED);
                if (levelIn.f_46443_) {
                    this.doCollideAnimation(pos, levelIn, 7, ParticleTypes.f_123762_, SoundEvents.f_11937_, 0.8f, 20.0f);
                }
            }
        }
    }

    private void doCollideAnimation(BlockPos pos, Level levelIn, int amount, SimpleParticleType particle, SoundEvent sound, float volume, float pitch) {
        double x = pos.m_123341_();
        double y = pos.m_123342_();
        double z = pos.m_123343_();
        Random random = new Random();
        levelIn.m_7785_(x + 0.5, y + 0.5, z + 0.5, sound, SoundSource.BLOCKS, volume, pitch, false);
        for (int i = 0; i < amount; ++i) {
            levelIn.m_7106_((ParticleOptions)particle, x + (double)random.nextFloat(), y + (double)random.nextFloat(), z + (double)random.nextFloat(), 0.0, 0.0, 0.0);
        }
    }

    public void m_7100_(BlockState stateIn, Level levelIn, BlockPos pos, Random rand) {
        if ((Integer)stateIn.m_61143_((Property)ELECTRIC_POWER) > 0 && rand.nextInt(350) == 1 && levelIn.f_46443_) {
            this.doCollideAnimation(pos, levelIn, 1, ParticleTypes.f_123797_, ModSounds.ELECTRIC_FENCE_IDLE, 0.05f, 1.0f);
        }
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter levelIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)new TextComponent("can be dismantled by wrench, connect to a powered energy supplier or electric fence to activate"));
    }
}

