/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.baseclasses;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CustomDoorBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.f_61394_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);

    public CustomDoorBlock(BlockBehaviour.Properties builder) {
        super(builder);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_(HINGE, (Comparable)DoorHingeSide.LEFT)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction enumfacing = (Direction)state.m_61143_((Property)FACING);
        boolean flag = (Boolean)state.m_61143_((Property)OPEN) == false;
        boolean flag1 = state.m_61143_(HINGE) == DoorHingeSide.RIGHT;
        return switch (enumfacing) {
            default -> {
                if (flag) {
                    yield EAST_AABB;
                }
                if (flag1) {
                    yield NORTH_AABB;
                }
                yield SOUTH_AABB;
            }
            case Direction.SOUTH -> {
                if (flag) {
                    yield SOUTH_AABB;
                }
                if (flag1) {
                    yield EAST_AABB;
                }
                yield WEST_AABB;
            }
            case Direction.WEST -> {
                if (flag) {
                    yield WEST_AABB;
                }
                if (flag1) {
                    yield SOUTH_AABB;
                }
                yield NORTH_AABB;
            }
            case Direction.NORTH -> flag ? NORTH_AABB : (flag1 ? WEST_AABB : EAST_AABB);
        };
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)stateIn.m_61143_(HALF);
        if (facing.m_122434_() == Direction.Axis.Y && doubleblockhalf == DoubleBlockHalf.LOWER == (facing == Direction.UP)) {
            return facingState.m_60734_() == this && facingState.m_61143_(HALF) != doubleblockhalf ? (BlockState)((BlockState)((BlockState)((BlockState)stateIn.m_61124_((Property)FACING, (Comparable)((Direction)facingState.m_61143_((Property)FACING)))).m_61124_((Property)OPEN, (Comparable)((Boolean)facingState.m_61143_((Property)OPEN)))).m_61124_(HINGE, (Comparable)((DoorHingeSide)facingState.m_61143_(HINGE)))).m_61124_((Property)POWERED, (Comparable)((Boolean)facingState.m_61143_((Property)POWERED))) : Blocks.f_50016_.m_49966_();
        }
        return doubleblockhalf == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity be, ItemStack stack) {
        super.m_6240_(level, player, pos, Blocks.f_50016_.m_49966_(), be, stack);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.m_61143_(HALF);
        BlockPos blockpos = doubleblockhalf == DoubleBlockHalf.LOWER ? pos.m_7494_() : pos.m_7495_();
        BlockState blockstate = level.m_8055_(blockpos);
        if (blockstate.m_60734_() == this && blockstate.m_61143_(HALF) != doubleblockhalf) {
            level.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 35);
            level.m_5898_(player, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
            ItemStack itemstack = player.m_21205_();
            if (!level.f_46443_ && !player.m_7500_()) {
                Block.m_49881_((BlockState)state, (Level)level, (BlockPos)pos, null, (Entity)player, (ItemStack)itemstack);
                Block.m_49881_((BlockState)blockstate, (Level)level, (BlockPos)blockpos, null, (Entity)player, (ItemStack)itemstack);
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return switch (type) {
            case PathComputationType.LAND, PathComputationType.AIR -> (Boolean)state.m_61143_((Property)OPEN);
            case PathComputationType.WATER -> false;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    private int getCloseSound() {
        return this.f_60442_ == Material.f_76279_ ? 1011 : 1012;
    }

    private int getOpenSound() {
        return this.f_60442_ == Material.f_76279_ ? 1005 : 1006;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        if (blockpos.m_123342_() < 255 && context.m_43725_().m_8055_(blockpos.m_7494_()).m_60629_(context)) {
            Level level = context.m_43725_();
            boolean hasSignal = level.m_46753_(blockpos) || level.m_46753_(blockpos.m_7494_());
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_(HINGE, (Comparable)this.getHingeSide(context))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(hasSignal))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(hasSignal))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        level.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    private DoorHingeSide getHingeSide(BlockPlaceContext context) {
        boolean flag1;
        Level iblockreader = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        Direction direction = context.m_8125_();
        BlockPos blockpos1 = blockpos.m_7494_();
        Direction direction1 = direction.m_122428_();
        BlockPos blockpos2 = blockpos.m_142300_(direction1);
        BlockState blockstate = iblockreader.m_8055_(blockpos2);
        BlockPos blockpos3 = blockpos1.m_142300_(direction1);
        BlockState blockstate1 = iblockreader.m_8055_(blockpos3);
        Direction direction2 = direction.m_122427_();
        BlockPos blockpos4 = blockpos.m_142300_(direction2);
        BlockState blockstate2 = iblockreader.m_8055_(blockpos4);
        BlockPos blockpos5 = blockpos1.m_142300_(direction2);
        BlockState blockstate3 = iblockreader.m_8055_(blockpos5);
        int i = (CustomDoorBlock.m_49916_((VoxelShape)blockstate.m_60812_((BlockGetter)iblockreader, blockpos2)) ? -1 : 0) + (CustomDoorBlock.m_49916_((VoxelShape)blockstate1.m_60812_((BlockGetter)iblockreader, blockpos3)) ? -1 : 0) + (CustomDoorBlock.m_49916_((VoxelShape)blockstate2.m_60812_((BlockGetter)iblockreader, blockpos4)) ? 1 : 0) + (CustomDoorBlock.m_49916_((VoxelShape)blockstate3.m_60812_((BlockGetter)iblockreader, blockpos5)) ? 1 : 0);
        boolean flag = blockstate.m_60734_() == this && blockstate.m_61143_(HALF) == DoubleBlockHalf.LOWER;
        boolean bl = flag1 = blockstate2.m_60734_() == this && blockstate2.m_61143_(HALF) == DoubleBlockHalf.LOWER;
        if ((!flag || flag1) && i <= 0) {
            if ((!flag1 || flag) && i >= 0) {
                int j = direction.m_122429_();
                int k = direction.m_122431_();
                Vec3 vec3d = context.m_43720_();
                double d0 = vec3d.f_82479_ - (double)blockpos.m_123341_();
                double d1 = vec3d.f_82481_ - (double)blockpos.m_123343_();
                return !(j < 0 && d1 < 0.5 || j > 0 && d1 > 0.5 || k < 0 && d0 > 0.5 || k > 0 && d0 < 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
            }
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (this.f_60442_ == Material.f_76279_) {
            return InteractionResult.FAIL;
        }
        state = (BlockState)state.m_61122_((Property)OPEN);
        level.m_7731_(pos, state, 10);
        level.m_5898_(player, (Boolean)state.m_61143_((Property)OPEN) != false ? this.getOpenSound() : this.getCloseSound(), pos, 0);
        return InteractionResult.SUCCESS;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        BlockState blockstate = level.m_8055_(blockpos);
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            return Block.m_49863_((LevelReader)level, (BlockPos)blockpos, (Direction)Direction.UP);
        }
        return blockstate.m_60734_() == this;
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return mirrorIn == Mirror.NONE ? state : (BlockState)state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING))).m_61122_(HINGE);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HALF, FACING, OPEN, HINGE, POWERED});
    }
}

