/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.entity;

import java.util.List;
import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.blocks.CropBaseBlock;
import net.kaneka.planttech2.enums.EnumTraitsInt;
import net.kaneka.planttech2.hashmaps.HashMapCropTraits;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.registries.ModTileEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class CropsBlockEntity
extends BlockEntity {
    private long startTick = 0L;
    private HashMapCropTraits traits = new HashMapCropTraits();

    public CropsBlockEntity() {
        this(BlockPos.f_121853_, ModBlocks.CROPBARS.m_49966_());
    }

    public CropsBlockEntity(BlockPos pos, BlockState state) {
        super(ModTileEntities.CROPS_TE, pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BlockEntity be) {
        BlockEntity blockEntity;
        if (level != null && !level.f_46443_ && (blockEntity = be) instanceof CropsBlockEntity) {
            Block block;
            Block block2;
            CropsBlockEntity cbe = (CropsBlockEntity)blockEntity;
            if ((level.m_46467_() - cbe.startTick) % ((90L - (long)cbe.traits.getTrait(EnumTraitsInt.GROWSPEED) * 6L) * 20L) == 0L && (block2 = (block = level.m_8055_(cbe.f_58858_).m_60734_())) instanceof CropBaseBlock) {
                CropBaseBlock cbb = (CropBaseBlock)block2;
                cbb.updateCrop(cbe.f_58857_, cbe.f_58858_, cbe.traits);
            }
        }
    }

    public void setTraits(HashMapCropTraits traits) {
        this.traits = traits;
    }

    public boolean isAnalysed() {
        return this.traits.isAnalysed();
    }

    public HashMapCropTraits setAnalysedAndGetTraits() {
        this.traits.setAnalysed(true);
        return this.getTraits();
    }

    public HashMapCropTraits getTraits() {
        return this.traits;
    }

    public String getCropType() {
        return this.traits.getType();
    }

    public void setStartTick() {
        this.startTick = this.f_58857_.m_46467_();
    }

    public List<ItemStack> addDrops(List<ItemStack> drops, int growstate) {
        PlantTechMain.getCropList().getByName(this.traits.getType()).calculateDrops(drops, this.traits, growstate, this.f_58857_.f_46441_);
        return drops;
    }

    public void dropsRemoveOneSeed(NonNullList<ItemStack> drops, int growstate) {
        PlantTechMain.getCropList().getByName(this.traits.getType()).calculateDropsReduced(drops, this.traits, growstate, this.f_58857_.f_46441_);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbtTagCompound = new CompoundTag();
        this.m_6945_(nbtTagCompound);
        return nbtTagCompound;
    }

    public CompoundTag m_6945_(CompoundTag compound) {
        super.m_6945_(compound);
        compound.m_128356_("starttick", this.startTick);
        compound = this.traits.addToNBT(compound);
        return compound;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.startTick = compound.m_128454_("starttick");
        this.traits.fromNBT(compound);
    }
}

