/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.entity.cable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.kaneka.planttech2.blocks.entity.cable.Connection;
import net.kaneka.planttech2.registries.ModTileEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class CableBlockEntity
extends BlockEntity {
    private BlockPos masterPos = null;
    private boolean isMaster = false;
    private int[] connections = new int[]{0, 0, 0, 0, 0, 0};
    private int maxTransferRate = 20;
    private boolean connectionUpdated = true;
    private final List<BlockPos> cables = new ArrayList<BlockPos>();
    private final HashMap<Integer, List<Connection>> connectionsMaster = new HashMap<Integer, List<Connection>>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(0, new ArrayList());
            this.put(1, new ArrayList());
        }
    };
    HashMap<BlockPos, Direction> producer = new HashMap();
    HashMap<BlockPos, Direction> consumer = new HashMap();
    HashMap<BlockPos, Direction> storages = new HashMap();

    public CableBlockEntity(BlockPos pos, BlockState state) {
        super(ModTileEntities.CABLE_TE, pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BlockEntity be) {
        BlockEntity blockEntity;
        if (level != null && !level.f_46443_ && (blockEntity = be) instanceof CableBlockEntity) {
            CableBlockEntity cbe = (CableBlockEntity)blockEntity;
            if (cbe.connectionUpdated) {
                cbe.transferEnergy();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void transferEnergy() {
        IEnergyStorage cap;
        int maxNeeded = 0;
        int maxSupplied = 0;
        int maxStorragesNeeded = 0;
        int maxStorragesSupplied = 0;
        int amountConsumer = 0;
        int amountProducer = 0;
        int amountStorages = 0;
        if (this.connectionUpdated) {
            this.producer.clear();
            this.consumer.clear();
            this.storages.clear();
            for (Connection connection : this.connectionsMaster.get(0)) {
                cap = this.getEnergyCap(connection.getConnectedPos(), connection.getFacing().m_122424_());
                if (cap == null || this.consumer.containsKey(connection.getConnectedPos())) continue;
                this.consumer.put(connection.getConnectedPos(), connection.getFacing().m_122424_());
            }
            for (Connection connection : this.connectionsMaster.get(1)) {
                cap = this.getEnergyCap(connection.getConnectedPos(), connection.getFacing().m_122424_());
                if (cap == null || this.producer.containsKey(connection.getConnectedPos())) continue;
                this.producer.put(connection.getConnectedPos(), connection.getFacing().m_122424_());
            }
            List intersect_PC = this.producer.keySet().stream().filter(x -> this.consumer.containsKey(x)).collect(Collectors.toList());
            this.producer.entrySet().removeIf(entry -> intersect_PC.contains(entry.getKey()));
            this.consumer.entrySet().removeIf(entry -> intersect_PC.contains(entry.getKey()));
            for (Connection con : this.connectionsMaster.get(0)) {
                cap = this.getEnergyCap(con.getConnectedPos(), con.getFacing().m_122424_());
                if (cap == null || this.storages.containsKey(con.getConnectedPos()) || !intersect_PC.contains(con.getConnectedPos())) continue;
                this.storages.put(con.getConnectedPos(), con.getFacing().m_122424_());
            }
            this.connectionUpdated = false;
        }
        for (Map.Entry<BlockPos, Direction> entry2 : this.producer.entrySet()) {
            cap = this.getEnergyCap(entry2.getKey(), entry2.getValue());
            if (cap == null) continue;
            maxSupplied += cap.extractEnergy(this.maxTransferRate, true);
            ++amountProducer;
        }
        for (Map.Entry<BlockPos, Direction> entry3 : this.consumer.entrySet()) {
            cap = this.getEnergyCap(entry3.getKey(), entry3.getValue());
            if (cap == null) continue;
            maxNeeded += cap.receiveEnergy(this.maxTransferRate, true);
            ++amountConsumer;
        }
        for (Map.Entry<BlockPos, Direction> entry4 : this.storages.entrySet()) {
            cap = this.getEnergyCap(entry4.getKey(), entry4.getValue());
            if (cap == null) continue;
            maxStorragesSupplied += cap.extractEnergy(this.maxTransferRate, true);
            maxStorragesNeeded += cap.receiveEnergy(this.maxTransferRate, true);
            ++amountStorages;
        }
        if (maxNeeded + maxStorragesNeeded > 0 && maxSupplied + maxStorragesSupplied > 0) {
            int perMachineConsumer = 0;
            boolean bl = false;
            int perMachineStoragesIn = 0;
            int perMachineStoragesOut = 0;
            int leftoverConsumer = 0;
            int leftoverProducer = 0;
            int leftoverStorageIn = 0;
            int leftoverStorageOut = 0;
            if (maxNeeded > maxSupplied) {
                int maxSuppliedBoth = maxSupplied + maxStorragesSupplied;
                int n = this.maxTransferRate;
                if (maxNeeded > maxSuppliedBoth) {
                    perMachineStoragesOut = this.maxTransferRate;
                    perMachineConsumer = maxSuppliedBoth / amountConsumer;
                    leftoverConsumer = maxSuppliedBoth - perMachineConsumer * amountConsumer;
                } else {
                    perMachineStoragesOut = (maxNeeded - maxSupplied) / amountStorages;
                    leftoverStorageOut = maxNeeded - maxSupplied - perMachineStoragesOut * amountStorages;
                    perMachineConsumer = this.maxTransferRate;
                }
            } else if (maxNeeded < maxSupplied) {
                int maxNeededBoth = maxNeeded + maxStorragesNeeded;
                if (maxNeededBoth < maxSupplied) {
                    int n = maxNeededBoth / amountProducer;
                    leftoverProducer = maxNeededBoth - n * amountProducer;
                    perMachineStoragesIn = this.maxTransferRate;
                } else {
                    int n = this.maxTransferRate;
                    perMachineStoragesIn = (maxSupplied - maxNeeded) / amountStorages;
                    leftoverStorageIn = maxSupplied - maxNeeded - perMachineStoragesIn * amountStorages;
                }
                perMachineConsumer = this.maxTransferRate;
            } else {
                int n = this.maxTransferRate;
                perMachineConsumer = this.maxTransferRate;
            }
            for (Map.Entry<BlockPos, Direction> entry3 : this.producer.entrySet()) {
                void var10_27;
                cap = this.getEnergyCap(entry3.getKey(), entry3.getValue());
                if (cap == null) continue;
                if (leftoverProducer > 0) {
                    cap.extractEnergy((int)(var10_27 + true), false);
                    --leftoverProducer;
                    continue;
                }
                cap.extractEnergy((int)var10_27, false);
            }
            for (Map.Entry<BlockPos, Direction> entry5 : this.consumer.entrySet()) {
                cap = this.getEnergyCap(entry5.getKey(), entry5.getValue());
                if (cap == null) continue;
                if (leftoverConsumer > 0) {
                    cap.receiveEnergy(perMachineConsumer + 1, false);
                    --leftoverConsumer;
                    continue;
                }
                cap.receiveEnergy(perMachineConsumer, false);
            }
            for (Map.Entry<BlockPos, Direction> entry5 : this.storages.entrySet()) {
                cap = this.getEnergyCap(entry5.getKey(), entry5.getValue());
                if (cap == null) continue;
                if (perMachineStoragesIn > 0) {
                    if (leftoverStorageIn > 0) {
                        cap.receiveEnergy(perMachineStoragesIn + 1, false);
                        --leftoverStorageIn;
                    } else {
                        cap.receiveEnergy(perMachineStoragesIn, false);
                    }
                }
                if (perMachineStoragesOut <= 0) continue;
                if (leftoverStorageOut > 0) {
                    cap.extractEnergy(perMachineStoragesOut + 1, false);
                    --leftoverStorageOut;
                    continue;
                }
                cap.extractEnergy(perMachineStoragesOut, false);
            }
        }
    }

    public BlockPos getMasterPos() {
        return this.masterPos;
    }

    public void setMasterPos(BlockPos pos) {
        this.masterPos = pos;
    }

    public int getConnection(Direction facing) {
        return this.connections[facing.m_122411_()];
    }

    public void setConnection(Direction facing, int i) {
        if (0 <= i && i < 5) {
            CableBlockEntity te = this.getTECable(this.masterPos);
            if (te != null) {
                te.changeConnectionMaster(this.f_58858_, facing, this.connections[facing.m_122411_()], i);
            }
            this.connections[facing.m_122411_()] = i;
        }
    }

    public void changeConnectionMaster(BlockPos pos, Direction facing, int fromState, int toState) {
        if (fromState > 1) {
            this.connectionsMaster.get(fromState - 2).removeIf(x -> x.areEqual(pos, facing));
        }
        if (toState > 1 && this.connectionsMaster.get(toState - 2).stream().noneMatch(x -> x.areEqual(pos, facing))) {
            this.connectionsMaster.get(toState - 2).add(new Connection(pos, facing));
        }
        this.connectionUpdated = true;
    }

    private void removeValues() {
        this.masterPos = null;
        if (this.isMaster) {
            this.removeMaster(null);
        }
    }

    public void setAsMaster() {
        this.isMaster = true;
        this.masterPos = this.f_58858_;
        this.cables.add(this.f_58858_);
        this.connectionUpdated = true;
    }

    public void removeMaster(@Nullable BlockPos newMaster) {
        this.isMaster = false;
        this.masterPos = newMaster;
        this.cables.clear();
        for (int i = 0; i < this.connectionsMaster.size(); ++i) {
            this.connectionsMaster.get(i).clear();
        }
    }

    public void addCable(BlockPos pos) {
        this.cables.add(pos);
    }

    public void removeCable(BlockPos pos) {
        this.cables.remove(pos);
    }

    public void initCable(BlockState state) {
        if (this.f_58857_ != null) {
            ArrayList<BlockPos> neighborMaster = new ArrayList<BlockPos>();
            for (Direction facing : Direction.values()) {
                CableBlockEntity te = this.getTECable(this.f_58858_.m_142300_(facing));
                if (te == null || neighborMaster.contains(te.getMasterPos())) continue;
                neighborMaster.add(te.getMasterPos());
            }
            switch (neighborMaster.size()) {
                case 0: {
                    this.setAsMaster();
                    this.masterPos = this.f_58858_;
                    break;
                }
                case 1: {
                    CableBlockEntity te = this.getTECable((BlockPos)neighborMaster.get(0));
                    if (te == null) break;
                    te.addCable(this.f_58858_);
                    this.setMasterPos(te.m_58899_());
                    break;
                }
                default: {
                    this.combineAndAdd(neighborMaster);
                }
            }
            this.checkConnections(false);
            this.m_6596_();
        }
    }

    public void deleteCable() {
        CableBlockEntity cable;
        ArrayList<BlockPos> neighborCables = new ArrayList<BlockPos>();
        if (this.f_58857_ == null) {
            return;
        }
        for (Direction facing : Direction.values()) {
            BlockEntity te = this.f_58857_.m_7702_(this.m_58899_().m_142300_(facing));
            if (!(te instanceof CableBlockEntity)) continue;
            neighborCables.add(this.f_58858_.m_142300_(facing));
        }
        if (this.isMaster) {
            if (neighborCables.size() == 1) {
                CableBlockEntity newMaster = (CableBlockEntity)this.f_58857_.m_7702_((BlockPos)neighborCables.get(0));
                if (newMaster != null) {
                    this.transferMastery(newMaster, this);
                    newMaster.removeCable(this.f_58858_);
                }
            } else if (neighborCables.size() > 1) {
                this.recreateNetworks(neighborCables, this.cables);
            }
        } else if (neighborCables.size() == 1) {
            cable = this.getTECable((BlockPos)neighborCables.get(0));
            if (cable != null) {
                cable.removeCable(this.f_58858_);
            }
        } else if (neighborCables.size() > 1 && (cable = this.getTECable((BlockPos)neighborCables.get(0))) != null) {
            this.recreateNetworks(neighborCables, cable.getCableList());
        }
    }

    public void recreateNetworks(List<BlockPos> neighborCables, List<BlockPos> cables) {
        CableBlockEntity te;
        ArrayList<BlockPos> cableCopy = new ArrayList<BlockPos>(cables);
        for (BlockPos cablePos : cableCopy) {
            te = this.getTECable(cablePos);
            if (te == null) continue;
            te.removeValues();
        }
        for (BlockPos neighborCable : neighborCables) {
            te = this.getTECable(neighborCable);
            if (te == null || te.getMasterPos() != null) continue;
            te.setAsMaster();
            te.sendConnections();
            te.spreadPos(this.f_58858_);
        }
    }

    public void spreadPos(BlockPos exception) {
        for (Direction facing : Direction.values()) {
            CableBlockEntity te;
            BlockPos nextPos = this.f_58858_.m_142300_(facing);
            if (nextPos.equals((Object)exception) || (te = this.getTECable(nextPos)) == null || te.getMasterPos() != null) continue;
            te.setMasterPos(this.masterPos);
            CableBlockEntity cable = this.getTECable(te.getMasterPos());
            if (cable != null) {
                cable.addCable(te.m_58899_());
            }
            te.sendConnections();
            te.spreadPos(exception);
        }
    }

    private void sendConnections() {
        CableBlockEntity te = this.getTECable(this.masterPos);
        if (te != null) {
            for (Direction facing : Direction.values()) {
                if (this.connections[facing.m_122411_()] <= 1) continue;
                te.changeConnectionMaster(this.f_58858_, facing, 0, this.connections[facing.m_122411_()]);
            }
        }
    }

    public void combineAndAdd(List<BlockPos> list) {
        CableBlockEntity newMaster = this.getTECable(list.get(0));
        list.remove(0);
        if (newMaster != null) {
            for (BlockPos oldMasterPos : list) {
                CableBlockEntity oldMaster = this.getTECable(oldMasterPos);
                if (oldMaster == null) continue;
                this.transferMastery(newMaster, oldMaster);
            }
            newMaster.addCable(this.m_58899_());
            this.setMasterPos(newMaster.m_58899_());
        }
    }

    public HashMap<Integer, List> getLists() {
        HashMap<Integer, List> lists = new HashMap<Integer, List>();
        lists.put(0, this.cables);
        lists.put(1, this.connectionsMaster.get(0));
        lists.put(2, this.connectionsMaster.get(1));
        return lists;
    }

    public void setLists(HashMap<Integer, List> lists) {
        this.cables.addAll(lists.get(0));
        this.connectionsMaster.get(0).addAll(lists.get(1));
        this.connectionsMaster.get(1).addAll(lists.get(2));
    }

    public List<BlockPos> getCableList() {
        return this.cables;
    }

    private void setCableMasterPos(BlockPos pos) {
        for (BlockPos cablePos : this.cables) {
            CableBlockEntity cable = this.getTECable(cablePos);
            if (cable == null) continue;
            cable.setMasterPos(pos);
        }
    }

    private void transferMastery(CableBlockEntity newMaster, CableBlockEntity oldMaster) {
        oldMaster.setCableMasterPos(newMaster.getMasterPos());
        newMaster.setAsMaster();
        newMaster.setLists(oldMaster.getLists());
        oldMaster.removeMaster(newMaster.getMasterPos());
        this.m_6596_();
    }

    public CompoundTag m_6945_(CompoundTag compound) {
        compound.m_128379_("ismaster", this.isMaster);
        if (this.masterPos != null) {
            compound.m_128405_("masterposx", this.masterPos.m_123341_());
            compound.m_128405_("masterposy", this.masterPos.m_123342_());
            compound.m_128405_("masterposz", this.masterPos.m_123343_());
        }
        if (!this.cables.isEmpty()) {
            ListTag cableList = new ListTag();
            this.cables.stream().forEach(x -> cableList.add((Object)NbtUtils.m_129224_((BlockPos)x)));
            compound.m_128365_("cables", (Tag)cableList);
        }
        if (this.connections.length == 6) {
            compound.m_128385_("connections", this.connections);
        }
        for (int i = 0; i < 2; ++i) {
            if (this.connectionsMaster.get(i).size() <= 0) continue;
            List<Connection> connections = this.connectionsMaster.get(i);
            ListTag connectionlist = new ListTag();
            for (Connection con : connections) {
                connectionlist.add((Object)con.serializeConnection());
            }
            compound.m_128365_("connections_" + i, (Tag)connectionlist);
        }
        return super.m_6945_(compound);
    }

    public void m_142466_(CompoundTag compound) {
        ListTag cableList;
        super.m_142466_(compound);
        if (compound.m_128441_("ismaster")) {
            this.isMaster = compound.m_128471_("ismaster");
        }
        if (compound.m_128441_("masterposx")) {
            this.masterPos = new BlockPos(compound.m_128451_("masterposx"), compound.m_128451_("masterposy"), compound.m_128451_("masterposz"));
        }
        if ((cableList = compound.m_128437_("cables", 10)).size() > 0) {
            this.cables.clear();
            for (int i = 0; i < cableList.size(); ++i) {
                this.cables.add(NbtUtils.m_129239_((CompoundTag)cableList.m_128728_(i)));
            }
        }
        if (compound.m_128441_("connections")) {
            this.connections = compound.m_128465_("connections");
        }
        for (int i = 0; i < 2; ++i) {
            ListTag list;
            if (!compound.m_128441_("connections_" + i) || (list = compound.m_128437_("connections_" + i, 10)).size() <= 0) continue;
            this.connectionsMaster.get(i).clear();
            for (int k = 0; k < list.size(); ++k) {
                this.connectionsMaster.get(i).add(new Connection().deserializeConnection(list.m_128728_(k)));
            }
        }
    }

    private IEnergyStorage getEnergyCap(BlockPos pos, Direction facing) {
        if (this.f_58857_ == null) {
            return null;
        }
        BlockEntity te = this.f_58857_.m_7702_(pos);
        if (te != null && te.getCapability(CapabilityEnergy.ENERGY, facing).isPresent()) {
            return (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, facing).orElse(null);
        }
        return null;
    }

    public void checkConnections(boolean neighborChanged) {
        boolean shouldSendChanges = false;
        if (this.f_58857_ == null) {
            return;
        }
        for (Direction facing : Direction.values()) {
            BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_142300_(facing));
            if (te != null) {
                if (te instanceof CableBlockEntity) {
                    if (this.getConnection(facing) == 1) continue;
                    this.setConnection(facing, 1);
                    shouldSendChanges = true;
                    continue;
                }
                if (!te.getCapability(CapabilityEnergy.ENERGY, facing).isPresent() || this.getConnection(facing) >= 2) continue;
                this.setConnection(facing, 2);
                shouldSendChanges = true;
                continue;
            }
            if (this.getConnection(facing) == 0) continue;
            this.setConnection(facing, 0);
            shouldSendChanges = true;
        }
        if (!this.f_58857_.f_46443_) {
            if (shouldSendChanges) {
                this.sendUpdates();
            }
            if (neighborChanged) {
                this.connectionUpdated = true;
            }
        }
    }

    private void sendUpdates() {
        if (this.f_58857_ != null) {
            this.f_58857_.markAndNotifyBlock(this.f_58858_, this.f_58857_.m_46745_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 0, 512);
        }
    }

    public void rotateConnection(Direction dir) {
        this.rotateConnection(dir.m_122411_());
    }

    public void rotateConnection(int i) {
        int next = this.connections[i] + 1;
        if (next > 3) {
            next = 2;
        }
        this.setConnection(Direction.m_122376_((int)i), next);
    }

    private CableBlockEntity getTECable(BlockPos pos) {
        BlockEntity te;
        BlockEntity blockEntity;
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && (blockEntity = (te = this.f_58857_.m_7702_(pos))) instanceof CableBlockEntity) {
            CableBlockEntity cbe = (CableBlockEntity)blockEntity;
            return cbe;
        }
        return null;
    }
}

