/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.entity.cable;

import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;

public class CableInfo {
    public BlockPos masterPos = BlockPos.f_121853_;
    public boolean isMaster = false;
    public HashSet<BlockPos> slaves = new HashSet();
    public HashSet<Connection> producers = new HashSet();
    public HashSet<Connection> consumers = new HashSet();
    public HashSet<Connection> storages = new HashSet();
    public int[] connections = new int[]{0, 0, 0, 0, 0, 0};

    public CableInfo() {
    }

    public CableInfo(CompoundTag compound) {
        this.masterPos = NbtUtils.m_129239_((CompoundTag)compound);
        this.isMaster = compound.m_128471_("ismaster");
        this.connections = compound.m_128465_("connections");
        if (this.isMaster) {
            this.slaves = this.readBlockPosList(compound, "slaves");
            this.producers = this.readBlockPosWithDirectionList(compound, "producers");
            this.consumers = this.readBlockPosWithDirectionList(compound, "consumers");
            this.storages = this.readBlockPosWithDirectionList(compound, "storages");
        }
    }

    public CompoundTag write() {
        CompoundTag compound = NbtUtils.m_129224_((BlockPos)this.masterPos);
        compound.m_128379_("ismaster", this.isMaster);
        compound.m_128385_("connections", this.connections);
        if (this.isMaster) {
            this.writeBlockPosList(compound, "slaves", this.slaves);
            this.writeBlockPosWithDirectionList(compound, "producers", this.producers, true);
            this.writeBlockPosWithDirectionList(compound, "consumers", this.consumers, true);
            this.writeBlockPosWithDirectionList(compound, "storages", this.storages, true);
        }
        return compound;
    }

    private void writeBlockPosList(CompoundTag compound, String key, HashSet<BlockPos> targetList) {
        HashSet<Connection> connections = new HashSet<Connection>();
        targetList.forEach(pos -> connections.add(new Connection((BlockPos)pos, Direction.UP)));
        this.writeBlockPosWithDirectionList(compound, key, connections, false);
    }

    private void writeBlockPosWithDirectionList(CompoundTag compound, String key, HashSet<Connection> targetList, boolean direction) {
        CompoundTag subCompound = new CompoundTag();
        ArrayList x = new ArrayList();
        ArrayList y = new ArrayList();
        ArrayList z = new ArrayList();
        ArrayList d = new ArrayList();
        targetList.forEach(connection -> {
            BlockPos blockPos = connection.blockPos;
            x.add(blockPos.m_123341_());
            y.add(blockPos.m_123342_());
            z.add(blockPos.m_123343_());
            if (direction) {
                d.add(connection.direction.m_122411_());
            }
        });
        subCompound.m_128408_("x", x);
        subCompound.m_128408_("y", y);
        subCompound.m_128408_("z", z);
        if (direction) {
            subCompound.m_128408_("d", d);
        }
        compound.m_128365_(key, (Tag)subCompound);
    }

    private HashSet<Connection> readBlockPosWithDirectionList(CompoundTag compound, String key) {
        HashSet<Connection> connections = new HashSet<Connection>();
        CompoundTag subCompound = compound.m_128469_(key);
        int[] x = subCompound.m_128465_("x");
        int[] y = subCompound.m_128465_("y");
        int[] z = subCompound.m_128465_("z");
        int[] d = subCompound.m_128465_("d");
        for (int i = 0; i < subCompound.m_128465_("x").length; ++i) {
            connections.add(new Connection(new BlockPos(x[i], y[i], z[i]), Direction.m_122376_((int)d[i])));
        }
        return connections;
    }

    private HashSet<BlockPos> readBlockPosList(CompoundTag compound, String key) {
        HashSet<BlockPos> blockPos = new HashSet<BlockPos>();
        CompoundTag subCompound = compound.m_128469_(key);
        int[] x = subCompound.m_128465_("x");
        int[] y = subCompound.m_128465_("y");
        int[] z = subCompound.m_128465_("z");
        for (int i = 0; i < subCompound.m_128465_("x").length; ++i) {
            blockPos.add(new BlockPos(x[i], y[i], z[i]));
        }
        return blockPos;
    }

    public CableInfo clear(boolean keepConnection) {
        CableInfo newInfo = new CableInfo();
        if (keepConnection) {
            newInfo.connections = (int[])this.connections.clone();
        }
        return newInfo;
    }

    public static class Connection {
        public BlockPos blockPos = BlockPos.f_121853_;
        public Direction direction = Direction.UP;

        public Connection() {
        }

        public Connection(BlockPos blockPos, Direction direction) {
            this.blockPos = blockPos;
            this.direction = direction;
        }
    }
}

