/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.entity.cable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.kaneka.planttech2.blocks.entity.cable.CableInfo;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.registries.ModTileEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TestCableBlockEntity
extends BlockEntity {
    public CableInfo cableInfo = new CableInfo();
    public int maxTransferRate = 20;

    public TestCableBlockEntity() {
        this(BlockPos.f_121853_, ModBlocks.CABLE.m_49966_());
    }

    public TestCableBlockEntity(BlockPos pos, BlockState state) {
        super(ModTileEntities.CABLE_TE, pos, state);
    }

    public void tick() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_() && this.isMaster()) {
            this.transferEnergy();
        }
    }

    private void transferEnergy() {
        AtomicInteger energyRequired = new AtomicInteger();
        AtomicInteger energySupplied = new AtomicInteger();
        for (CableInfo.Connection consumer : this.info().consumers) {
            this.receiveEnergy(consumer, capability -> energyRequired.addAndGet(capability.receiveEnergy(this.getMaxTransferRate(), true)));
        }
        for (CableInfo.Connection producer : this.info().producers) {
            this.extractEnergy(producer, capability -> energySupplied.addAndGet(capability.extractEnergy(this.getMaxTransferRate(), true)));
        }
        AtomicInteger energyAvailable = new AtomicInteger(Math.min(energySupplied.get(), energyRequired.get()));
        AtomicInteger energyAvailable2 = new AtomicInteger(energyAvailable.get());
        for (CableInfo.Connection consumer : this.info().consumers) {
            this.receiveEnergy(consumer, capability -> energyAvailable.addAndGet(-capability.receiveEnergy(Math.min(energyAvailable.get(), this.getMaxTransferRate()), false)));
        }
        for (CableInfo.Connection producer : this.info().producers) {
            this.extractEnergy(producer, capability -> energyAvailable2.addAndGet(-capability.extractEnergy(Math.min(energyAvailable2.get(), this.getMaxTransferRate()), false)));
        }
    }

    private void receiveEnergy(CableInfo.Connection consumer, Consumer<IEnergyStorage> transfer) {
        IEnergyStorage capability = this.getEnergyCap(consumer.blockPos, consumer.direction.m_122424_());
        if (capability != null && capability.canReceive()) {
            transfer.accept(capability);
        }
    }

    private void extractEnergy(CableInfo.Connection producer, Consumer<IEnergyStorage> transfer) {
        IEnergyStorage capability = this.getEnergyCap(producer.blockPos, producer.direction.m_122424_());
        if (capability != null && capability.canExtract()) {
            transfer.accept(capability);
        }
    }

    public CompoundTag m_6945_(CompoundTag compound) {
        compound.m_128365_("cableinfo", (Tag)this.cableInfo.write());
        return super.m_6945_(compound);
    }

    public void initCable() {
        this.checkConnections();
        ArrayList<BlockPos> masters = new ArrayList<BlockPos>();
        this.getAllConnected(cable -> {
            BlockPos masterPos = cable.getMasterPos();
            if (!masters.contains(masterPos)) {
                masters.add(masterPos);
            }
        });
        if (!masters.isEmpty()) {
            if (masters.size() == 1) {
                TestCableBlockEntity master = this.getCableTE(masters.get(0));
                if (master != null) {
                    master.addCableToNetwork(this);
                }
                return;
            }
            TestCableBlockEntity largestNetwork = this.getLargestNetwork(masters);
            if (largestNetwork != null) {
                largestNetwork.addCableToNetwork(this);
                masters.remove(largestNetwork.m_58899_());
                masters.forEach(pos -> largestNetwork.mergeNetworks(this.getCableTE((BlockPos)pos)));
                return;
            }
        }
        this.createNetwork();
        this.getMasterCable().addMachinesFrom(this);
        this.m_6596_();
    }

    public void addCableToNetwork(TestCableBlockEntity cable) {
        if (!this.isMaster()) {
            return;
        }
        this.info().slaves.add(cable.m_58899_());
        cable.updateMaster(this);
        this.addMachinesFrom(cable);
        this.m_6596_();
    }

    public List<BlockPos> getAllConnections(BlockPos master) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        positions.add(master);
        return this.getAllConnections(positions);
    }

    public List<BlockPos> getAllConnections(HashSet<BlockPos> connected) {
        return this.getAllConnections(new ArrayList<BlockPos>(connected));
    }

    public List<BlockPos> getAllConnections(ArrayList<BlockPos> connected) {
        for (Direction direction : Direction.values()) {
            TestCableBlockEntity cable;
            BlockPos pos = this.m_58899_().m_142300_(direction);
            if (connected.contains(pos) || (cable = this.getCableTE(pos)) == null) continue;
            connected.add(pos);
            cable.getAllConnections(connected);
        }
        return connected;
    }

    public void refresh() {
        if (this.f_58857_ == null || !this.isMaster()) {
            return;
        }
        this.clear(true);
        this.setIsMaster(true);
        this.getAllConnections(this.m_58899_()).forEach(pos -> {
            TestCableBlockEntity cable;
            if (!pos.equals((Object)this.m_58899_()) && (cable = this.getCableTE((BlockPos)pos)) != null) {
                this.info().slaves.add((BlockPos)pos);
                cable.updateMaster(this);
                this.addMachinesFrom(cable);
            }
        });
        this.addMachinesFrom(this);
        this.m_6596_();
    }

    public void addMachinesFrom(TestCableBlockEntity cable) {
        int[] connections = cable.getConnections();
        for (int i = 0; i < connections.length; ++i) {
            CableInfo.Connection connection = new CableInfo.Connection(cable.m_58899_().m_142300_(Direction.m_122376_((int)i)), Direction.m_122376_((int)i));
            if (connections[i] < 2) {
                this.removeConsumer(connection);
                this.removeProducer(connection);
            }
            if (connections[i] == 2) {
                this.addConsumer(connection);
            }
            if (connections[i] != 3) continue;
            this.addProducer(connection);
        }
    }

    public void createNetwork() {
        if (this.f_58857_ == null) {
            return;
        }
        this.setIsMaster(true);
        this.refresh();
    }

    @Nullable
    public TestCableBlockEntity getLargestNetwork(ArrayList<BlockPos> masterPositions) {
        BlockPos largest = BlockPos.f_121853_;
        for (BlockPos pos : masterPositions) {
            TestCableBlockEntity largestCable = this.getCableTE(largest);
            TestCableBlockEntity targetCable = this.getCableTE(pos);
            if (largestCable != null) {
                if (targetCable == null || largestCable.info().slaves.size() >= targetCable.info().slaves.size()) continue;
                largest = pos;
                continue;
            }
            if (targetCable == null) continue;
            largest = pos;
        }
        return largest.equals((Object)BlockPos.f_121853_) ? null : this.getCableTE(largest);
    }

    public void checkConnections() {
        if (this.f_58857_ == null) {
            return;
        }
        for (Direction direction : Direction.values()) {
            BlockEntity te = this.f_58857_.m_7702_(this.m_58899_().m_142300_(direction));
            if (te != null) {
                if (te instanceof TestCableBlockEntity) {
                    if (this.getConnection(direction) == 1) continue;
                    this.setConnection(direction, 1);
                    continue;
                }
                if (!te.getCapability(CapabilityEnergy.ENERGY, direction).isPresent() || this.getConnection(direction) >= 2) continue;
                this.setConnection(direction, 2);
                continue;
            }
            if (this.getConnection(direction) == 0) continue;
            this.setConnection(direction, 0);
        }
        this.m_6596_();
    }

    public void m_7651_() {
        if (this.getMasterCable() != null) {
            this.getMasterCable().forceReplaceMaster();
            this.getMasterCable().getSlaves().remove(this.m_58899_());
        }
    }

    public void forceReplaceMaster() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.info().slaves.isEmpty()) {
            return;
        }
        for (BlockPos slave : this.info().slaves) {
            TestCableBlockEntity cable2 = this.getCableTE(slave);
            if (cable2 == null) continue;
            cable2.clear(true);
        }
        this.getAllConnected(cable -> {
            if (cable.getMasterPos().equals((Object)BlockPos.f_121853_)) {
                cable.createNetwork();
            }
        });
        this.m_6596_();
    }

    public void findNewMaster() {
        TestCableBlockEntity cable;
        if (this.f_58857_ == null || !this.isMaster()) {
            return;
        }
        ArrayList<BlockPos> slaves = new ArrayList<BlockPos>(this.info().slaves);
        if (!slaves.isEmpty() && (cable = this.getCableTE(slaves.get(0))) != null) {
            cable.setAsMaster(this);
        }
    }

    public void mergeNetworks(TestCableBlockEntity otherMaster) {
        if (this.f_58857_ == null || !this.info().isMaster || otherMaster == null) {
            return;
        }
        CableInfo i = otherMaster.info();
        this.info().slaves.addAll(i.slaves);
        this.info().producers.addAll(i.producers);
        this.info().consumers.addAll(i.consumers);
        this.info().storages.addAll(i.storages);
        otherMaster.clear(true);
        this.info().slaves.add(otherMaster.m_58899_());
        this.updateSlavesMasterInfo();
    }

    public void setAsMaster(@Nullable TestCableBlockEntity oldMaster) {
        if (this.f_58857_ == null) {
            return;
        }
        this.setIsMaster(true);
        if (oldMaster != null) {
            CableInfo i = oldMaster.info();
            this.info().masterPos = oldMaster.m_58899_();
            this.info().slaves = i.slaves;
            this.info().producers = i.producers;
            this.info().consumers = i.consumers;
            this.info().storages = i.storages;
            this.updateSlavesMasterInfo();
        }
    }

    public void updateMaster(TestCableBlockEntity master) {
        this.updateMaster(master.m_58899_());
    }

    public void updateMaster(BlockPos master) {
        this.info().masterPos = master;
        this.info().isMaster = false;
    }

    public void updateSlavesMasterInfo() {
        if (!this.isMaster()) {
            return;
        }
        this.info().slaves.forEach(slave -> {
            TestCableBlockEntity cable = this.getCableTE((BlockPos)slave);
            if (cable != null) {
                cable.updateMaster(this);
            }
        });
        this.m_6596_();
    }

    public boolean getAllConnected(Consumer<TestCableBlockEntity> message) {
        boolean changed = false;
        for (Direction direction : Direction.values()) {
            TestCableBlockEntity cable = this.getCableTE(this.m_58899_().m_142300_(direction));
            if (cable == null) continue;
            message.accept(cable);
            changed = true;
        }
        return changed;
    }

    private IEnergyStorage getEnergyCap(BlockPos pos, Direction facing) {
        LazyOptional capability;
        if (this.f_58857_ == null) {
            return null;
        }
        BlockEntity tileentity = this.f_58857_.m_7702_(pos);
        if (tileentity != null && (capability = tileentity.getCapability(CapabilityEnergy.ENERGY, facing)).isPresent()) {
            return (IEnergyStorage)capability.orElseThrow(() -> new NullPointerException("Trying to get null energy capability for block " + tileentity.m_58900_().m_60734_().getRegistryName().toString() + " at " + pos));
        }
        return null;
    }

    public int getMaxTransferRate() {
        return this.maxTransferRate;
    }

    public ArrayList<BlockPos> getPositionsOf(HashSet<CableInfo.Connection> connections) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        connections.forEach(connection -> positions.add(connection.blockPos));
        return positions;
    }

    public void setConnection(Direction facing, int i) {
        this.getConnections()[facing.m_122411_()] = i;
        if (this.getMasterCable() != null) {
            this.getMasterCable().addMachinesFrom(this);
        }
    }

    public int getConnection(Direction direction) {
        return this.getConnections()[direction.m_122411_()];
    }

    public void rotateConnection(Direction direction) {
        this.rotateConnection(direction.m_122411_());
    }

    public void rotateConnection(int direction) {
        int next = this.getConnections()[direction] + 1;
        if (next > 3) {
            next = 2;
        }
        this.setConnection(Direction.m_122376_((int)direction), next);
    }

    public ArrayList<BlockPos> getAllCables() {
        ArrayList<BlockPos> cables = new ArrayList<BlockPos>(this.info().slaves);
        cables.add(this.info().masterPos);
        return cables;
    }

    public void addConsumer(CableInfo.Connection connection) {
        if (!this.isMaster()) {
            return;
        }
        if (!this.contains(this.info().consumers, connection)) {
            this.info().consumers.add(connection);
            this.removeProducer(connection);
        }
    }

    public void addProducer(CableInfo.Connection connection) {
        if (!this.isMaster()) {
            return;
        }
        if (!this.contains(this.info().producers, connection)) {
            this.info().producers.add(connection);
            this.removeConsumer(connection);
        }
    }

    public void removeConsumer(CableInfo.Connection connection) {
        if (!this.isMaster()) {
            return;
        }
        this.remove(this.info().consumers, connection);
    }

    public void removeProducer(CableInfo.Connection connection) {
        if (!this.isMaster()) {
            return;
        }
        this.remove(this.info().producers, connection);
    }

    public boolean contains(Collection<CableInfo.Connection> connections, CableInfo.Connection newConnection) {
        return connections.stream().anyMatch(connection -> this.equals((CableInfo.Connection)connection, newConnection));
    }

    public void remove(Collection<CableInfo.Connection> connections, CableInfo.Connection newConnection) {
        connections.removeIf(connection -> this.equals((CableInfo.Connection)connection, newConnection));
    }

    public boolean equals(CableInfo.Connection connection, CableInfo.Connection connection2) {
        return connection.blockPos.equals((Object)connection2.blockPos) && connection.direction == connection2.direction;
    }

    public CableInfo info() {
        return this.cableInfo;
    }

    public void setIsMaster(boolean value) {
        this.info().isMaster = value;
        this.info().masterPos = this.m_58899_();
        this.info().slaves.remove(this.m_58899_());
    }

    public boolean isMaster() {
        return this.info().isMaster;
    }

    public BlockPos getMasterPos() {
        return this.info().masterPos;
    }

    public HashSet<BlockPos> getSlaves() {
        return this.info().slaves;
    }

    public HashSet<CableInfo.Connection> getConsumers() {
        return this.info().consumers;
    }

    public HashSet<CableInfo.Connection> getProducers() {
        return this.info().producers;
    }

    public HashSet<CableInfo.Connection> getStorages() {
        return this.info().storages;
    }

    public int[] getConnections() {
        return this.info().connections;
    }

    public void clear(boolean keepConnection) {
        this.cableInfo = this.cableInfo.clear(keepConnection);
        this.checkConnections();
    }

    @Nullable
    public TestCableBlockEntity getMasterCable() {
        return this.getCableTE(this.getMasterPos());
    }

    @Nullable
    public TestCableBlockEntity getCableTE(BlockPos pos) {
        if (this.f_58857_ == null) {
            return null;
        }
        BlockEntity tileEntity = this.f_58857_.m_7702_(pos);
        return tileEntity instanceof TestCableBlockEntity ? (TestCableBlockEntity)tileEntity : null;
    }
}

