/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.entity.machine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.kaneka.planttech2.blocks.entity.machine.baseclasses.ConvertEnergyInventoryBlockEntity;
import net.kaneka.planttech2.inventory.CompressorMenu;
import net.kaneka.planttech2.recipes.ModRecipeTypes;
import net.kaneka.planttech2.recipes.recipeclasses.CompressorRecipe;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.registries.ModTileEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RangedWrapper;
import org.apache.commons.lang3.tuple.Pair;

public class CompressorBlockEntity
extends ConvertEnergyInventoryBlockEntity {
    private int selectedId = -1;
    private HashMap<Integer, Pair<ItemStack, Integer>> recipeList = new HashMap();
    private Item previousInput = null;
    private final RangedWrapper inputs;
    private final RangedWrapper outputs;
    private final LazyOptional<IItemHandler> inputs_provider;
    private final LazyOptional<IItemHandler> outputs_provider;
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> CompressorBlockEntity.this.energystorage.getEnergyStored();
                case 1 -> CompressorBlockEntity.this.energystorage.getMaxEnergyStored();
                case 2 -> CompressorBlockEntity.this.ticksPassed;
                case 3 -> CompressorBlockEntity.this.selectedId;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    CompressorBlockEntity.this.energystorage.setEnergyStored(value);
                    break;
                }
                case 1: {
                    CompressorBlockEntity.this.energystorage.setEnergyMaxStored(value);
                    break;
                }
                case 2: {
                    CompressorBlockEntity.this.ticksPassed = value;
                    break;
                }
                case 3: {
                    CompressorBlockEntity.this.setSelectedId(value);
                }
            }
        }

        public int m_6499_() {
            return 7;
        }
    };

    public CompressorBlockEntity() {
        this(BlockPos.f_121853_, ModBlocks.COMPRESSOR.m_49966_());
    }

    public CompressorBlockEntity(BlockPos pos, BlockState state) {
        super(ModTileEntities.COMPRESSOR_TE, pos, state, 1000, 26, 1);
        this.inputs = new RangedWrapper((IItemHandlerModifiable)this.itemhandler, 0, 1);
        this.outputs = new RangedWrapper((IItemHandlerModifiable)this.itemhandler, 1, 2);
        this.inputs_provider = LazyOptional.of(() -> this.inputs);
        this.outputs_provider = LazyOptional.of(() -> this.outputs);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.DOWN) {
                return this.outputs_provider.cast();
            }
            if (facing != null) {
                return this.inputs_provider.cast();
            }
            return this.inventoryCap.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    protected boolean canProceed(ItemStack input, ItemStack output) {
        boolean recipeDone = false;
        boolean inputDone = false;
        if (this.recipeList == null || this.previousInput != input.m_41720_()) {
            this.initRecipeList();
        }
        if (this.getSelectedId() >= 0) {
            if (!this.recipeList.isEmpty() && this.recipeList.size() > this.getSelectedId()) {
                recipeDone = true;
                boolean bl = inputDone = (Integer)this.recipeList.get(this.getSelectedId()).getValue() <= input.m_41613_();
                if (inputDone) {
                    this.previousInput = input.m_41720_();
                }
            } else {
                this.setSelectedId(-1);
            }
        }
        return this.getSelectedId() >= 0 && recipeDone && inputDone;
    }

    private int getSelectedId() {
        return this.selectedId - 1;
    }

    @Override
    protected boolean onProcessFinished(ItemStack input, ItemStack output) {
        ItemStack result = this.getResult(input, output);
        if (this.itemhandler.insertItem(this.getOutputSlotIndex(), result, false).m_41619_()) {
            input.m_41774_(((Integer)this.recipeList.get(this.getSelectedId()).getValue()).intValue());
            return true;
        }
        return false;
    }

    @Override
    protected ItemStack getResult(ItemStack input, ItemStack output) {
        return ((ItemStack)this.recipeList.get(this.getSelectedId()).getKey()).m_41777_();
    }

    @Override
    public ContainerData getContainerData() {
        return this.data;
    }

    public void setSelectedId(int selectedId) {
        this.selectedId = selectedId + 1;
        this.notifyClient();
    }

    @Override
    public void onContainerUpdated(int slotIndex) {
        if (this.f_58857_ != null && (this.previousInput == null || this.previousInput.m_5456_() != this.itemhandler.getStackInSlot(0).m_41720_())) {
            this.initRecipeList();
        }
    }

    public void initRecipeList() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        for (int i = 0; i < 20; ++i) {
            this.itemhandler.setStackInSlot(i + 3, ItemStack.f_41583_);
        }
        this.selectedId = -1;
        this.previousInput = null;
        HashMap<Integer, Pair> temprecipeList = new HashMap<Integer, Pair>();
        ArrayList<Integer> keys = new ArrayList<Integer>();
        this.recipeList = new HashMap();
        ItemStack particleStack = this.itemhandler.getStackInSlot(0);
        if (!particleStack.m_41619_()) {
            Item particle = particleStack.m_41720_();
            if (this.f_58857_ != null) {
                for (Recipe recipe : this.f_58857_.m_7465_().m_44013_(ModRecipeTypes.COMPRESSING)) {
                    CompressorRecipe compRecipe = (CompressorRecipe)recipe;
                    if (compRecipe.getInput().m_41720_() != particle) continue;
                    temprecipeList.put(Item.m_41393_((Item)compRecipe.m_8043_().m_41720_()), Pair.of((Object)compRecipe.m_8043_(), (Object)compRecipe.getAmountInput()));
                    keys.add(Item.m_41393_((Item)compRecipe.m_8043_().m_41720_()));
                    this.previousInput = particle;
                }
            }
        }
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            this.recipeList.put(i, (Pair<ItemStack, Integer>)((Pair)temprecipeList.get(keys.get(i))));
            this.itemhandler.setStackInSlot(i + 3, (ItemStack)((Pair)temprecipeList.get(keys.get(i))).getLeft());
        }
        this.resetProgress(false);
    }

    @Override
    public String getNameString() {
        return "compressor";
    }

    @Override
    public List<ItemStack> getInventoryContent() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < 3; ++i) {
            stacks.add(this.itemhandler.getStackInSlot(i).m_41777_());
        }
        return stacks;
    }

    public CompoundTag m_5995_() {
        return this.m_6945_(new CompoundTag());
    }

    @Override
    public CompoundTag m_6945_(CompoundTag compound) {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            compound.m_128405_("selectedId", this.getSelectedId());
        }
        return super.m_6945_(compound);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("selectedId")) {
            this.setSelectedId(compound.m_128451_("selectedId"));
        }
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return new CompressorMenu(id, inv, this);
    }

    @Override
    public int getEnergyInSlot() {
        return 23;
    }

    @Override
    public int getEnergyOutSlot() {
        return 24;
    }

    @Override
    public int getKnowledgeChipSlot() {
        return 25;
    }

    @Override
    public int getKnowledgePerAction() {
        return 2;
    }

    @Override
    public int getUpgradeSlot() {
        return 2;
    }

    @Override
    public boolean requireSyncUponOpen() {
        return true;
    }
}

