/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.entity.machine;

import javax.annotation.Nullable;
import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.blocks.entity.machine.baseclasses.EnergyInventoryBlockEntity;
import net.kaneka.planttech2.crops.CropEntry;
import net.kaneka.planttech2.hashmaps.HashMapCropTraits;
import net.kaneka.planttech2.inventory.IdentifierMenu;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.registries.ModTileEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class IdentifierBlockEntity
extends EnergyInventoryBlockEntity {
    private final RangedWrapper inputs;
    private final RangedWrapper outputs;
    private final LazyOptional<IItemHandler> inputs_provider;
    private final LazyOptional<IItemHandler> outputs_provider;
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> IdentifierBlockEntity.this.energystorage.getEnergyStored();
                case 1 -> IdentifierBlockEntity.this.energystorage.getMaxEnergyStored();
                case 2 -> IdentifierBlockEntity.this.ticksPassed;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    IdentifierBlockEntity.this.energystorage.setEnergyStored(value);
                    break;
                }
                case 1: {
                    IdentifierBlockEntity.this.energystorage.setEnergyMaxStored(value);
                    break;
                }
                case 2: {
                    IdentifierBlockEntity.this.ticksPassed = value;
                }
            }
        }

        public int m_6499_() {
            return 3;
        }
    };

    public IdentifierBlockEntity() {
        this(BlockPos.f_121853_, ModBlocks.IDENTIFIER.m_49966_());
    }

    public IdentifierBlockEntity(BlockPos pos, BlockState state) {
        super(ModTileEntities.IDENTIFIER_TE, pos, state, 10000, 22, 1);
        this.inputs = new RangedWrapper((IItemHandlerModifiable)this.itemhandler, 0, 9);
        this.outputs = new RangedWrapper((IItemHandlerModifiable)this.itemhandler, 9, 18);
        this.inputs_provider = LazyOptional.of(() -> this.inputs);
        this.outputs_provider = LazyOptional.of(() -> this.outputs);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.DOWN) {
                return this.outputs_provider.cast();
            }
            if (facing != null) {
                return this.inputs_provider.cast();
            }
            return this.inventoryCap.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void doUpdate() {
        super.doUpdate();
        if (this.energystorage.getEnergyStored() > this.energyPerAction()) {
            if (this.canIdentify()) {
                this.energystorage.extractEnergy(this.energyPerAction(), false);
                ++this.ticksPassed;
                if (this.ticksPassed >= this.ticksPerItem()) {
                    this.identifyItem();
                    this.ticksPassed = 0;
                }
            } else {
                this.ticksPassed = 0;
            }
        } else if (!this.canIdentify() && this.ticksPassed > 0) {
            this.ticksPassed = 0;
        }
    }

    @Override
    public ContainerData getContainerData() {
        return this.data;
    }

    private boolean canIdentify() {
        if (!this.hasFreeOutputSlot()) {
            return false;
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.itemhandler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            CompoundTag nbt = stack.m_41783_();
            if (nbt != null) {
                if (!nbt.m_128441_("analysed") || nbt.m_128471_("analysed")) continue;
                return true;
            }
            return PlantTechMain.getCropList().getBySeed(stack.m_41720_()) != null;
        }
        return false;
    }

    public void identifyItem() {
        if (this.canIdentify()) {
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = this.itemhandler.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                CompoundTag nbt = stack.m_41783_();
                if (nbt != null) {
                    if (!nbt.m_128441_("analysed") || nbt.m_128471_("analysed")) continue;
                    nbt.m_128379_("analysed", true);
                    stack.m_41751_(nbt);
                    this.itemhandler.setStackInSlot(this.getFreeOutputSlot(), stack);
                    this.itemhandler.setStackInSlot(i, ItemStack.f_41583_);
                    this.addKnowledge();
                    break;
                }
                CropEntry entry = PlantTechMain.getCropList().getBySeed(stack.m_41720_());
                if (entry == null) continue;
                HashMapCropTraits newtraits = new HashMapCropTraits();
                newtraits.setType(entry.getName());
                newtraits.setAnalysed(true);
                ItemStack result = new ItemStack((ItemLike)entry.getPrimarySeed().getItem().get()).m_41777_();
                result.m_41764_(stack.m_41613_());
                newtraits.addToItemStack(stack);
                this.itemhandler.setStackInSlot(this.getFreeOutputSlot(), result);
                this.itemhandler.setStackInSlot(i, ItemStack.f_41583_);
                this.addKnowledge();
            }
        }
    }

    public boolean hasFreeOutputSlot() {
        return this.getFreeOutputSlot() != -1;
    }

    public int getFreeOutputSlot() {
        for (int i = 9; i < 18; ++i) {
            ItemStack stack = this.itemhandler.getStackInSlot(i);
            if (!stack.m_41619_()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getNameString() {
        return "identifier";
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return new IdentifierMenu(id, inv, this);
    }

    @Override
    public int getEnergyInSlot() {
        return 19;
    }

    @Override
    public int getEnergyOutSlot() {
        return 20;
    }

    @Override
    public int getKnowledgeChipSlot() {
        return 21;
    }

    @Override
    public int getKnowledgePerAction() {
        return 5;
    }

    @Override
    public int getUpgradeSlot() {
        return 18;
    }
}

