/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.entity.machine;

import java.util.Optional;
import javax.annotation.Nullable;
import net.kaneka.planttech2.blocks.entity.machine.baseclasses.ConvertEnergyInventoryFluidBlockEntity;
import net.kaneka.planttech2.inventory.InfuserMenu;
import net.kaneka.planttech2.recipes.ModRecipeTypes;
import net.kaneka.planttech2.recipes.recipeclasses.InfuserRecipe;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.registries.ModTileEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class InfuserBlockEntity
extends ConvertEnergyInventoryFluidBlockEntity {
    private int fluidTotal = 0;
    private Item output = null;
    private final RangedWrapper inputs;
    private final RangedWrapper outputs;
    private final LazyOptional<IItemHandler> inputs_provider;
    private final LazyOptional<IItemHandler> outputs_provider;
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> InfuserBlockEntity.this.energystorage.getEnergyStored();
                case 1 -> InfuserBlockEntity.this.energystorage.getMaxEnergyStored();
                case 2 -> InfuserBlockEntity.this.biomassCap.getCurrentStorage();
                case 3 -> InfuserBlockEntity.this.biomassCap.getMaxStorage();
                case 4 -> InfuserBlockEntity.this.ticksPassed;
                case 5 -> InfuserBlockEntity.this.fluidTotal;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    InfuserBlockEntity.this.energystorage.setEnergyStored(value);
                    break;
                }
                case 1: {
                    InfuserBlockEntity.this.energystorage.setEnergyMaxStored(value);
                    break;
                }
                case 2: {
                    InfuserBlockEntity.this.biomassCap.setCurrentStorage(value);
                    break;
                }
                case 3: {
                    InfuserBlockEntity.this.biomassCap.setMaxStorage(value);
                    break;
                }
                case 4: {
                    InfuserBlockEntity.this.ticksPassed = value;
                    break;
                }
                case 5: {
                    InfuserBlockEntity.this.fluidTotal = value;
                }
            }
        }

        public int m_6499_() {
            return 6;
        }
    };

    public InfuserBlockEntity() {
        this(BlockPos.f_121853_, ModBlocks.INFUSER.m_49966_());
    }

    public InfuserBlockEntity(BlockPos pos, BlockState state) {
        super(ModTileEntities.INFUSER_TE, pos, state, 1000, 8, 5000, 2);
        this.inputs = new RangedWrapper((IItemHandlerModifiable)this.itemhandler, 0, 1);
        this.outputs = new RangedWrapper((IItemHandlerModifiable)this.itemhandler, 1, 2);
        this.inputs_provider = LazyOptional.of(() -> this.inputs);
        this.outputs_provider = LazyOptional.of(() -> this.outputs);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.DOWN) {
                return this.outputs_provider.cast();
            }
            if (facing != null) {
                return this.inputs_provider.cast();
            }
            return this.inventoryCap.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    protected boolean canProceed(ItemStack input, ItemStack output) {
        if (input.m_41619_()) {
            return false;
        }
        InfuserRecipe recipe = this.getOutputRecipe();
        if (recipe == null) {
            return false;
        }
        if (recipe.getOutput() == this.output || this.output == null) {
            if (this.output == null) {
                this.output = recipe.getOutput();
                this.fluidTotal = recipe.getBiomass();
            }
            return true;
        }
        this.fluidTotal = recipe.getBiomass();
        this.output = recipe.getOutput();
        return false;
    }

    @Override
    public int ticksPerItem() {
        return this.fluidTotal > 0 ? this.fluidTotal : 100;
    }

    @Override
    protected void increaseProgress() {
        this.ticksPassed += this.fluidPerAction();
    }

    @Override
    protected int remainingFluid() {
        return this.fluidTotal - this.ticksPassed;
    }

    @Override
    protected ItemStack getResult(ItemStack input, ItemStack output) {
        return this.getOutputRecipe() == null ? ItemStack.f_41583_ : this.getOutputRecipe().m_8043_();
    }

    @Override
    protected boolean shouldResetProgressIfNotProcessing() {
        return false;
    }

    @Override
    public ContainerData getContainerData() {
        return this.data;
    }

    @Nullable
    private InfuserRecipe getOutputRecipe() {
        if (this.f_58857_ == null) {
            return null;
        }
        ItemStack[] stacks = new ItemStack[this.itemhandler.getSlots()];
        for (int i = 0; i < this.itemhandler.getSlots(); ++i) {
            stacks[i] = this.itemhandler.getStackInSlot(i);
        }
        SimpleContainer container = new SimpleContainer(stacks);
        Optional recipe = this.f_58857_.m_7465_().m_44015_(ModRecipeTypes.INFUSING, (Container)container, this.f_58857_);
        return recipe.orElse(null);
    }

    @Override
    public String getNameString() {
        return "infuser";
    }

    @Override
    public int getFluidInSlot() {
        return 3;
    }

    @Override
    public int getFluidOutSlot() {
        return 4;
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return new InfuserMenu(id, inv, this);
    }

    @Override
    public int getEnergyInSlot() {
        return 5;
    }

    @Override
    public int getEnergyOutSlot() {
        return 6;
    }

    @Override
    public int getKnowledgeChipSlot() {
        return 7;
    }

    @Override
    public int getKnowledgePerAction() {
        return 150;
    }

    @Override
    public int getUpgradeSlot() {
        return 2;
    }
}

