/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.entity.machine;

import net.kaneka.planttech2.blocks.entity.machine.baseclasses.ConvertEnergyInventoryFluidBlockEntity;
import net.kaneka.planttech2.blocks.entity.machine.baseclasses.EnergyInventoryBlockEntity;
import net.kaneka.planttech2.inventory.MachineBulbReprocessorMenu;
import net.kaneka.planttech2.items.CropSeedItem;
import net.kaneka.planttech2.items.KnowledgeChip;
import net.kaneka.planttech2.items.MachineBulbItem;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.registries.ModItems;
import net.kaneka.planttech2.registries.ModTileEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;

public class MachineBulbReprocessorBlockEntity
extends ConvertEnergyInventoryFluidBlockEntity {
    private int selectedId = 0;
    private int actualTier = 0;
    protected final ContainerData field_array = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> MachineBulbReprocessorBlockEntity.this.energystorage.getEnergyStored();
                case 1 -> MachineBulbReprocessorBlockEntity.this.energystorage.getMaxEnergyStored();
                case 2 -> MachineBulbReprocessorBlockEntity.this.biomassCap.getCurrentStorage();
                case 3 -> MachineBulbReprocessorBlockEntity.this.biomassCap.getMaxStorage();
                case 4 -> MachineBulbReprocessorBlockEntity.this.ticksPassed;
                case 5 -> MachineBulbReprocessorBlockEntity.this.selectedId;
                case 6 -> MachineBulbReprocessorBlockEntity.this.actualTier;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    MachineBulbReprocessorBlockEntity.this.energystorage.setEnergyStored(value);
                    break;
                }
                case 1: {
                    MachineBulbReprocessorBlockEntity.this.energystorage.setEnergyMaxStored(value);
                    break;
                }
                case 2: {
                    MachineBulbReprocessorBlockEntity.this.biomassCap.setCurrentStorage(value);
                    break;
                }
                case 3: {
                    MachineBulbReprocessorBlockEntity.this.biomassCap.setMaxStorage(value);
                    break;
                }
                case 4: {
                    MachineBulbReprocessorBlockEntity.this.ticksPassed = value;
                    break;
                }
                case 5: {
                    MachineBulbReprocessorBlockEntity.this.selectedId = value;
                    break;
                }
                case 6: {
                    MachineBulbReprocessorBlockEntity.this.actualTier = value;
                }
            }
        }

        public int m_6499_() {
            return 10;
        }
    };

    public MachineBulbReprocessorBlockEntity() {
        this(BlockPos.f_121853_, ModBlocks.MACHINEBULBREPROCESSOR.m_49966_());
    }

    public MachineBulbReprocessorBlockEntity(BlockPos pos, BlockState state) {
        super(ModTileEntities.MACHINEBULBREPROCESSOR_TE, pos, state, 5000, 8, 5000, 0);
    }

    @Override
    protected boolean canProceed(ItemStack input, ItemStack output) {
        if (this.selectedId < 1 || this.selectedId > ModItems.MACHINE_BULBS.size()) {
            return false;
        }
        MachineBulbItem bulb = ModItems.MACHINE_BULBS.get(this.selectedId - 1).get();
        if (bulb.getTier() > this.actualTier) {
            return false;
        }
        return Tags.Items.SEEDS.m_8110_((Object)input.m_41720_()) || input.m_41720_() instanceof CropSeedItem;
    }

    @Override
    protected EnergyInventoryBlockEntity.EnergyConsumptionType getEnergyConsumptionType() {
        return EnergyInventoryBlockEntity.EnergyConsumptionType.PER_PROCESS;
    }

    @Override
    protected EnergyInventoryBlockEntity.FluidConsumptionType getFluidConsumptionType() {
        return EnergyInventoryBlockEntity.FluidConsumptionType.PER_PROCESS;
    }

    @Override
    public int fluidPerAction() {
        if (this.selectedId < 1) {
            return 0;
        }
        return ModItems.MACHINE_BULBS.get(this.selectedId - 1).get().getNeededBiomass();
    }

    @Override
    protected ItemStack getResult(ItemStack input, ItemStack output) {
        if (this.selectedId < 1) {
            return ItemStack.f_41583_;
        }
        return new ItemStack((ItemLike)ModItems.MACHINE_BULBS.get(this.selectedId - 1).get());
    }

    @Override
    public void onContainerUpdated(int slotIndex) {
        this.checkTier();
    }

    public void checkTier() {
        Item item;
        Item item2;
        ItemStack stack = this.itemhandler.getStackInSlot(this.getKnowledgeChipSlot());
        if (!stack.m_41619_() && (item2 = (item = stack.m_41720_())) instanceof KnowledgeChip) {
            KnowledgeChip kc = (KnowledgeChip)item2;
            this.actualTier = kc.getTier();
            return;
        }
        this.actualTier = 0;
    }

    @Override
    public ContainerData getContainerData() {
        return this.field_array;
    }

    @Override
    public int energyPerAction() {
        return 1000;
    }

    @Override
    public int ticksPerItem() {
        return 300;
    }

    @Override
    public String getNameString() {
        return "machinebulbreprocessor";
    }

    @Override
    public int getFluidInSlot() {
        return 2;
    }

    @Override
    public int getFluidOutSlot() {
        return 3;
    }

    @Override
    public int getEnergyInSlot() {
        return 4;
    }

    @Override
    public int getEnergyOutSlot() {
        return 5;
    }

    @Override
    public int getKnowledgeChipSlot() {
        return 6;
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return new MachineBulbReprocessorMenu(id, inv, this);
    }

    public void setSelectedId(int buttonId) {
        this.selectedId = buttonId;
    }

    @Override
    public int getKnowledgePerAction() {
        return 10;
    }
}

