/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.entity.machine;

import java.util.Optional;
import javax.annotation.Nullable;
import net.kaneka.planttech2.blocks.entity.machine.baseclasses.EnergyInventoryBlockEntity;
import net.kaneka.planttech2.inventory.MegaFurnaceMenu;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.registries.ModTileEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class MegaFurnaceBlockEntity
extends EnergyInventoryBlockEntity {
    public int[] ticksPassed = new int[6];
    boolean isSmelting;
    protected ItemStackHandler dummyitemhandler = new ItemStackHandler();
    private final RangedWrapper inputs;
    private final RangedWrapper outputs;
    private final LazyOptional<IItemHandler> inputs_provider;
    private final LazyOptional<IItemHandler> outputs_provider;
    protected final ContainerData field_array = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> MegaFurnaceBlockEntity.this.energystorage.getEnergyStored();
                case 1 -> MegaFurnaceBlockEntity.this.energystorage.getMaxEnergyStored();
                case 2 -> MegaFurnaceBlockEntity.this.ticksPassed[0];
                case 3 -> MegaFurnaceBlockEntity.this.ticksPassed[1];
                case 4 -> MegaFurnaceBlockEntity.this.ticksPassed[2];
                case 5 -> MegaFurnaceBlockEntity.this.ticksPassed[3];
                case 6 -> MegaFurnaceBlockEntity.this.ticksPassed[4];
                case 7 -> MegaFurnaceBlockEntity.this.ticksPassed[5];
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    MegaFurnaceBlockEntity.this.energystorage.setEnergyStored(value);
                    break;
                }
                case 1: {
                    MegaFurnaceBlockEntity.this.energystorage.setEnergyMaxStored(value);
                    break;
                }
                case 2: {
                    MegaFurnaceBlockEntity.this.ticksPassed[0] = value;
                    break;
                }
                case 3: {
                    MegaFurnaceBlockEntity.this.ticksPassed[1] = value;
                    break;
                }
                case 4: {
                    MegaFurnaceBlockEntity.this.ticksPassed[2] = value;
                    break;
                }
                case 5: {
                    MegaFurnaceBlockEntity.this.ticksPassed[3] = value;
                    break;
                }
                case 6: {
                    MegaFurnaceBlockEntity.this.ticksPassed[4] = value;
                    break;
                }
                case 7: {
                    MegaFurnaceBlockEntity.this.ticksPassed[5] = value;
                }
            }
        }

        public int m_6499_() {
            return 8;
        }
    };

    public MegaFurnaceBlockEntity() {
        this(BlockPos.f_121853_, ModBlocks.MEGAFURNACE.m_49966_());
    }

    public MegaFurnaceBlockEntity(BlockPos pos, BlockState state) {
        super(ModTileEntities.MEGAFURNACE_TE, pos, state, 10000, 16, 3);
        this.inputs = new RangedWrapper((IItemHandlerModifiable)this.itemhandler, 0, 6);
        this.outputs = new RangedWrapper((IItemHandlerModifiable)this.itemhandler, 6, 12);
        this.inputs_provider = LazyOptional.of(() -> this.inputs);
        this.outputs_provider = LazyOptional.of(() -> this.outputs);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.DOWN) {
                return this.outputs_provider.cast();
            }
            if (facing != null) {
                return this.inputs_provider.cast();
            }
            return this.inventoryCap.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void doUpdate() {
        super.doUpdate();
        this.isSmelting = false;
        for (int i = 0; i < 6; ++i) {
            if (this.energystorage.getEnergyStored() > this.energyPerAction()) {
                if (this.canSmelt(i)) {
                    this.isSmelting = true;
                    int n = i;
                    this.ticksPassed[n] = this.ticksPassed[n] + 1;
                    if (this.ticksPassed[i] < this.ticksPerItem()) continue;
                    this.smeltItem(i);
                    this.ticksPassed[i] = 0;
                    this.addKnowledge();
                    continue;
                }
                if (this.ticksPassed[i] <= 0) continue;
                this.ticksPassed[i] = 0;
                continue;
            }
            if (this.canSmelt(i) || this.ticksPassed[i] <= 0) break;
            this.ticksPassed[i] = 0;
            break;
        }
        if (this.isSmelting) {
            this.energystorage.extractEnergy(this.energyPerAction(), false);
        }
    }

    @Override
    public ContainerData getContainerData() {
        return this.field_array;
    }

    private boolean canSmelt(int slot) {
        ItemStack itemstack = this.itemhandler.getStackInSlot(slot);
        if (itemstack.m_41619_()) {
            return false;
        }
        ItemStack output = this.getOutput(slot);
        if (output.m_41619_()) {
            return false;
        }
        ItemStack outputslot = this.itemhandler.getStackInSlot(slot + 6);
        if (outputslot.m_41619_()) {
            return true;
        }
        if (!output.m_41656_(outputslot)) {
            return false;
        }
        if (outputslot.m_41613_() + output.m_41613_() <= 64 && outputslot.m_41613_() + output.m_41613_() <= outputslot.m_41741_()) {
            return true;
        }
        return outputslot.m_41613_() + output.m_41613_() <= output.m_41741_();
    }

    public ItemStack getOutput(int slot) {
        if (this.f_58857_ == null) {
            return ItemStack.f_41583_;
        }
        this.dummyitemhandler.setStackInSlot(0, this.itemhandler.getStackInSlot(slot));
        RecipeWrapper wrapper = new RecipeWrapper((IItemHandlerModifiable)this.dummyitemhandler);
        Optional recipeopt = this.f_58857_.m_7465_().m_44015_(RecipeType.f_44108_, (Container)wrapper, this.f_58857_);
        SmeltingRecipe recipe = recipeopt.orElse(null);
        return recipe == null ? ItemStack.f_41583_ : recipe.m_8043_();
    }

    public void smeltItem(int slot) {
        if (this.canSmelt(slot)) {
            ItemStack itemstack = this.itemhandler.getStackInSlot(slot);
            ItemStack itemstack1 = this.getOutput(slot);
            ItemStack itemstack2 = this.itemhandler.getStackInSlot(slot + 6);
            if (itemstack2.m_41619_()) {
                this.itemhandler.setStackInSlot(slot + 6, itemstack1.m_41777_());
            } else if (itemstack2.m_41720_() == itemstack1.m_41720_()) {
                itemstack2.m_41769_(itemstack1.m_41613_());
            }
            itemstack.m_41774_(1);
        }
    }

    @Override
    public CompoundTag m_6945_(CompoundTag compound) {
        compound.m_128385_("cooktime", this.ticksPassed);
        return super.m_6945_(compound);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.ticksPassed = compound.m_128465_("cooktime");
    }

    @Override
    public String getNameString() {
        return "megafurnace";
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return new MegaFurnaceMenu(id, inv, this);
    }

    @Override
    public int getEnergyInSlot() {
        return 13;
    }

    @Override
    public int getEnergyOutSlot() {
        return 14;
    }

    @Override
    public int getKnowledgeChipSlot() {
        return 15;
    }

    @Override
    public int getKnowledgePerAction() {
        return 50;
    }

    @Override
    public int getUpgradeSlot() {
        return 12;
    }
}

