/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.entity.machine;

import java.util.Collection;
import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.blocks.entity.machine.baseclasses.EnergyInventoryFluidBlockEntity;
import net.kaneka.planttech2.hashmaps.HashMapCropTraits;
import net.kaneka.planttech2.inventory.PlantFarmMenu;
import net.kaneka.planttech2.items.CropSeedItem;
import net.kaneka.planttech2.items.TierItem;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.registries.ModTileEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PlantFarmBlockEntity
extends EnergyInventoryFluidBlockEntity {
    private int[] progress = new int[5];
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> PlantFarmBlockEntity.this.energystorage.getEnergyStored();
                case 1 -> PlantFarmBlockEntity.this.energystorage.getMaxEnergyStored();
                case 2 -> PlantFarmBlockEntity.this.biomassCap.getCurrentStorage();
                case 3 -> PlantFarmBlockEntity.this.biomassCap.getMaxStorage();
                case 4 -> PlantFarmBlockEntity.this.progress[0];
                case 5 -> PlantFarmBlockEntity.this.progress[1];
                case 6 -> PlantFarmBlockEntity.this.progress[2];
                case 7 -> PlantFarmBlockEntity.this.progress[3];
                case 8 -> PlantFarmBlockEntity.this.progress[4];
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    PlantFarmBlockEntity.this.energystorage.setEnergyStored(value);
                    break;
                }
                case 1: {
                    PlantFarmBlockEntity.this.energystorage.setEnergyMaxStored(value);
                    break;
                }
                case 2: {
                    PlantFarmBlockEntity.this.biomassCap.setCurrentStorage(value);
                    break;
                }
                case 3: {
                    PlantFarmBlockEntity.this.biomassCap.setMaxStorage(value);
                    break;
                }
                case 4: {
                    PlantFarmBlockEntity.this.progress[0] = value;
                    break;
                }
                case 5: {
                    PlantFarmBlockEntity.this.progress[1] = value;
                    break;
                }
                case 6: {
                    PlantFarmBlockEntity.this.progress[2] = value;
                    break;
                }
                case 7: {
                    PlantFarmBlockEntity.this.progress[3] = value;
                    break;
                }
                case 8: {
                    PlantFarmBlockEntity.this.progress[4] = value;
                }
            }
        }

        public int m_6499_() {
            return 9;
        }
    };

    public PlantFarmBlockEntity() {
        this(BlockPos.f_121853_, ModBlocks.PLANTFARM.m_49966_());
    }

    public PlantFarmBlockEntity(BlockPos pos, BlockState state) {
        super(ModTileEntities.PLANTFARM_TE, pos, state, 1000, 18, 5000, 5);
    }

    @Override
    public void doUpdate() {
        super.doUpdate();
        ItemStack seed = this.itemhandler.getStackInSlot(0);
        if (this.isSeed(seed)) {
            for (int i = 0; i <= this.getRange(); ++i) {
                if (this.progress[i] < this.getTicks(seed)) {
                    int n = i;
                    this.progress[n] = this.progress[n] + (this.getUpgradeTier(TierItem.ItemType.SPEED_UPGRADE) * 5 + 1);
                    continue;
                }
                if (this.energystorage.getEnergyStored() > this.energyPerAction()) {
                    NonNullList<ItemStack> drops = this.getDrops(seed);
                    if (drops.isEmpty()) continue;
                    for (ItemStack stack : drops) {
                        for (int k = 0; k < 15; ++k) {
                            if (stack.m_41619_()) continue;
                            stack = this.itemhandler.insertItem(k, stack, false);
                        }
                        if (stack.m_41619_()) continue;
                        PlantFarmBlockEntity.spawnAsEntity(this.f_58857_, this.f_58858_.m_7494_(), stack);
                    }
                    this.energystorage.extractEnergy(this.energyPerAction(), false);
                    this.progress[i] = 0;
                    this.addKnowledge();
                    continue;
                }
                this.resetProgress(false);
                break;
            }
        } else {
            this.resetProgress(false);
        }
    }

    @Override
    protected void resetProgress(boolean forced) {
        for (int i = 0; i <= this.getRange(); ++i) {
            this.progress[i] = 0;
        }
    }

    private boolean isSeed(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof CropSeedItem) {
            return true;
        }
        Item item2 = item;
        if (item2 instanceof BlockItem) {
            BlockItem bi = (BlockItem)item2;
            Block block = bi.m_40614_();
            return block instanceof CropBlock;
        }
        return false;
    }

    @Override
    public ContainerData getContainerData() {
        return this.data;
    }

    private int getTicks(ItemStack stack) {
        CompoundTag nbt;
        if (!stack.m_41619_() && stack.m_41720_() instanceof CropSeedItem && (nbt = stack.m_41784_()).m_128441_("growspeed")) {
            return (90 - nbt.m_128451_("growspeed") * 6) * 20 * 7;
        }
        return 12600;
    }

    public int getTicks() {
        return this.getTicks(this.itemhandler.getStackInSlot(0));
    }

    private NonNullList<ItemStack> getDrops(ItemStack stack) {
        NonNullList drops = NonNullList.m_122779_();
        if (this.f_58857_ != null) {
            Level level;
            Block block;
            Item item = stack.m_41720_();
            if (item instanceof CropSeedItem) {
                HashMapCropTraits traits = new HashMapCropTraits();
                traits.fromStack(stack);
                PlantTechMain.getCropList().getByName(traits.getType()).calculateDropsReduced((NonNullList<ItemStack>)drops, traits, 7, this.f_58857_.f_46441_);
                return drops;
            }
            if (item instanceof BlockItem && (block = ((BlockItem)item).m_40614_()) instanceof CropBlock && (level = this.f_58857_) instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                drops.addAll((Collection)Block.m_49869_((BlockState)((BlockState)block.m_49966_().m_61124_((Property)CropBlock.f_52244_, (Comparable)Integer.valueOf(7))), (ServerLevel)sl, (BlockPos)this.f_58858_, null));
            }
        }
        return drops;
    }

    private int getRange() {
        TierItem ti;
        Item item;
        ItemStack stack = this.itemhandler.getStackInSlot(12);
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof TierItem && (ti = (TierItem)item).getItemType() == TierItem.ItemType.RANGE_UPGRADE) {
            return ti.getTier();
        }
        return 0;
    }

    @Override
    public int getUpgradeSlot() {
        return 11;
    }

    @Override
    public int energyPerAction() {
        return 400;
    }

    @Override
    public CompoundTag m_6945_(CompoundTag compound) {
        compound.m_128385_("progress", this.progress);
        return super.m_6945_(compound);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.progress = compound.m_128465_("progress");
    }

    @Override
    public String getNameString() {
        return "plantfarm";
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return new PlantFarmMenu(id, inv, this);
    }

    @Override
    public int getEnergyInSlot() {
        return 15;
    }

    @Override
    public int getEnergyOutSlot() {
        return 16;
    }

    @Override
    public int getFluidInSlot() {
        return 13;
    }

    @Override
    public int getFluidOutSlot() {
        return 14;
    }

    @Override
    public int getKnowledgeChipSlot() {
        return 17;
    }

    @Override
    public int getKnowledgePerAction() {
        return 50;
    }
}

