/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.entity.machine;

import javax.annotation.Nullable;
import net.kaneka.planttech2.blocks.entity.machine.baseclasses.EnergyInventoryFluidBlockEntity;
import net.kaneka.planttech2.inventory.SeedSqueezerMenu;
import net.kaneka.planttech2.items.CropSeedItem;
import net.kaneka.planttech2.items.TierItem;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.registries.ModTileEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class SeedSqueezerBlockEntity
extends EnergyInventoryFluidBlockEntity {
    private final RangedWrapper inputs;
    private final LazyOptional<IItemHandler> inputs_provider;
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> SeedSqueezerBlockEntity.this.energystorage.getEnergyStored();
                case 1 -> SeedSqueezerBlockEntity.this.energystorage.getMaxEnergyStored();
                case 2 -> SeedSqueezerBlockEntity.this.biomassCap.getCurrentStorage();
                case 3 -> SeedSqueezerBlockEntity.this.biomassCap.getMaxStorage();
                case 4 -> SeedSqueezerBlockEntity.this.ticksPassed;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    SeedSqueezerBlockEntity.this.energystorage.setEnergyStored(value);
                    break;
                }
                case 1: {
                    SeedSqueezerBlockEntity.this.energystorage.setEnergyMaxStored(value);
                    break;
                }
                case 2: {
                    SeedSqueezerBlockEntity.this.biomassCap.setCurrentStorage(value);
                    break;
                }
                case 3: {
                    SeedSqueezerBlockEntity.this.biomassCap.setMaxStorage(value);
                    break;
                }
                case 4: {
                    SeedSqueezerBlockEntity.this.ticksPassed = value;
                }
            }
        }

        public int m_6499_() {
            return 5;
        }
    };

    public SeedSqueezerBlockEntity() {
        this(BlockPos.f_121853_, ModBlocks.SEEDSQUEEZER.m_49966_());
    }

    public SeedSqueezerBlockEntity(BlockPos pos, BlockState state) {
        super(ModTileEntities.SEEDSQUEEZER_TE, pos, state, 10000, 16, 5000, 0);
        this.inputs = new RangedWrapper((IItemHandlerModifiable)this.itemhandler, 0, 9);
        this.inputs_provider = LazyOptional.of(() -> this.inputs);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing != null) {
                return this.inputs_provider.cast();
            }
            return this.inventoryCap.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void doUpdate() {
        super.doUpdate();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            int i;
            if (this.itemhandler.getStackInSlot(9).m_41619_() && (i = this.getSqueezeableItem()) != -1) {
                ItemStack stack = this.itemhandler.getStackInSlot(i);
                ItemStack stack2 = stack.m_41777_();
                stack2.m_41764_(1);
                this.itemhandler.setStackInSlot(9, stack2);
                stack.m_41774_(1);
            }
            if (!this.itemhandler.getStackInSlot(9).m_41619_()) {
                ItemStack stack = this.itemhandler.getStackInSlot(9);
                if (stack.m_41613_() == 1 && stack.m_41720_() instanceof CropSeedItem) {
                    this.ticksPassed += this.getUpgradeTier(TierItem.ItemType.SPEED_UPGRADE) + 1;
                    if (this.ticksPassed >= this.ticksPerItem()) {
                        this.squeezeItem();
                        this.addKnowledge();
                        this.biomassCap.changeCurrentStorage(10);
                        this.resetProgress(true);
                    }
                } else if (stack.m_41613_() > 0) {
                    if (!this.f_58857_.f_46443_) {
                        this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_(), (double)(this.f_58858_.m_123342_() + 1), (double)this.f_58858_.m_123343_(), stack));
                        this.itemhandler.setStackInSlot(9, ItemStack.f_41583_);
                    }
                } else if (this.ticksPassed > 0) {
                    this.resetProgress(false);
                }
            }
        }
    }

    @Override
    public ContainerData getContainerData() {
        return this.data;
    }

    private int getSqueezeableItem() {
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.itemhandler.getStackInSlot(i);
            if (stack.m_41619_() || !(stack.m_41720_() instanceof CropSeedItem)) continue;
            return i;
        }
        return -1;
    }

    public void squeezeItem() {
        this.energystorage.receiveEnergy(this.getEnergyPerItem(), false);
        this.itemhandler.setStackInSlot(9, ItemStack.f_41583_);
    }

    @Override
    public int ticksPerItem() {
        return 200;
    }

    public int getEnergyPerItem() {
        CompoundTag nbt;
        ItemStack stack = this.itemhandler.getStackInSlot(9);
        if (!stack.m_41619_() && stack.m_41720_() instanceof CropSeedItem && (nbt = stack.m_41783_()) != null && nbt.m_128441_("energyvalue")) {
            return nbt.m_128451_("energyvalue") * 20;
        }
        return 20;
    }

    @Override
    public String getNameString() {
        return "seedsqueezer";
    }

    @Override
    public int getFluidInSlot() {
        return 11;
    }

    @Override
    public int getFluidOutSlot() {
        return 12;
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return new SeedSqueezerMenu(id, inv, this);
    }

    @Override
    public int getEnergyInSlot() {
        return 13;
    }

    @Override
    public int getEnergyOutSlot() {
        return 14;
    }

    @Override
    public int getKnowledgeChipSlot() {
        return 15;
    }

    @Override
    public int getKnowledgePerAction() {
        return 2;
    }

    @Override
    public int getUpgradeSlot() {
        return 10;
    }
}

