/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.entity.machine;

import net.kaneka.planttech2.blocks.entity.machine.baseclasses.EnergyInventoryBlockEntity;
import net.kaneka.planttech2.inventory.SolarGeneratorMenu;
import net.kaneka.planttech2.items.TierItem;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.registries.ModTileEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.block.state.BlockState;

public class SolarGeneratorBlockEntity
extends EnergyInventoryBlockEntity {
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> SolarGeneratorBlockEntity.this.energystorage.getEnergyStored();
                case 1 -> SolarGeneratorBlockEntity.this.energystorage.getMaxEnergyStored();
                case 2 -> SolarGeneratorBlockEntity.this.ticksPassed;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    SolarGeneratorBlockEntity.this.energystorage.setEnergyStored(value);
                    break;
                }
                case 1: {
                    SolarGeneratorBlockEntity.this.energystorage.setEnergyMaxStored(value);
                    break;
                }
                case 2: {
                    SolarGeneratorBlockEntity.this.ticksPassed = value;
                }
            }
        }

        public int m_6499_() {
            return 3;
        }
    };

    public SolarGeneratorBlockEntity() {
        this(BlockPos.f_121853_, ModBlocks.SOLARGENERATOR.m_49966_());
    }

    public SolarGeneratorBlockEntity(BlockPos pos, BlockState state) {
        super(ModTileEntities.SOLARGENERATOR_TE, pos, state, 10000, 5, 5);
    }

    @Override
    public void doUpdate() {
        super.doUpdate();
        if (this.f_58857_ != null && this.f_58857_.m_46461_() && this.f_58857_.m_45527_(this.f_58858_.m_7494_()) && this.energystorage.getMaxEnergyStored() - this.energystorage.getEnergyStored() > 0) {
            ++this.ticksPassed;
            if (this.ticksPassed >= this.getTicksPerAmount()) {
                this.energystorage.receiveEnergy(this.getEnergyPerTick(this.getUpgradeTier(0, TierItem.ItemType.SOLAR_FOCUS)));
                this.ticksPassed = 0;
                this.addKnowledge();
            }
        }
    }

    @Override
    public ContainerData getContainerData() {
        return this.data;
    }

    private int getEnergyPerTick(int focusLevel) {
        return switch (focusLevel) {
            case 1 -> 20;
            case 2 -> 60;
            case 3 -> 180;
            case 4 -> 540;
            default -> 0;
        };
    }

    public int getTicksPerAmount() {
        return 80 - this.getUpgradeTier(TierItem.ItemType.SPEED_UPGRADE) * 15;
    }

    @Override
    public String getNameString() {
        return "solargenerator";
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return new SolarGeneratorMenu(id, inv, this);
    }

    @Override
    public int getEnergyInSlot() {
        return 2;
    }

    @Override
    public int getEnergyOutSlot() {
        return 3;
    }

    @Override
    public int getKnowledgeChipSlot() {
        return 4;
    }

    @Override
    public int getKnowledgePerAction() {
        return 50;
    }

    @Override
    public int getUpgradeSlot() {
        return 1;
    }
}

