/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.entity.machine.baseclasses;

import net.kaneka.planttech2.blocks.entity.machine.baseclasses.EnergyInventoryBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class ConvertEnergyInventoryBlockEntity
extends EnergyInventoryBlockEntity {
    public ConvertEnergyInventoryBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int energyStorage, int invSize, int tier) {
        super(type, pos, state, energyStorage, invSize, tier);
    }

    @Override
    public void doUpdate() {
        super.doUpdate();
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (this.energystorage.getEnergyStored() >= this.energyPerAction()) {
            ItemStack input = this.getInput();
            ItemStack output = this.getOutput();
            if (!input.m_41619_() && this.canProceed(input, output)) {
                if (this.ticksPassed < this.ticksPerItem()) {
                    this.increaseProgress();
                    if (this.getEnergyConsumptionType() == EnergyInventoryBlockEntity.EnergyConsumptionType.PER_TICK) {
                        this.energystorage.extractEnergy(this.energyPerAction(), false);
                    }
                } else if (this.onProcessFinished(input, output)) {
                    if (this.getEnergyConsumptionType() != EnergyInventoryBlockEntity.EnergyConsumptionType.NONE) {
                        this.energystorage.extractEnergy(this.energyPerAction(), false);
                    }
                    this.resetProgress(true);
                    this.addKnowledge();
                }
            } else {
                this.resetProgress(false);
            }
        }
    }

    protected abstract boolean canProceed(ItemStack var1, ItemStack var2);

    protected abstract ItemStack getResult(ItemStack var1, ItemStack var2);

    protected boolean onProcessFinished(ItemStack input, ItemStack output) {
        ItemStack result = this.getResult(input, output);
        if (this.itemhandler.insertItem(this.getOutputSlotIndex(), result, false).m_41619_()) {
            input.m_41774_(1);
            return true;
        }
        return false;
    }

    @Override
    protected void resetProgress(boolean forced) {
        if (this.shouldResetProgressIfNotProcessing() || forced) {
            super.resetProgress(forced);
        }
    }

    protected boolean shouldResetProgressIfNotProcessing() {
        return true;
    }

    public int getInputSlotIndex() {
        return 0;
    }

    public int getOutputSlotIndex() {
        return 1;
    }

    public ItemStack getInput() {
        return this.itemhandler.getStackInSlot(this.getInputSlotIndex());
    }

    public ItemStack getOutput() {
        return this.itemhandler.getStackInSlot(this.getOutputSlotIndex());
    }
}

