/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.entity.machine.baseclasses;

import java.util.Random;
import net.kaneka.planttech2.energy.BioEnergyStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class EnergyBlockEntity
extends BlockEntity
implements MenuProvider {
    protected BioEnergyStorage energystorage;
    private final LazyOptional<IEnergyStorage> energyCap;
    public String customname;
    protected final Random rand = new Random();

    public EnergyBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int energyStorage) {
        super(type, pos, state);
        this.energystorage = new BioEnergyStorage(energyStorage);
        this.energyCap = LazyOptional.of(() -> this.energystorage);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BlockEntity be) {
        BlockEntity blockEntity;
        if (level != null && !level.f_46443_ && (blockEntity = be) instanceof EnergyBlockEntity) {
            EnergyBlockEntity ebe = (EnergyBlockEntity)blockEntity;
            ebe.doUpdate();
        }
    }

    public void doUpdate() {
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        return capability == CapabilityEnergy.ENERGY ? this.energyCap.cast() : super.getCapability(capability, facing);
    }

    public CompoundTag m_6945_(CompoundTag compound) {
        compound.m_128365_("energy", (Tag)this.energystorage.serializeNBT());
        return super.m_6945_(compound);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.energystorage.deserializeNBT(compound.m_128469_("energy"));
    }

    public String getNameString() {
        return "default";
    }

    public int getEnergyStored() {
        return this.energystorage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.energystorage.getMaxEnergyStored();
    }

    public boolean isUsableByPlayer(Player player) {
        if (this.f_58857_ == null || this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void onSlotContentChanged() {
    }

    public int getUpgradeSlot() {
        return -1;
    }

    public abstract ContainerData getContainerData();

    public Component m_5446_() {
        return new TranslatableComponent("container." + this.getNameString());
    }

    public void notifyClient() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            BlockState state = this.f_58857_.m_8055_(this.m_58899_());
            this.f_58857_.m_7260_(this.m_58899_(), state, state, 3);
        }
    }

    public boolean requireSyncUponOpen() {
        return false;
    }
}

