/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.entity.machine.baseclasses;

import net.kaneka.planttech2.blocks.entity.machine.baseclasses.EnergyInventoryBlockEntity;
import net.kaneka.planttech2.fluids.capability.BiomassFluidEnergy;
import net.kaneka.planttech2.fluids.capability.IBiomassFluidEnergy;
import net.kaneka.planttech2.items.BiomassContainerItem;
import net.kaneka.planttech2.registries.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class EnergyInventoryFluidBlockEntity
extends EnergyInventoryBlockEntity {
    protected final IBiomassFluidEnergy biomassCap = BiomassFluidEnergy.getTECap(this);

    public EnergyInventoryFluidBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int energyStorage, int invSize, int maxBiomassStorage, int tier) {
        super(type, pos, state, energyStorage, invSize, tier);
        this.biomassCap.setMaxStorage(maxBiomassStorage);
        this.biomassCap.setCurrentStorage(0);
    }

    @Override
    public void doUpdate() {
        super.doUpdate();
        this.doFluidLoop();
    }

    public void doFluidLoop() {
        boolean changesMade = false;
        ItemStack stack = this.itemhandler.getStackInSlot(this.getFluidInSlot());
        ItemStack stack2 = this.itemhandler.getStackInSlot(this.getFluidOutSlot());
        if (this.biomassCap.getCurrentStorage() < this.biomassCap.getMaxStorage()) {
            if (stack.m_41720_() instanceof BiomassContainerItem) {
                if (this.biomassCap.getCurrentStorage() < this.biomassCap.getMaxStorage()) {
                    this.biomassCap.changeCurrentStorage(BiomassFluidEnergy.getItemStackCap(stack).extractBiomass(1));
                    this.itemhandler.setStackInSlot(this.getFluidInSlot(), stack);
                }
                changesMade = true;
            } else if (stack.m_41720_() == ModItems.BIOMASS_BUCKET) {
                stack.m_41774_(1);
                this.itemhandler.setStackInSlot(this.getFluidInSlot(), new ItemStack((ItemLike)Items.f_42446_));
                this.biomassCap.recieveBiomass(3000);
                changesMade = true;
            }
        }
        if (stack2.m_41720_() instanceof BiomassContainerItem) {
            IBiomassFluidEnergy capability = BiomassFluidEnergy.getItemStackCap(stack2);
            int need = capability.getMaxStorage() - capability.getCurrentStorage();
            int have = this.biomassCap.getCurrentStorage();
            int amount = this.biomassCap.extractBiomass(Math.min(Math.min(need, have), 4));
            capability.recieveBiomass(amount);
            this.itemhandler.setStackInSlot(this.getFluidOutSlot(), stack2);
            changesMade = true;
        } else if (stack2.m_41720_() == Items.f_42446_ && this.biomassCap.getCurrentStorage() >= 3000) {
            stack2.m_41774_(1);
            this.itemhandler.setStackInSlot(this.getFluidOutSlot(), new ItemStack((ItemLike)ModItems.BIOMASS_BUCKET));
            this.biomassCap.extractBiomass(3000);
            changesMade = true;
        }
        if (changesMade) {
            this.m_6596_();
        }
    }

    public abstract int getFluidInSlot();

    public abstract int getFluidOutSlot();
}

