/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.machines;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.kaneka.planttech2.blocks.entity.cable.CableBlockEntity;
import net.kaneka.planttech2.registries.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.energy.CapabilityEnergy;

@Deprecated
public class CableBlock
extends Block
implements EntityBlock {
    public static final IntegerProperty NORTH = IntegerProperty.m_61631_((String)"north", (int)0, (int)3);
    public static final IntegerProperty EAST = IntegerProperty.m_61631_((String)"east", (int)0, (int)3);
    public static final IntegerProperty SOUTH = IntegerProperty.m_61631_((String)"south", (int)0, (int)3);
    public static final IntegerProperty WEST = IntegerProperty.m_61631_((String)"west", (int)0, (int)3);
    public static final IntegerProperty UP = IntegerProperty.m_61631_((String)"up", (int)0, (int)3);
    public static final IntegerProperty DOWN = IntegerProperty.m_61631_((String)"down", (int)0, (int)3);
    public static final Map<Direction, IntegerProperty> directions = new HashMap<Direction, IntegerProperty>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(Direction.NORTH, NORTH);
            this.put(Direction.EAST, EAST);
            this.put(Direction.SOUTH, SOUTH);
            this.put(Direction.WEST, WEST);
            this.put(Direction.UP, UP);
            this.put(Direction.DOWN, DOWN);
        }
    };
    private static final VoxelShape core_voxel = Block.m_49796_((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0);
    private static final Map<Direction, VoxelShape> connection_voxels = new HashMap<Direction, VoxelShape>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(Direction.DOWN, Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)2.0, (double)10.0));
            this.put(Direction.UP, Block.m_49796_((double)6.0, (double)14.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0));
            this.put(Direction.NORTH, Block.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)2.0));
            this.put(Direction.SOUTH, Block.m_49796_((double)6.0, (double)6.0, (double)14.0, (double)10.0, (double)10.0, (double)16.0));
            this.put(Direction.WEST, Block.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)2.0, (double)10.0, (double)10.0));
            this.put(Direction.EAST, Block.m_49796_((double)14.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0));
        }
    };
    private static final Map<Direction, VoxelShape> cable_voxels = new HashMap<Direction, VoxelShape>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(Direction.DOWN, Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)7.0, (double)9.0));
            this.put(Direction.UP, Block.m_49796_((double)7.0, (double)9.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0));
            this.put(Direction.NORTH, Block.m_49796_((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)7.0));
            this.put(Direction.SOUTH, Block.m_49796_((double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0, (double)16.0));
            this.put(Direction.WEST, Block.m_49796_((double)0.0, (double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0));
            this.put(Direction.EAST, Block.m_49796_((double)9.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0));
        }
    };

    public CableBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(0.5f));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)NORTH, (Comparable)Integer.valueOf(0))).m_61124_((Property)EAST, (Comparable)Integer.valueOf(0))).m_61124_((Property)SOUTH, (Comparable)Integer.valueOf(0))).m_61124_((Property)WEST, (Comparable)Integer.valueOf(0))).m_61124_((Property)UP, (Comparable)Integer.valueOf(0))).m_61124_((Property)DOWN, (Comparable)Integer.valueOf(0)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        if (!level.f_46443_ && hand.equals((Object)InteractionHand.MAIN_HAND) && player.m_21205_().m_41720_().equals((Object)ModItems.WRENCH)) {
            Vec3 hitvec = ray.m_82450_();
            hitvec = hitvec.m_82520_((double)(-pos.m_123341_()), (double)(-pos.m_123342_()), (double)(-pos.m_123343_()));
            for (Direction dir : Direction.values()) {
                CableBlockEntity te;
                VoxelShape tempshape = connection_voxels.get(dir);
                if (!(tempshape.m_83288_(Direction.Axis.X) <= hitvec.f_82479_) || !(tempshape.m_83297_(Direction.Axis.X) >= hitvec.f_82479_) || !(tempshape.m_83288_(Direction.Axis.Y) <= hitvec.f_82480_) || !(tempshape.m_83297_(Direction.Axis.Y) >= hitvec.f_82480_) || !(tempshape.m_83288_(Direction.Axis.Z) <= hitvec.f_82481_) || !(tempshape.m_83297_(Direction.Axis.Z) >= hitvec.f_82481_) || (te = this.getTECable(level, pos)) == null) continue;
                te.rotateConnection(dir);
                level.m_46597_(pos, this.getCurrentState(state, (LevelAccessor)level, pos));
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldstate, boolean bool) {
        CableBlockEntity te = this.getTECable(level, pos);
        if (te != null) {
            te.initCable(state);
            level.m_46597_(pos, this.getCurrentState(state, (LevelAccessor)level, pos));
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        CableBlockEntity te = this.getTECable(level, pos);
        if (te != null) {
            te.deleteCable();
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, world, pos, block, fromPos, isMoving);
        CableBlockEntity cable = this.getTECable(world, pos);
        if (cable != null) {
            cable.checkConnections(true);
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = this.m_49966_();
        for (Direction facing : Direction.values()) {
            BlockState stateDirection = level.m_8055_(pos.m_142300_(facing));
            BlockEntity te = level.m_7702_(pos.m_142300_(facing));
            if (stateDirection.m_60734_() instanceof CableBlock) {
                state.m_61124_((Property)directions.get(facing), (Comparable)Integer.valueOf(1));
                continue;
            }
            if (te != null) {
                if (!te.getCapability(CapabilityEnergy.ENERGY).isPresent()) continue;
                state.m_61124_((Property)directions.get(facing), (Comparable)Integer.valueOf(2));
                continue;
            }
            state.m_61124_((Property)directions.get(facing), (Comparable)Integer.valueOf(0));
        }
        return state;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        return this.getCurrentState(state, world, currentPos);
    }

    public BlockState getCurrentState(BlockState state, LevelAccessor level, BlockPos pos) {
        CableBlockEntity te = this.getTECable((Level)level, pos);
        if (te != null) {
            te.checkConnections(false);
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)UP, (Comparable)Integer.valueOf(te.getConnection(Direction.UP)))).m_61124_((Property)DOWN, (Comparable)Integer.valueOf(te.getConnection(Direction.DOWN)))).m_61124_((Property)EAST, (Comparable)Integer.valueOf(te.getConnection(Direction.EAST)))).m_61124_((Property)WEST, (Comparable)Integer.valueOf(te.getConnection(Direction.WEST)))).m_61124_((Property)NORTH, (Comparable)Integer.valueOf(te.getConnection(Direction.NORTH)))).m_61124_((Property)SOUTH, (Comparable)Integer.valueOf(te.getConnection(Direction.SOUTH)));
        }
        return state;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getCombinedShape(state);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getCombinedShape(state);
    }

    private VoxelShape getCombinedShape(BlockState state) {
        VoxelShape shape = core_voxel;
        for (Direction dir : Direction.values()) {
            int value = (Integer)state.m_61143_((Property)directions.get(dir));
            if (value <= 0) continue;
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)cable_voxels.get(dir));
            if (value <= 1) continue;
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)connection_voxels.get(dir));
        }
        return shape;
    }

    private CableBlockEntity getTECable(Level level, BlockPos pos) {
        BlockEntity te = level.m_7702_(pos);
        return te instanceof CableBlockEntity ? (CableBlockEntity)te : null;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CableBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> be) {
        if (!level.f_46443_) {
            return CableBlockEntity::tick;
        }
        return null;
    }
}

