/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.commands;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.MinecraftServer;

public class DevListCommand {
    public static final Map<String, List<String>> AUTHORS = Map.of("Kaneka", ImmutableList.of((Object)"df361308-a4b8-469c-a3b6-63bb8b2ec7e3"), "pupudice", ImmutableList.of((Object)"f0c9774d-e79f-4a58-b524-3f3d014e58ed", (Object)"b3fd2b3b-df09-4790-8187-650219671a69"), "Setrion", ImmutableList.of((Object)"c5beef70-7f28-44c8-a1cc-91a1cc8836e6"), "mthwzrd", ImmutableList.of((Object)"d23dfef7-36a5-40aa-b851-6b8201e0c779"));
    public static final Map<String, List<String>> ARTISTS = Map.of("VeyezX (Vex)", ImmutableList.of((Object)"8ea51d9d-ccc9-4ce4-a9fd-9e8b5d1ceaf3"), "BeerCav", ImmutableList.of((Object)"bc58f1ec-9853-4dd0-a0bb-da38cfaf6fe6"), "DinoSoup", ImmutableList.of((Object)"1dc30eef-5be5-4afa-9e1e-9a5c20df653f"), "MoonlitLamps", ImmutableList.of(), "andrew0030", ImmutableList.of((Object)"0b37421b-e74e-4852-bf57-23907d295ea1"), "TEMHOTAOKEAHA", ImmutableList.of((Object)"7f82b856-345b-4b8c-a55b-6a7a0324c1b5"));

    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)Commands.m_82127_((String)"devlist").executes(context -> {
            int online = 0;
            CommandSourceStack src = (CommandSourceStack)context.getSource();
            src.m_81354_((Component)new TextComponent("---- Plant Tech 2 Developers ----").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GREEN, ChatFormatting.BOLD, ChatFormatting.UNDERLINE}), false);
            DevListCommand.printTitle(src, "Artists:");
            online += DevListCommand.printAllFromList(ARTISTS, src);
            DevListCommand.printTitle(src, "Authors:");
            online += DevListCommand.printAllFromList(AUTHORS, src);
            DevListCommand.printTitle(src, "Special Thanks:");
            return online += DevListCommand.printAllFromList(AUTHORS, src, true);
        });
    }

    private static void printTitle(CommandSourceStack source, String message) {
        source.m_81354_((Component)new TextComponent(message).m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD}), false);
    }

    private static int printAllFromList(Map<String, List<String>> map, CommandSourceStack src) {
        return DevListCommand.printAllFromList(map, src, false);
    }

    private static int printAllFromList(Map<String, List<String>> map, CommandSourceStack src, boolean contributionDone) {
        int online = 0;
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            TextComponent name = new TextComponent(entry.getKey());
            if (DevListCommand.isOnline(src.m_81377_(), entry.getValue())) {
                name.m_7220_((Component)new TextComponent(" (online)").m_130940_(ChatFormatting.GREEN));
                ++online;
            }
            if (contributionDone) {
                name = new TextComponent("Thanks " + name + DevListCommand.getContribution(entry.getKey()));
            }
            src.m_81354_((Component)name, false);
        }
        return online;
    }

    private static boolean isOnline(MinecraftServer server, List<String> uuidList) {
        return uuidList.stream().anyMatch(uuid -> server.m_6846_().m_11259_(UUID.fromString(uuid)) != null);
    }

    public static String getContribution(String username) {
        switch (username) {
            default: {
                return "";
            }
            case "Sciwhiz12": 
        }
        return "for greatly improving the code!";
    }
}

