/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.crops;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.crops.CropEntryConfigData;
import net.kaneka.planttech2.crops.CropList;
import net.kaneka.planttech2.crops.CropListReloadListener;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class CropConfigProvider
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final DataGenerator dataGenerator;

    public CropConfigProvider(DataGenerator generator) {
        this.dataGenerator = generator;
    }

    public abstract Map<ResourceLocation, CropEntryConfigData> getCropData();

    public void m_6865_(HashCache cache) {
        Path path = this.dataGenerator.m_123916_();
        Map<ResourceLocation, CropEntryConfigData> cropEntryData = this.getCropData();
        this.validate(PlantTechMain.getCropList(), cropEntryData);
        cropEntryData.forEach((key, data) -> {
            Path outputFile = CropConfigProvider.getPath(path, key);
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)CropListReloadListener.toJson(data), (Path)outputFile);
            }
            catch (Exception ioexception) {
                LOGGER.error("Couldn't save crop entry configuration {}", (Object)outputFile, (Object)ioexception);
            }
        });
    }

    protected void validate(CropList list, Map<ResourceLocation, CropEntryConfigData> dataMap) {
        AtomicBoolean errored = new AtomicBoolean(false);
        dataMap.forEach((loc, data) -> {
            if (list.getByName(data.getCropEntryName()) == null) {
                LOGGER.fatal("Unknown crop entry {} in {}", (Object)data.getCropEntryName(), loc);
                errored.set(true);
            }
            data.getParents().forEach(parentPair -> {
                if (list.getByName(parentPair.getFirstParent()) == null) {
                    LOGGER.fatal("Unknown first parent crop entry {} in {}: {}", (Object)parentPair.getFirstParent(), loc, parentPair);
                    errored.set(true);
                }
                if (list.getByName(parentPair.getSecondParent()) == null) {
                    LOGGER.fatal("Unknown second parent crop entry {} in {}: {}", (Object)parentPair.getSecondParent(), loc, parentPair);
                    errored.set(true);
                }
            });
        });
        if (errored.get()) {
            throw new RuntimeException("Unknown crop entries found during validation. Check the log for details");
        }
    }

    private static Path getPath(Path pathIn, ResourceLocation id) {
        return pathIn.resolve("data/" + id.m_135827_() + "/pt2_crops/" + id.m_135815_() + ".json");
    }

    public String m_6055_() {
        return "Crop Entry Configurations";
    }
}

