/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.crops;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.kaneka.planttech2.crops.CropEntryConfigData;
import net.kaneka.planttech2.crops.DropEntry;
import net.kaneka.planttech2.crops.ParentPair;
import net.kaneka.planttech2.crops.RegistryEntrySupplier;
import net.kaneka.planttech2.enums.EnumTemperature;
import net.kaneka.planttech2.utilities.ISerializable;
import net.kaneka.planttech2.utilities.NBTHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;

public class CropConfiguration
implements ISerializable {
    private final boolean enabled;
    private final EnumTemperature temperature;
    private final DropEntry primarySeed;
    private final List<Supplier<Item>> seeds;
    private final List<DropEntry> drops;
    private final List<ParentPair> parents;
    private final Supplier<Block> soil;

    public CropConfiguration(CompoundTag compound) {
        this(compound.m_128471_("enabled"), EnumTemperature.byName(compound.m_128461_("temperature")), DropEntry.of(compound.m_128469_("primaryseed")), NBTHelper.constructListFromString(compound, "seeds", name -> () -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name))), NBTHelper.constructListFromCompound(compound, "drops", DropEntry::of), NBTHelper.constructListFromCompound(compound, "parents", ParentPair::of), () -> (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(compound.m_128461_("soil"))));
    }

    public CropConfiguration(boolean enabled, EnumTemperature temperature, DropEntry primarySeed, List<Supplier<Item>> seeds, List<DropEntry> drops, List<ParentPair> parents, Supplier<Block> soil) {
        this.enabled = enabled;
        this.temperature = temperature;
        this.primarySeed = primarySeed;
        this.seeds = seeds;
        this.drops = drops;
        this.parents = parents;
        this.soil = soil;
    }

    @Override
    public CompoundTag save() {
        CompoundTag compound = new CompoundTag();
        compound.m_128379_("enabled", this.enabled);
        compound.m_128359_("temperature", this.temperature.toString());
        compound.m_128365_("primaryseed", (Tag)this.primarySeed.save());
        NBTHelper.putList(compound, "seeds", this.seeds, seed -> StringTag.m_129297_((String)((Item)seed.get()).getRegistryName().toString()));
        NBTHelper.putSerilizableList(compound, "drops", this.drops);
        NBTHelper.putSerilizableList(compound, "parents", this.parents);
        compound.m_128359_("soil", this.soil.get().getRegistryName().toString());
        return compound;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public EnumTemperature getTemperature() {
        return this.temperature;
    }

    public DropEntry getPrimarySeed() {
        return this.primarySeed;
    }

    public List<Supplier<Item>> getSeeds() {
        return this.seeds;
    }

    public List<DropEntry> getDrops() {
        return this.drops;
    }

    public List<ParentPair> getParents() {
        return this.parents;
    }

    public Supplier<Block> getSoil() {
        return this.soil;
    }

    public float getMutateChanceForParents(String parent1, String parent2) {
        return this.parents.stream().filter(parentPair -> parentPair.test(parent1, parent2)).map(ParentPair::getMutationChance).findFirst().orElse(Float.valueOf(0.0f)).floatValue();
    }

    public static CropConfiguration fromConfigData(CropEntryConfigData data) {
        return new CropConfiguration(data.isEnabled(), data.getTemperature(), data.getPrimarySeed(), data.getSeeds(), data.getDrops(), data.getParents(), data.getSoil());
    }

    public static Builder builder(DropEntry primarySeed) {
        return new Builder(primarySeed);
    }

    public static class Builder {
        boolean enabled = true;
        EnumTemperature temperature = EnumTemperature.NORMAL;
        final DropEntry primarySeed;
        final List<Supplier<Item>> seeds = new ArrayList<Supplier<Item>>();
        final List<DropEntry> drops = new ArrayList<DropEntry>();
        final List<ParentPair> parents = new ArrayList<ParentPair>();
        Supplier<Block> soil = () -> Blocks.f_50493_;

        public Builder(DropEntry primarySeed) {
            this.primarySeed = primarySeed;
        }

        public CropConfiguration build() {
            return new CropConfiguration(this.enabled, this.temperature, this.primarySeed, this.seeds, this.drops, this.parents, this.soil);
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder enabled() {
            return this.enabled(true);
        }

        public Builder disabled() {
            return this.enabled(false);
        }

        public Builder temperature(EnumTemperature newTemp) {
            this.temperature = newTemp;
            return this;
        }

        public Builder seed(Supplier<Item> item) {
            this.seeds.add(item);
            return this;
        }

        public Builder seed(ResourceLocation item) {
            return this.seed(RegistryEntrySupplier.of(item, ForgeRegistries.ITEMS));
        }

        public Builder seed(String item) {
            return this.seed(new ResourceLocation(item));
        }

        public Builder parents(ParentPair entry) {
            this.parents.add(entry);
            return this;
        }

        public Builder parents(String parent1, String parent2, float chance) {
            return this.parents(ParentPair.of(parent1, parent2, chance));
        }

        public Builder parents(ParentPair ... entries) {
            this.parents.addAll(Arrays.asList(entries));
            return this;
        }

        public Builder drop(DropEntry entry) {
            this.drops.add(entry);
            return this;
        }

        public Builder drop(Supplier<Item> item, int min, int max) {
            return this.drop(DropEntry.of(item, min, max));
        }

        public Builder drop(ResourceLocation item, int min, int max) {
            return this.drop(RegistryEntrySupplier.of(item, ForgeRegistries.ITEMS), min, max);
        }

        public Builder drop(String item, int min, int max) {
            return this.drop(new ResourceLocation(item), min, max);
        }

        public Builder drop(DropEntry ... entries) {
            this.drops.addAll(Arrays.asList(entries));
            return this;
        }

        public Builder soil(Supplier<Block> newSoil) {
            this.soil = newSoil;
            return this;
        }
    }
}

