/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.crops;

import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.kaneka.planttech2.crops.CropConfiguration;
import net.kaneka.planttech2.crops.DropEntry;
import net.kaneka.planttech2.crops.ParentPair;
import net.kaneka.planttech2.enums.EnumTraitsInt;
import net.kaneka.planttech2.hashmaps.HashMapCropTraits;
import net.kaneka.planttech2.utilities.ISerializable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class CropEntry
implements Comparable<CropEntry>,
ISerializable {
    private final String name;
    private final int seedColor;
    private final boolean hasParticle;
    private final CropConfiguration defaultConfig;
    private CropConfiguration currentConfig;

    public CropEntry(CompoundTag compound) {
        this(compound.m_128461_("name"), compound.m_128451_("colour"), compound.m_128471_("hasparticle"), new CropConfiguration(compound.m_128469_("defaultconfig")));
        this.currentConfig = new CropConfiguration(compound.m_128469_("currentconfig"));
    }

    public CropEntry(String name, int seedColor, boolean hasParticle, CropConfiguration defaultConfig) {
        this.name = name;
        this.seedColor = seedColor;
        this.hasParticle = hasParticle;
        this.currentConfig = this.defaultConfig = defaultConfig;
    }

    @Override
    public CompoundTag save() {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("name", this.name);
        compound.m_128405_("colour", this.seedColor);
        compound.m_128379_("hasparticle", this.hasParticle);
        compound.m_128365_("defaultconfig", (Tag)this.defaultConfig.save());
        compound.m_128365_("currentconfig", (Tag)this.currentConfig.save());
        return compound;
    }

    public String getName() {
        return this.name;
    }

    public Component getDisplayName() {
        return new TranslatableComponent("crop." + this.name);
    }

    public int getSeedColor() {
        return this.seedColor;
    }

    public boolean hasParticle() {
        return this.hasParticle;
    }

    public void setConfiguration(CropConfiguration config) {
        if (config == null) {
            config = this.defaultConfig;
        }
        this.currentConfig = config;
    }

    public CropConfiguration getConfiguration() {
        return this.currentConfig;
    }

    public boolean isSeed(Item item) {
        return this.getConfiguration().getSeeds().stream().anyMatch(sup -> sup.get() == item);
    }

    public List<ItemStack> calculateDrops(List<ItemStack> drops, HashMapCropTraits traits, int growstate, Random rand) {
        ItemStack seed = this.getPrimarySeed().getDroppedStack(traits.getTrait(EnumTraitsInt.FERTILITY), EnumTraitsInt.FERTILITY.getMax(), rand);
        if (!seed.m_41619_()) {
            if (growstate < 7) {
                seed.m_41764_(1);
            }
            drops.add(traits.addToItemStack(seed));
        }
        if (growstate > 6) {
            List<DropEntry> dropEntries = this.getConfiguration().getDrops();
            for (int i = 1; i < dropEntries.size(); ++i) {
                DropEntry drop = dropEntries.get(i);
                ItemStack addDrop = drop.getDroppedStack(traits.getTrait(EnumTraitsInt.PRODUCTIVITY), EnumTraitsInt.PRODUCTIVITY.getMax(), rand);
                if (addDrop.m_41619_()) continue;
                drops.add(addDrop);
            }
        }
        return drops;
    }

    public NonNullList<ItemStack> calculateDropsReduced(NonNullList<ItemStack> drops, HashMapCropTraits traits, int growstate, Random rand) {
        List<DropEntry> dropEntries = this.getConfiguration().getDrops();
        if (growstate > 6) {
            ItemStack seed = this.getPrimarySeed().getDroppedStack(traits.getTrait(EnumTraitsInt.FERTILITY), EnumTraitsInt.FERTILITY.getMax(), rand);
            if (!seed.m_41619_() && seed.m_41613_() > 1) {
                seed.m_41774_(1);
                drops.add((Object)traits.addToItemStack(seed));
            }
            for (DropEntry drop : dropEntries) {
                ItemStack stack = drop.getDroppedStack(traits.getTrait(EnumTraitsInt.PRODUCTIVITY), EnumTraitsInt.PRODUCTIVITY.getMax(), rand);
                if (stack.m_41619_()) continue;
                drops.add((Object)stack);
            }
        }
        return drops;
    }

    public boolean isChild(String parent1, String parent2) {
        return this.getConfiguration().getParents().stream().anyMatch(pair -> pair.test(parent1, parent2));
    }

    public List<Supplier<Item>> getSeeds() {
        return this.getConfiguration().getSeeds();
    }

    public List<DropEntry> getAdditionalDrops() {
        return this.getConfiguration().getDrops();
    }

    public DropEntry getPrimarySeed() {
        return this.getConfiguration().getPrimarySeed();
    }

    public List<ParentPair> getParents() {
        return this.getConfiguration().getParents();
    }

    public boolean isEnabled() {
        return this.getConfiguration().isEnabled();
    }

    @Override
    public int compareTo(CropEntry o) {
        return this.getName().compareTo(o.getName());
    }
}

