/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.crops;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.crops.CropEntryConfigData;
import net.kaneka.planttech2.crops.DropEntry;
import net.kaneka.planttech2.crops.ParentPair;
import net.kaneka.planttech2.packets.CropListSyncMessage;
import net.kaneka.planttech2.packets.PlantTech2PacketHandler;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fmllegacy.network.PacketDistributor;
import net.minecraftforge.fmllegacy.server.ServerLifecycleHooks;

public class CropListReloadListener
extends SimpleJsonResourceReloadListener {
    public static final String FOLDER = "pt2_crops";
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(CropEntryConfigData.class, (Object)CropEntryConfigData.Serializer.INSTANCE).registerTypeAdapter(DropEntry.class, (Object)DropEntry.Serializer.INSTANCE).registerTypeAdapter(ParentPair.class, (Object)ParentPair.Serializer.INSTANCE).create();

    public CropListReloadListener() {
        super(GSON, FOLDER);
    }

    protected void apply(Map<ResourceLocation, JsonElement> elementMap, ResourceManager resourceManager, ProfilerFiller profiler) {
        PlantTechMain.LOGGER.debug("Loading crop configurations");
        HashMap<ResourceLocation, CropEntryConfigData> configsDefault = new HashMap<ResourceLocation, CropEntryConfigData>();
        HashMap<ResourceLocation, CropEntryConfigData> configsOther = new HashMap<ResourceLocation, CropEntryConfigData>();
        LinkedList<ResourceLocation> keys = new LinkedList<ResourceLocation>(elementMap.keySet());
        for (ResourceLocation key : keys) {
            try {
                JsonElement element = elementMap.get(key);
                if (!CraftingHelper.processConditions((JsonObject)GsonHelper.m_13918_((JsonElement)element, (String)"top element"), (String)"conditions")) {
                    PlantTechMain.LOGGER.debug("Skipping loading crop configuration {} as it's conditions were not met", (Object)key);
                    continue;
                }
                if (key.m_135827_().equals("planttech2")) {
                    configsDefault.put(key, (CropEntryConfigData)GSON.fromJson(element, CropEntryConfigData.class));
                    continue;
                }
                configsOther.put(key, (CropEntryConfigData)GSON.fromJson(element, CropEntryConfigData.class));
            }
            catch (JsonSyntaxException | IllegalArgumentException ex) {
                PlantTechMain.LOGGER.error("Error while loading crop configuration {}", (Object)key, (Object)ex);
            }
        }
        PlantTechMain.getCropList().configureFromConfigData(configsDefault.values());
        PlantTechMain.getCropList().configureFromConfigData(configsOther.values());
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            PlantTechMain.LOGGER.info("syncing crop list to clients");
            PlantTech2PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new CropListSyncMessage());
        } else {
            PlantTechMain.LOGGER.info("Server is not up yet, will not send the changes to clients");
        }
    }

    public static JsonElement toJson(CropEntryConfigData data) {
        return GSON.toJsonTree((Object)data);
    }
}

