/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.crops;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.function.BiPredicate;
import net.kaneka.planttech2.utilities.ISerializable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;

public class ParentPair
implements BiPredicate<String, String>,
ISerializable {
    private final String parent1;
    private final String parent2;
    private final float mutationChance;

    private ParentPair(String parent1, String parent2, float mutationChance) {
        this.parent1 = parent1;
        this.parent2 = parent2;
        this.mutationChance = mutationChance;
    }

    @Override
    public CompoundTag save() {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("parent1", this.parent1);
        compound.m_128359_("parent2", this.parent2);
        compound.m_128350_("mutation", this.mutationChance);
        return compound;
    }

    @Override
    public boolean test(String parent1, String parent2) {
        return this.parent1.equals(parent1) && this.parent2.equals(parent2) || this.parent1.equals(parent2) && this.parent2.equals(parent1);
    }

    public String getParent(int id) {
        switch (id) {
            case 0: {
                return this.parent1;
            }
            case 1: {
                return this.parent2;
            }
        }
        return "";
    }

    public String getFirstParent() {
        return this.parent1;
    }

    public String getSecondParent() {
        return this.parent2;
    }

    public float getMutationChance() {
        return this.mutationChance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParentPair that = (ParentPair)o;
        return Float.compare(that.mutationChance, this.mutationChance) == 0 && this.parent1.equals(that.parent1) && this.parent2.equals(that.parent2);
    }

    public int hashCode() {
        return Objects.hash(this.parent1, this.parent2, Float.valueOf(this.mutationChance));
    }

    public String toString() {
        return "ParentPair{parent1='" + this.parent1 + "', parent2='" + this.parent2 + "', mutationChance=" + this.mutationChance + "}";
    }

    public static ParentPair of(CompoundTag compound) {
        return new ParentPair(compound.m_128461_("parent1"), compound.m_128461_("parent2"), compound.m_128457_("mutation"));
    }

    public static ParentPair of(String firstParent, String secondParent, float mutationChance) {
        return new ParentPair(firstParent, secondParent, mutationChance);
    }

    public static class Serializer
    implements JsonSerializer<ParentPair>,
    JsonDeserializer<ParentPair> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        public JsonElement serialize(ParentPair src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            obj.addProperty("parent_1", src.getFirstParent());
            obj.addProperty("parent_2", src.getSecondParent());
            obj.addProperty("chance", (Number)Float.valueOf(src.getMutationChance()));
            return obj;
        }

        public ParentPair deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            String parent1 = GsonHelper.m_13906_((JsonObject)obj, (String)"parent_1");
            String parent2 = GsonHelper.m_13906_((JsonObject)obj, (String)"parent_2");
            float mutateChance = GsonHelper.m_13915_((JsonObject)obj, (String)"chance");
            return new ParentPair(parent1, parent2, mutateChance);
        }

        public ParentPair read(FriendlyByteBuf buf) {
            String parent1 = buf.m_130277_();
            String parent2 = buf.m_130277_();
            float chance = buf.readFloat();
            return ParentPair.of(parent1, parent2, chance);
        }

        public void write(ParentPair pair, FriendlyByteBuf buf) {
            buf.m_130070_(pair.getFirstParent());
            buf.m_130070_(pair.getSecondParent());
            buf.writeFloat(pair.getMutationChance());
        }
    }
}

