/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.datagen;

import java.util.Objects;
import javax.annotation.Nullable;
import net.kaneka.planttech2.PlantTechClient;
import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.registries.ModItems;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ItemModels
extends ItemModelProvider {
    protected final ResourceLocation generated = this.mcLoc("generated");
    protected final ResourceLocation handheld = this.mcLoc("handheld");

    public ItemModels(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "planttech2", existingFileHelper);
    }

    protected void registerModels() {
        this.addCrops();
        this.addBulbs();
        this.addBiomassContainer();
        this.addChipsUpgrades();
        this.addAuraCores();
        this.singleTexturedItem((ItemLike)ModItems.ADVANCED_ANALYSER);
        this.singleTexturedItem((ItemLike)ModItems.ANALYSER);
        this.singleTexturedItem((ItemLike)ModItems.BIOMASS);
        this.singleTexturedItem((ItemLike)ModItems.BIOMASS_BUCKET);
        this.singleTexture("cable", this.generated, "layer0", this.itemPrefix("cable"));
        this.singleTexturedItem((ItemLike)ModItems.COLOR_PARTICLES);
        this.singleTexturedItem((ItemLike)ModItems.CROPREMOVER);
        this.singleTexturedItem((ItemLike)ModItems.CYBERARMOR_BOOTS, "armor/cyberarmor_boots");
        this.singleTexturedItem((ItemLike)ModItems.CYBERARMOR_CHEST, "armor/cyberarmor_chest");
        this.singleTexturedItem((ItemLike)ModItems.CYBERARMOR_HELMET, "armor/cyberarmor_helmet");
        this.singleTexturedItem((ItemLike)ModItems.CYBERARMOR_LEGGINGS, "armor/cyberarmor_leggings");
        this.singleTexturedItem((ItemLike)ModItems.CYBERDAGGER, this.handheld, "weapons/cyberdagger");
        this.singleTexturedItem((ItemLike)ModItems.CYBERKATANA, this.handheld, "weapons/cyberkatana");
        this.singleTexturedItem((ItemLike)ModItems.CYBERRAPIER, this.handheld, "weapons/cyberrapier");
        this.singleTexturedItem((ItemLike)ModItems.DANCIUM_INGOT);
        this.singleTexturedItem((ItemLike)ModItems.DANCIUM_NUGGET);
        this.singleTexturedItem((ItemLike)ModItems.DARK_CRYSTAL);
        this.singleTexturedItem((ItemLike)ModItems.ENERGYSTORAGE_TIER_1);
        this.singleTexturedItem((ItemLike)ModItems.ENERGYSTORAGE_TIER_2);
        this.singleTexturedItem((ItemLike)ModItems.ENERGYSTORAGE_TIER_3);
        this.singleTexturedItem((ItemLike)ModItems.FERTILIZER_TIER_1, "fert_1");
        this.singleTexturedItem((ItemLike)ModItems.FERTILIZER_TIER_2, "fert_2");
        this.singleTexturedItem((ItemLike)ModItems.FERTILIZER_TIER_3, "fert_3");
        this.singleTexturedItem((ItemLike)ModItems.FERTILIZER_TIER_4, "fert_4");
        this.singleTexturedItem((ItemLike)ModItems.FERTILIZER_CREATIVE, "fert_creative");
        this.singleTexturedItem((ItemLike)ModItems.KANEKIUM_INGOT);
        this.singleTexturedItem((ItemLike)ModItems.KANEKIUM_NUGGET);
        this.singleTexturedItem((ItemLike)ModItems.KINNOIUM_INGOT);
        this.singleTexturedItem((ItemLike)ModItems.KINNOIUM_NUGGET);
        this.singleTexturedItem((ItemLike)ModItems.LENTHURIUM_INGOT);
        this.singleTexturedItem((ItemLike)ModItems.LENTHURIUM_NUGGET);
        this.singleTexturedItem((ItemLike)ModItems.PLANTCARD);
        this.singleTexturedItem((ItemLike)ModItems.PLANTIUM_INGOT);
        this.singleTexturedItem((ItemLike)ModItems.PLANTIUM_NUGGET);
        this.singleTexturedItem((ItemLike)ModItems.RANGEUPGRADE_TIER_1);
        this.singleTexturedItem((ItemLike)ModItems.RANGEUPGRADE_TIER_2);
        this.singleTexturedItem((ItemLike)ModItems.RANGEUPGRADE_TIER_3);
        this.singleTexturedItem((ItemLike)ModItems.RANGEUPGRADE_TIER_4);
        this.singleTexturedItem((ItemLike)ModItems.REDSTONE_INFUSED);
        this.singleTexturedItem((ItemLike)ModItems.TELEPORTER, this.mcLoc("item/barrier"));
        this.singleTexturedItem((ItemLike)ModItems.TESTITEM, this.mcLoc("item/barrier"));
        this.singleTexturedItem((ItemLike)ModItems.THERMOMETER);
        this.singleTexturedItem((ItemLike)ModItems.WHITE_CRYSTAL);
    }

    private void addCrops() {
        ResourceLocation seedsTexture = this.itemPrefix("seeds");
        ResourceLocation particlesTexture = this.itemPrefix("particles");
        PlantTechMain.getCropList().values().forEach(entry -> {
            String name = entry.getName();
            this.singleTexture(name + "_seeds", this.generated, "layer0", seedsTexture);
            if (entry.hasParticle()) {
                this.singleTexture(name + "_particles", this.generated, "layer0", particlesTexture);
            }
        });
    }

    private void addBiomassContainer() {
        String basePath = ModItems.BIOMASSCONTAINER.getRegistryName().m_135815_();
        ItemModelBuilder baseContainerItem = (ItemModelBuilder)this.withExistingParent(basePath, this.generated);
        ItemModelBuilder empty = (ItemModelBuilder)this.withExistingParent(basePath + "_empty", this.generated);
        baseContainerItem.override().predicate(PlantTechClient.FILLED_PREDICATE, 0.0f).model((ModelFile)empty);
        baseContainerItem.texture("layer0", this.itemPrefix("biomasscontainer_empty"));
        empty.texture("layer0", this.itemPrefix("biomasscontainer_empty"));
        int max = 9;
        for (int i = 0; i < max; ++i) {
            ItemModelBuilder override = (ItemModelBuilder)this.withExistingParent(basePath + "_" + i, this.generated);
            override.texture("layer0", this.itemPrefix("biomasscontainer_" + i));
            baseContainerItem.override().predicate(PlantTechClient.FILLED_PREDICATE, (float)i + 1.0f).model((ModelFile)override);
        }
    }

    private void addChipsUpgrades() {
        this.singleTexturedItem((ItemLike)ModItems.AQUA_AFFINITY_CHIP, "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.ARMORCHIP_TIER_1, "chips/armor_tier_1");
        this.singleTexturedItem((ItemLike)ModItems.ARMORCHIP_TIER_2, "chips/armor_tier_2");
        this.singleTexturedItem((ItemLike)ModItems.ARMORCHIP_TIER_3, "chips/armor_tier_3");
        this.singleTexturedItem((ItemLike)ModItems.ATTACKCHIP_TIER_1, "chips/attack_tier_1");
        this.singleTexturedItem((ItemLike)ModItems.ATTACKCHIP_TIER_2, "chips/attack_tier_2");
        this.singleTexturedItem((ItemLike)ModItems.ATTACKCHIP_TIER_3, "chips/attack_tier_3");
        this.singleTexturedItem((ItemLike)ModItems.ATTACKSPEEDCHIP_TIER_1, "chips/attackspeed_tier_1");
        this.singleTexturedItem((ItemLike)ModItems.ATTACKSPEEDCHIP_TIER_2, "chips/attackspeed_tier_2");
        this.singleTexturedItem((ItemLike)ModItems.ATTACKSPEEDCHIP_TIER_3, "chips/attackspeed_tier_3");
        this.singleTexturedItem((ItemLike)ModItems.BLAST_PROTECTION_CHIP, "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.BANE_OF_ARTHROPODS_CHIP, "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.BREAKDOWNRATECHIP_TIER_1, "chips/harvestspeed_tier_1");
        this.singleTexturedItem((ItemLike)ModItems.BREAKDOWNRATECHIP_TIER_2, "chips/harvestspeed_tier_2");
        this.singleTexturedItem((ItemLike)ModItems.BREAKDOWNRATECHIP_TIER_3, "chips/harvestspeed_tier_3");
        this.singleTexturedItem((ItemLike)ModItems.CAPACITYCHIP_TIER_1, "chips/capacity_tier_1");
        this.singleTexturedItem((ItemLike)ModItems.CAPACITYCHIP_TIER_2, "chips/capacity_tier_2");
        this.singleTexturedItem((ItemLike)ModItems.CAPACITYCHIP_TIER_3, "chips/capacity_tier_3");
        this.singleTexturedItem((ItemLike)ModItems.CAPACITYUPGRADE_TIER_1);
        this.singleTexturedItem((ItemLike)ModItems.CAPACITYUPGRADE_TIER_2);
        this.singleTexturedItem((ItemLike)ModItems.CAPACITYUPGRADE_TIER_3);
        this.singleTexturedItem((ItemLike)ModItems.CHIP_UPGRADEPACK_CAPACITY_1, "chips/upgradepack/capacity_1");
        this.singleTexturedItem((ItemLike)ModItems.CHIP_UPGRADEPACK_CAPACITY_2, "chips/upgradepack/capacity_2");
        this.singleTexturedItem((ItemLike)ModItems.CHIP_UPGRADEPACK_HARVESTLEVEL_1, "chips/upgradepack/harvestlevel_1");
        this.singleTexturedItem((ItemLike)ModItems.CHIP_UPGRADEPACK_HARVESTLEVEL_2, "chips/upgradepack/harvestlevel_2");
        this.singleTexturedItem((ItemLike)ModItems.CHIP_UPGRADEPACK_REACTOR_1, "chips/upgradepack/reactor_1");
        this.singleTexturedItem((ItemLike)ModItems.CHIP_UPGRADEPACK_REACTOR_2, "chips/upgradepack/reactor_2");
        this.singleTexturedItem((ItemLike)ModItems.DEPTH_STRIDER_CHIP, "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.EFFICIENCY_CHIP, "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.EMPTY_UPGRADECHIP_TIER_1, "chips/template_tier_1");
        this.singleTexturedItem((ItemLike)ModItems.EMPTY_UPGRADECHIP_TIER_2, "chips/template_tier_2");
        this.singleTexturedItem((ItemLike)ModItems.EMPTY_UPGRADECHIP_TIER_3, "chips/template_tier_3");
        this.singleTexturedItem((ItemLike)ModItems.FEATHER_FALLING_CHIP, "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.FIRE_ASPECT_CHIP, "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.FIRE_PROTECTION_CHIP, "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.FLAME_CHIP, "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.FORTUNE_CHIP, "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.FROST_WALKER_CHIP, "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.HARVESTLEVELCHIP_TIER_1, "chips/harvestlevel_tier_1");
        this.singleTexturedItem((ItemLike)ModItems.HARVESTLEVELCHIP_TIER_2, "chips/harvestlevel_tier_2");
        this.singleTexturedItem((ItemLike)ModItems.HARVESTLEVELCHIP_TIER_3, "chips/harvestlevel_tier_3");
        this.singleTexturedItem((ItemLike)ModItems.INFINITY_CHIP, "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.KNOCKBACK_CHIP, "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.KNOWLEDGECHIP_TIER_0);
        this.singleTexturedItem((ItemLike)ModItems.KNOWLEDGECHIP_TIER_1);
        this.singleTexturedItem((ItemLike)ModItems.KNOWLEDGECHIP_TIER_2);
        this.singleTexturedItem((ItemLike)ModItems.KNOWLEDGECHIP_TIER_3);
        this.singleTexturedItem((ItemLike)ModItems.KNOWLEDGECHIP_TIER_4);
        this.singleTexturedItem((ItemLike)ModItems.KNOWLEDGECHIP_TIER_5);
        this.singleTexturedItem((ItemLike)ModItems.LOOTING_CHIP, "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.POWER_CHIP, "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.PROJECTILE_PROTECTION_CHIP, "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.PROTECTION_CHIP, "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.PUNCH_CHIP, "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.REACTORCHIP_TIER_1, "chips/reactor_tier_1");
        this.singleTexturedItem((ItemLike)ModItems.REACTORCHIP_TIER_2, "chips/reactor_tier_2");
        this.singleTexturedItem((ItemLike)ModItems.REACTORCHIP_TIER_3, "chips/reactor_tier_3");
        this.singleTexturedItem((ItemLike)ModItems.RESPIRATION_CHIP, "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.SHARPNESS_CHIP, "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.SILK_TOUCH_CHIP, "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.SMITE_CHIP, "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.SOLARFOCUS_TIER_1, "solarfocus_tier_1");
        this.singleTexturedItem((ItemLike)ModItems.SOLARFOCUS_TIER_2, "solarfocus_tier_2");
        this.singleTexturedItem((ItemLike)ModItems.SOLARFOCUS_TIER_3, "solarfocus_tier_3");
        this.singleTexturedItem((ItemLike)ModItems.SOLARFOCUS_TIER_4, "solarfocus_tier_4");
        this.singleTexturedItem((ItemLike)ModItems.SPEEDUPGRADE_TIER_1);
        this.singleTexturedItem((ItemLike)ModItems.SPEEDUPGRADE_TIER_2);
        this.singleTexturedItem((ItemLike)ModItems.SPEEDUPGRADE_TIER_3);
        this.singleTexturedItem((ItemLike)ModItems.SPEEDUPGRADE_TIER_4);
        this.singleTexturedItem((ItemLike)ModItems.SWEEPING_CHIP, "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.THORNS_CHIP, "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.TOUGHNESSCHIP_TIER_1, "chips/toughness_tier_1");
        this.singleTexturedItem((ItemLike)ModItems.TOUGHNESSCHIP_TIER_2, "chips/toughness_tier_2");
        this.singleTexturedItem((ItemLike)ModItems.TOUGHNESSCHIP_TIER_3, "chips/toughness_tier_3");
        this.singleTexturedItem((ItemLike)ModItems.UNBREAKING_CHIP, "chips/enchantment_chip");
        this.singleTexturedItem((ItemLike)ModItems.UNLOCKCHIP_AXE, "chips/axe");
        this.singleTexturedItem((ItemLike)ModItems.UNLOCKCHIP_HOE, "chips/hoe");
        this.singleTexturedItem((ItemLike)ModItems.UNLOCKCHIP_SHEARS, "chips/shears");
        this.singleTexturedItem((ItemLike)ModItems.UNLOCKCHIP_SHOVEL, "chips/shovel");
    }

    private void addAuraCores() {
        this.singleTexturedItem((ItemLike)ModItems.AURA_CORE_LIGHT_DECREASE_I);
        this.singleTexturedItem((ItemLike)ModItems.AURA_CORE_LIGHT_DECREASE_II);
        this.singleTexturedItem((ItemLike)ModItems.AURA_CORE_LIGHT_DECREASE_III);
        this.singleTexturedItem((ItemLike)ModItems.AURA_CORE_WATER_RANGE_DECREASE_I);
        this.singleTexturedItem((ItemLike)ModItems.AURA_CORE_WATER_RANGE_DECREASE_II);
        this.singleTexturedItem((ItemLike)ModItems.AURA_CORE_WATER_RANGE_DECREASE_III);
        this.singleTexturedItem((ItemLike)ModItems.AURA_CORE_TEMPERATURE_EXTREME_COLD);
        this.singleTexturedItem((ItemLike)ModItems.AURA_CORE_TEMPERATURE_COLD);
        this.singleTexturedItem((ItemLike)ModItems.AURA_CORE_TEMPERATURE_NORMAL);
        this.singleTexturedItem((ItemLike)ModItems.AURA_CORE_TEMPERATURE_WARM);
        this.singleTexturedItem((ItemLike)ModItems.AURA_CORE_TEMPERATURE_EXTREME_WARM);
        this.singleTexturedItem((ItemLike)ModItems.AURA_CORE_FERTILITY_INCREASE_I);
        this.singleTexturedItem((ItemLike)ModItems.AURA_CORE_FERTILITY_INCREASE_II);
        this.singleTexturedItem((ItemLike)ModItems.AURA_CORE_FERTILITY_INCREASE_III);
        this.singleTexturedItem((ItemLike)ModItems.AURA_CORE_PRODUCTIVITY_INCREASE_I);
        this.singleTexturedItem((ItemLike)ModItems.AURA_CORE_PRODUCTIVITY_INCREASE_II);
        this.singleTexturedItem((ItemLike)ModItems.AURA_CORE_PRODUCTIVITY_INCREASE_III);
    }

    private void addBulbs() {
        this.bulbItem("chipalyzer");
        this.bulbItem("compressor");
        this.bulbItem("dna_cleaner");
        this.bulbItem("dna_combiner");
        this.bulbItem("dna_extractor");
        this.bulbItem("dna_remover");
        this.bulbItem("energy_supplier");
        this.bulbItem("identifier");
        this.bulbItem("infuser");
        this.bulbItem("machinebulbreprocessor");
        this.bulbItem("mega_furnace");
        this.bulbItem("plantfarm");
        this.bulbItem("seedconstructor");
        this.bulbItem("seedsqueezer");
        this.bulbItem("solargenerator");
    }

    private void bulbItem(String item) {
        ItemModelBuilder model = (ItemModelBuilder)this.withExistingParent(item + "_bulb", this.generated);
        model.texture("layer0", this.itemPrefix("machinebulbs/machinebulb_layer_1"));
        model.texture("layer1", this.itemPrefix("machinebulbs/machinebulb_layer_2_" + item));
    }

    private void singleTexturedItem(ItemLike item) {
        this.singleTexturedItem(item, (ResourceLocation)null);
    }

    private void singleTexturedItem(ItemLike item, String texturePath) {
        this.singleTexturedItem(item, this.generated, texturePath);
    }

    private void singleTexturedItem(ItemLike item, ResourceLocation parent, String texturePath) {
        this.singleTexturedItem(item, parent, this.itemPrefix(texturePath));
    }

    private void singleTexturedItem(ItemLike item, @Nullable ResourceLocation textureLocation) {
        this.singleTexturedItem(item, this.generated, textureLocation);
    }

    private void singleTexturedItem(ItemLike item, ResourceLocation parent, @Nullable ResourceLocation textureLocation) {
        ResourceLocation loc = Objects.requireNonNull(item.m_5456_().getRegistryName());
        if (textureLocation == null) {
            textureLocation = this.itemLoc(loc, "");
        }
        this.singleTexture(loc.m_135815_(), parent, "layer0", textureLocation);
    }

    private ResourceLocation itemLoc(ResourceLocation loc, String subPath) {
        return new ResourceLocation(loc.m_135827_(), "items/" + subPath + loc.m_135815_());
    }

    private ResourceLocation itemPrefix(String path) {
        return new ResourceLocation("planttech2", "items/" + path);
    }
}

