/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.datagen;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.registries.ModItems;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class LootTables
extends LootTableProvider {
    private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> tables = new ArrayList<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>>();

    public LootTables(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        this.tables.clear();
        this.standardDropTable(ModBlocks.CABLE);
        this.standardDropTable(ModBlocks.CARVER);
        this.standardDropTable(ModBlocks.CHIPALYZER);
        this.standardDropTable(ModBlocks.COMPRESSOR);
        this.standardDropTable(ModBlocks.CROPBARS);
        this.standardDropTable(ModBlocks.DANCIUM_BLOCK);
        this.standardDropTable(ModBlocks.DNA_CLEANER);
        this.standardDropTable(ModBlocks.DNA_COMBINER);
        this.standardDropTable(ModBlocks.DNA_EXTRACTOR);
        this.standardDropTable(ModBlocks.DNA_REMOVER);
        this.standardDropTable(ModBlocks.ENERGYSTORAGE);
        this.standardDropTable(ModBlocks.ENERGY_SUPPLIER);
        this.standardDropTable(ModBlocks.IDENTIFIER);
        this.standardDropTable(ModBlocks.INFUSER);
        this.standardDropTable(ModBlocks.KANEKIUM_BLOCK);
        this.standardDropTable(ModBlocks.KINNOIUM_BLOCK);
        this.standardDropTable(ModBlocks.LENTHURIUM_BLOCK);
        this.standardDropTable(ModBlocks.MACHINEBULBREPROCESSOR);
        this.standardDropTable(ModBlocks.MACHINESHELL_IRON);
        this.standardDropTable(ModBlocks.MACHINESHELL_PLANTIUM);
        this.standardDropTable(ModBlocks.MEGAFURNACE);
        this.standardDropTable(ModBlocks.PLANTFARM);
        this.standardDropTable(ModBlocks.PLANTIUM_BLOCK);
        this.standardDropTable(ModBlocks.SEEDCONSTRUCTOR);
        this.standardDropTable(ModBlocks.SEEDSQUEEZER);
        this.standardDropTable(ModBlocks.SOLARGENERATOR);
        this.standardDropTable(ModBlocks.UNIVERSAL_SOIL);
        this.standardDropTable(ModBlocks.UNIVERSAL_SOIL_INFUSED);
        this.silkFortuneBlockTable(ModBlocks.DARK_CRYSTAL_ORE, (ItemLike)ModItems.DARK_CRYSTAL);
        this.silkFortuneBlockTable(ModBlocks.WHITE_CRYSTAL_ORE, (ItemLike)ModItems.WHITE_CRYSTAL);
        this.silkBlockTable(ModBlocks.INFUSED_ICE);
        this.silkBlockTable(ModBlocks.INFUSED_PACKED_ICE);
        this.silkBlockTable(ModBlocks.INFUSED_BLUE_ICE);
        this.silkBlockTable(ModBlocks.BLACK_ICE);
        this.standardDropTable(ModBlocks.INFUSED_STONE);
        this.standardDropTable(ModBlocks.INFUSED_COBBLESTONE);
        ModBlocks.HEDGE_BLOCKS.forEach(this::standardDropTable);
        return this.tables;
    }

    void silkBlockTable(Block b) {
        LootPool.Builder pool = LootPool.m_79043_();
        pool.m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f));
        LootPoolSingletonContainer.Builder silk = (LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)b).m_6509_(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1)))));
        pool.m_79076_((LootPoolEntryContainer.Builder)AlternativesEntry.m_79395_((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{silk}));
        this.blockTable(b, LootTable.m_79147_().m_79161_(pool));
    }

    void silkFortuneBlockTable(Block b, ItemLike item) {
        LootPool.Builder pool = LootPool.m_79043_();
        pool.m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f));
        LootPoolSingletonContainer.Builder silk = (LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)b).m_6509_(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1)))));
        LootPoolSingletonContainer.Builder fortune = LootItem.m_79579_((ItemLike)item).m_5577_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_()).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_));
        pool.m_79076_((LootPoolEntryContainer.Builder)AlternativesEntry.m_79395_((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{silk, fortune}));
        this.blockTable(b, LootTable.m_79147_().m_79161_(pool));
    }

    void standardDropTable(Block b) {
        this.blockTable(b, LootTable.m_79147_().m_79161_(this.createStandardDrops((ItemLike)b)));
    }

    void blockTable(Block b, LootTable.Builder lootTable) {
        this.addTable(b.m_60589_(), lootTable, LootContextParamSets.f_81421_);
    }

    void addTable(ResourceLocation path, LootTable.Builder lootTable, LootContextParamSet paramSet) {
        this.tables.add((Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>)Pair.of(() -> lootBuilder -> lootBuilder.accept(path, lootTable), (Object)paramSet));
    }

    LootPool.Builder createStandardDrops(ItemLike itemProvider) {
        return LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(ExplosionCondition.m_81661_()).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)itemProvider));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationtracker) {
        map.forEach((p_218436_2_, p_218436_3_) -> net.minecraft.world.level.storage.loot.LootTables.m_79202_((ValidationContext)validationtracker, (ResourceLocation)p_218436_2_, (LootTable)p_218436_3_));
    }
}

