/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.datagen.blocks;

import com.google.common.collect.ImmutableMap;
import net.kaneka.planttech2.blocks.Hedge;
import net.kaneka.planttech2.blocks.baseclasses.CustomFenceBlock;
import net.kaneka.planttech2.datagen.blocks.BlockModelBase;
import net.kaneka.planttech2.datagen.blocks.BlockStateGenerator;
import net.kaneka.planttech2.registries.ModBlocks;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;

public class HedgeModels
extends BlockModelBase {
    HedgeModels(BlockStateGenerator states) {
        super(states);
    }

    @Override
    public void registerStatesAndModels() {
        BlockModelBuilder hedgeBase = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/hedge/base/hedge_base", "block/block")).element().from(5.0f, 5.0f, 5.0f).to(11.0f, 16.0f, 11.0f).allFaces((d, e) -> e.texture("#leaves").tintindex(0)).end()).element().from(4.0f, 0.0f, 4.0f).to(5.0f, 4.0f, 5.0f).textureAll("#wood").end()).element().from(4.0f, 0.0f, 11.0f).to(5.0f, 4.0f, 12.0f).textureAll("#wood").end()).element().from(11.0f, 0.0f, 11.0f).to(12.0f, 4.0f, 12.0f).textureAll("#wood").end()).element().from(11.0f, 0.0f, 4.0f).to(12.0f, 4.0f, 5.0f).textureAll("#wood").end()).element().from(5.0f, 0.0f, 5.0f).to(11.0f, 4.0f, 11.0f).allFaces((d, e) -> e.texture("#soil").tintindex(1)).end();
        BlockModelBuilder hedgeAdding = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("block/hedge/base/hedge_adding")).element().from(11.0f, 5.0f, 5.0f).to(16.0f, 16.0f, 11.0f).allFaces((d, e) -> e.texture("#leaves").tintindex(0)).end()).element().from(12.0f, 0.0f, 11.0f).to(16.0f, 4.0f, 12.0f).textureAll("#wood").end()).element().from(12.0f, 0.0f, 4.0f).to(16.0f, 4.0f, 5.0f).textureAll("#wood").end()).element().from(11.0f, 0.0f, 5.0f).to(16.0f, 4.0f, 11.0f).allFaces((d, e) -> e.texture("#soil").tintindex(1)).end();
        BlockModelBuilder hedgeNone = (BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("block/hedge/base/hedge_none")).element().from(11.0f, 0.0f, 5.0f).to(12.0f, 4.0f, 11.0f).textureAll("#wood").end();
        ImmutableMap soilToTexture = ImmutableMap.of((Object)"grass", (Object)"grass_block_top", (Object)"podzol", (Object)"podzol_top");
        for (Hedge hedgeBlock : ModBlocks.HEDGE_BLOCKS) {
            ResourceLocation leavesLoc = hedgeBlock.getLeaves().getRegistryName();
            ResourceLocation leavesTexture = new ResourceLocation(leavesLoc.m_135827_(), "block/" + leavesLoc.m_135815_());
            String leaves = this.strip(leavesLoc.m_135815_());
            ResourceLocation woodLoc = hedgeBlock.getWood().getRegistryName();
            ResourceLocation woodTexture = new ResourceLocation(woodLoc.m_135827_(), "block/" + woodLoc.m_135815_());
            String wood = this.strip(woodLoc.m_135815_());
            ResourceLocation soilLoc = hedgeBlock.getSoil().getRegistryName();
            String soil = this.strip(soilLoc.m_135815_());
            ResourceLocation soilTexture = new ResourceLocation(soilLoc.m_135827_(), "block/" + soilToTexture.getOrDefault(soil, soilLoc.m_135815_()));
            String combinedType = leaves + "_" + wood;
            BlockModelBuilder base = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("block/hedge/" + combinedType + "_" + soil + "_base")).parent((ModelFile)hedgeBase)).texture("leaves", leavesTexture)).texture("wood", woodTexture)).texture("soil", soilTexture)).texture("particle", woodTexture);
            BlockModelBuilder adding = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("block/hedge/" + combinedType + "_" + soil + "_adding")).parent((ModelFile)hedgeAdding)).texture("leaves", leavesTexture)).texture("wood", woodTexture)).texture("soil", soilTexture)).texture("particle", woodTexture);
            BlockModelBuilder none = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("block/hedge/" + combinedType + "_none")).parent((ModelFile)hedgeNone)).texture("wood", woodTexture)).texture("particle", woodTexture);
            ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.states.getMultipartBuilder((Block)hedgeBlock).part().modelFile((ModelFile)base).addModel()).end().part().modelFile((ModelFile)adding).rotationY(270).addModel()).condition((Property)CustomFenceBlock.NORTH, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)none).rotationY(270).addModel()).condition((Property)CustomFenceBlock.NORTH, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)adding).addModel()).condition((Property)CustomFenceBlock.EAST, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)none).addModel()).condition((Property)CustomFenceBlock.EAST, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)adding).rotationY(90).addModel()).condition((Property)CustomFenceBlock.SOUTH, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)none).rotationY(90).addModel()).condition((Property)CustomFenceBlock.SOUTH, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)adding).rotationY(180).addModel()).condition((Property)CustomFenceBlock.WEST, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)none).rotationY(180).addModel()).condition((Property)CustomFenceBlock.WEST, (Comparable[])new Boolean[]{false}).end();
            ((ItemModelBuilder)this.states.itemModels().getBuilder(hedgeBlock.getRegistryName().m_135815_())).parent((ModelFile)base);
        }
    }

    private String strip(String str) {
        int idx = str.lastIndexOf(95);
        return idx == -1 ? str : str.substring(0, idx);
    }
}

