/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.datagen.recipes;

import com.google.gson.JsonObject;
import net.kaneka.planttech2.datagen.recipes.MachineRecipeProvider;
import net.kaneka.planttech2.datagen.recipes.RecipeBuilder;
import net.kaneka.planttech2.recipes.recipeclasses.ChipalyzerRecipe;
import net.kaneka.planttech2.registries.ModItems;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class ChipalyzerRecipesProvider
extends MachineRecipeProvider<ChipalyzerRecipe> {
    public ChipalyzerRecipesProvider(DataGenerator generator) {
        super(generator, "chipalyzer");
    }

    @Override
    void putRecipes() {
        this.putAll(new ChipalyzerRecipe[]{Builder.create("aqua_affinity_chip").chip("planttech2:empty_upgradechip_1").enchantment(Enchantments.f_44971_).out("planttech2:aqua_affinity_chip").build(), Builder.create("armorchip_tier_1").chip("planttech2:empty_upgradechip_1").in(Items.f_42469_).out("planttech2:armorchip_tier_1").build(), Builder.create("armorchip_tier_2").chip("planttech2:armorchip_tier_1").in(ModItems.EMPTY_UPGRADECHIP_TIER_2).out("planttech2:armorchip_tier_2").build(), Builder.create("armorchip_tier_3").chip("planttech2:armorchip_tier_2").in(ModItems.EMPTY_UPGRADECHIP_TIER_3).out("planttech2:armorchip_tier_3").build(), Builder.create("attackchip_tier_1").chip("planttech2:empty_upgradechip_1").in(Items.f_42383_).out("planttech2:attackchip_tier_1").build(), Builder.create("attackchip_tier_2").chip("planttech2:attackchip_tier_1").in(ModItems.EMPTY_UPGRADECHIP_TIER_2).out("planttech2:attackchip_tier_2").build(), Builder.create("attackchip_tier_3").chip("planttech2:attackchip_tier_2").in(ModItems.EMPTY_UPGRADECHIP_TIER_3).out("planttech2:attackchip_tier_3").build(), Builder.create("attackspeedchip_tier_1").chip("planttech2:empty_upgradechip_1").in(Items.f_42430_).out("planttech2:attackspeedchip_tier_1").build(), Builder.create("attackspeedchip_tier_2").chip("planttech2:attackspeedchip_tier_1").in(ModItems.EMPTY_UPGRADECHIP_TIER_2).out("planttech2:attackspeedchip_tier_2").build(), Builder.create("attackspeedchip_tier_3").chip("planttech2:attackspeedchip_tier_2").in(ModItems.EMPTY_UPGRADECHIP_TIER_3).out("planttech2:attackspeedchip_tier_3").build(), Builder.create("bane_of_arthropods_chip").chip("planttech2:empty_upgradechip_1").enchantment(Enchantments.f_44979_).out("planttech2:bane_of_arthropods_chip").build(), Builder.create("blast_protection_chip").chip("planttech2:empty_upgradechip_1").enchantment(Enchantments.f_44968_).out("planttech2:blast_protection_chip").build(), Builder.create("breakdownratechip_tier_1").chip("planttech2:empty_upgradechip_1").in(Items.f_42432_).out("planttech2:breakdownratechip_tier_1").build(), Builder.create("breakdownratechip_tier_2").chip("planttech2:breakdownratechip_tier_1").in(ModItems.EMPTY_UPGRADECHIP_TIER_2).out("planttech2:breakdownratechip_tier_2").build(), Builder.create("breakdownratechip_tier_3").chip("planttech2:breakdownratechip_tier_2").in(ModItems.EMPTY_UPGRADECHIP_TIER_3).out("planttech2:breakdownratechip_tier_3").build(), Builder.create("capacitychip_tier_1").chip("planttech2:empty_upgradechip_1").in(ModItems.ENERGYSTORAGE_TIER_1).out("planttech2:capacitychip_tier_1").build(), Builder.create("capacitychip_tier_2").chip("planttech2:capacitychip_tier_1").in(ModItems.CHIP_UPGRADEPACK_CAPACITY_1).out("planttech2:capacitychip_tier_2").build(), Builder.create("capacitychip_tier_3").chip("planttech2:capacitychip_tier_2").in(ModItems.CHIP_UPGRADEPACK_CAPACITY_2).out("planttech2:capacitychip_tier_3").build(), Builder.create("depth_strider_chip").chip("planttech2:empty_upgradechip_1").enchantment(Enchantments.f_44973_).out("planttech2:depth_strider_chip").build(), Builder.create("efficiency_chip").chip("planttech2:empty_upgradechip_1").enchantment(Enchantments.f_44984_).out("planttech2:efficiency_chip").build(), Builder.create("feather_falling_chip").chip("planttech2:empty_upgradechip_1").enchantment(Enchantments.f_44967_).out("planttech2:feather_falling_chip").build(), Builder.create("fire_aspect_chip").chip("planttech2:empty_upgradechip_1").enchantment(Enchantments.f_44981_).out("planttech2:fire_aspect_chip").build(), Builder.create("fire_protection_chip").chip("planttech2:empty_upgradechip_1").enchantment(Enchantments.f_44966_).out("planttech2:fire_protection_chip").build(), Builder.create("flame_chip").chip("planttech2:empty_upgradechip_1").enchantment(Enchantments.f_44990_).out("planttech2:flame_chip").build(), Builder.create("fortune_chip").chip("planttech2:empty_upgradechip_1").enchantment(Enchantments.f_44987_).out("planttech2:fortune_chip").build(), Builder.create("frost_walker_chip").chip("planttech2:empty_upgradechip_1").enchantment(Enchantments.f_44974_).out("planttech2:frost_walker_chip").build(), Builder.create("harvestlevelchip_tier_1").chip("planttech2:empty_upgradechip_1").in(Items.f_42427_).out("planttech2:harvestlevelchip_tier_1").build(), Builder.create("harvestlevelchip_tier_2").chip("planttech2:harvestlevelchip_tier_1").in(ModItems.CHIP_UPGRADEPACK_HARVESTLEVEL_1).out("planttech2:harvestlevelchip_tier_2").build(), Builder.create("harvestlevelchip_tier_3").chip("planttech2:harvestlevelchip_tier_2").in(ModItems.CHIP_UPGRADEPACK_HARVESTLEVEL_2).out("planttech2:harvestlevelchip_tier_3").build(), Builder.create("infinity_chip").chip("planttech2:empty_upgradechip_1").enchantment(Enchantments.f_44952_).out("planttech2:infinity_chip").build(), Builder.create("knockback_chip").chip("planttech2:empty_upgradechip_1").enchantment(Enchantments.f_44980_).out("planttech2:knockback_chip").build(), Builder.create("looting_chip").chip("planttech2:empty_upgradechip_1").enchantment(Enchantments.f_44982_).out("planttech2:looting_chip").build(), Builder.create("power_chip").chip("planttech2:empty_upgradechip_1").enchantment(Enchantments.f_44988_).out("planttech2:power_chip").build(), Builder.create("projectile_protection_chip").chip("planttech2:empty_upgradechip_1").enchantment(Enchantments.f_44969_).out("planttech2:projectile_protection_chip").build(), Builder.create("protection_chip").chip("planttech2:empty_upgradechip_1").enchantment(Enchantments.f_44965_).out("planttech2:protection_chip").build(), Builder.create("punch_chip").chip("planttech2:empty_upgradechip_1").enchantment(Enchantments.f_44989_).out("planttech2:punch_chip").build(), Builder.create("reactorchip_tier_1").chip("planttech2:empty_upgradechip_1").in(ModItems.SOLARFOCUS_TIER_1).out("planttech2:reactorchip_tier_1").build(), Builder.create("reactorchip_tier_2").chip("planttech2:reactorchip_tier_1").in(ModItems.CHIP_UPGRADEPACK_REACTOR_1).out("planttech2:reactorchip_tier_2").build(), Builder.create("reactorchip_tier_3").chip("planttech2:reactorchip_tier_2").in(ModItems.CHIP_UPGRADEPACK_REACTOR_2).out("planttech2:reactorchip_tier_3").build(), Builder.create("respiration_chip").chip("planttech2:empty_upgradechip_1").enchantment(Enchantments.f_44970_).out("planttech2:respiration_chip").build(), Builder.create("sharpness_chip").chip("planttech2:empty_upgradechip_1").enchantment(Enchantments.f_44977_).out("planttech2:sharpness_chip").build(), Builder.create("silk_touch_chip").chip("planttech2:empty_upgradechip_1").enchantment(Enchantments.f_44985_).out("planttech2:silk_touch_chip").build(), Builder.create("smite_chip").chip("planttech2:empty_upgradechip_1").enchantment(Enchantments.f_44978_).out("planttech2:smite_chip").build(), Builder.create("sweeping_chip").chip("planttech2:empty_upgradechip_1").enchantment(Enchantments.f_44983_).out("planttech2:sweeping_chip").build(), Builder.create("thorns_chip").chip("planttech2:empty_upgradechip_1").enchantment(Enchantments.f_44972_).out("planttech2:thorns_chip").build(), Builder.create("toughnesschip_tier_1").chip("planttech2:empty_upgradechip_1").in(Items.f_42473_).out("planttech2:toughnesschip_tier_1").build(), Builder.create("toughnesschip_tier_2").chip("planttech2:toughnesschip_tier_1").in(ModItems.EMPTY_UPGRADECHIP_TIER_2).out("planttech2:toughnesschip_tier_2").build(), Builder.create("toughnesschip_tier_3").chip("planttech2:toughnesschip_tier_2").in(ModItems.EMPTY_UPGRADECHIP_TIER_3).out("planttech2:toughnesschip_tier_3").build(), Builder.create("unbreaking_chip").chip("planttech2:empty_upgradechip_1").enchantment(Enchantments.f_44986_).out("planttech2:unbreaking_chip").build(), Builder.create("unlockchip_axe").chip("planttech2:empty_upgradechip_1").in(Items.f_42386_).out("planttech2:unlockchip_axe").build(), Builder.create("unlockchip_hoe").chip("planttech2:empty_upgradechip_1").in(Items.f_42387_).out("planttech2:unlockchip_hoe").build(), Builder.create("unlockchip_shears").chip("planttech2:empty_upgradechip_1").in(Items.f_42574_).out("planttech2:unlockchip_shears").build(), Builder.create("unlockchip_shovel").chip("planttech2:empty_upgradechip_1").in(Items.f_42384_).out("planttech2:unlockchip_shovel").build()});
    }

    @Override
    protected JsonObject write(ChipalyzerRecipe recipe) {
        JsonObject json = super.write(recipe);
        this.addItem(json, "chip", recipe.getChip());
        boolean isEnchantment = recipe.getEnchantment() != null;
        this.add(json, "input", isEnchantment ? "enchantment" : "item", (isEnchantment ? recipe.getEnchantment() : recipe.getInput().m_41720_()).getRegistryName().toString());
        this.addItem(json, "result", recipe.m_8043_());
        return json;
    }

    public String m_6055_() {
        return "chipalyzer";
    }

    static class Builder
    extends RecipeBuilder {
        private ItemStack input;
        private ItemStack chip;
        private Enchantment enchantment;
        private ItemStack output;

        public static Builder create(String name) {
            return new Builder(name);
        }

        private Builder(String name) {
            super(name);
        }

        public Builder in(String input) {
            return this.in(input, 1);
        }

        public Builder in(String input, int count) {
            return this.in(this.getItemFromString(input), count);
        }

        public Builder in(Item input) {
            return this.in(input, 1);
        }

        public Builder in(Item input, int count) {
            return this.in(new ItemStack((ItemLike)input, count));
        }

        public Builder in(ItemStack input) {
            this.input = input;
            return this;
        }

        public Builder chip(String chip) {
            return this.chip(chip, 1);
        }

        public Builder chip(String chip, int count) {
            return this.chip(this.getItemFromString(chip), count);
        }

        public Builder chip(Item chip) {
            return this.chip(chip, 1);
        }

        public Builder chip(Item chip, int count) {
            return this.chip(new ItemStack((ItemLike)chip, count));
        }

        public Builder chip(ItemStack chip) {
            this.chip = chip;
            return this;
        }

        public Builder enchantment(String enchant) {
            return this.enchantment((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(enchant)));
        }

        public Builder enchantment(Enchantment enchantment) {
            this.enchantment = enchantment;
            return this;
        }

        public Builder out(String output) {
            return this.out(output, 1);
        }

        public Builder out(String output, int count) {
            return this.out(this.getItemFromString(output), count);
        }

        public Builder out(Item output) {
            return this.out(output, 1);
        }

        public Builder out(Item output, int count) {
            return this.out(new ItemStack((ItemLike)output, count));
        }

        public Builder out(ItemStack output) {
            this.output = output;
            return this;
        }

        public ChipalyzerRecipe build() {
            return new ChipalyzerRecipe(this.id, this.chip, this.input, this.enchantment, this.output);
        }
    }
}

