/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.datagen.recipes;

import com.google.gson.JsonObject;
import net.kaneka.planttech2.datagen.recipes.MachineRecipeProvider;
import net.kaneka.planttech2.datagen.recipes.RecipeBuilder;
import net.kaneka.planttech2.recipes.recipeclasses.InfuserRecipe;
import net.kaneka.planttech2.registries.ModItems;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class InfuserRecipesProvider
extends MachineRecipeProvider<InfuserRecipe> {
    public InfuserRecipesProvider(DataGenerator generator) {
        super(generator, "infuser");
    }

    @Override
    void putRecipes() {
        this.putAll(new InfuserRecipe[]{Builder.create("fertilizer_tier_1").in(Items.f_42499_).biomass(100).out("planttech2:fertilizer_tier_1").build(), Builder.create("fertilizer_tier_2").in(ModItems.FERTILIZER_TIER_1).biomass(200).out("planttech2:fertilizer_tier_2").build(), Builder.create("fertilizer_tier_3").in(ModItems.FERTILIZER_TIER_2).biomass(300).out("planttech2:fertilizer_tier_3").build(), Builder.create("fertilizer_tier_4").in(ModItems.FERTILIZER_TIER_3).biomass(400).out("planttech2:fertilizer_tier_4").build(), Builder.create("gear_dancium_infused").in(ModItems.GEAR_DANCIUM).biomass(200).out("planttech2:gear_dancium_infused").build(), Builder.create("gear_iron_infused").in(ModItems.GEAR_IRON).biomass(200).out("planttech2:gear_iron_infused").build(), Builder.create("gear_kanekium_infused").in(ModItems.GEAR_KANEKIUM).biomass(200).out("planttech2:gear_kanekium_infused").build(), Builder.create("gear_kinnoium_infused").in(ModItems.GEAR_KINNOIUM).biomass(200).out("planttech2:gear_kinnoium_infused").build(), Builder.create("gear_lenthurium_infused").in(ModItems.GEAR_LENTHURIUM).biomass(200).out("planttech2:gear_lenthurium_infused").build(), Builder.create("gear_plantium_infused").in(ModItems.GEAR_PLANTIUM).biomass(200).out("planttech2:gear_plantium_infused").build(), Builder.create("redstone_infused").in(Items.f_42451_).biomass(250).out("planttech2:redstone_infused").build()});
    }

    @Override
    protected JsonObject write(InfuserRecipe recipe) {
        JsonObject json = super.write(recipe);
        this.addWithBiomass(json, "input", recipe.getInput(), recipe.getBiomass());
        this.addItem(json, "result", recipe.m_8043_());
        return json;
    }

    public String m_6055_() {
        return "infusing";
    }

    static class Builder
    extends RecipeBuilder {
        private Item input;
        private int biomass;
        private Item output;

        public static Builder create(String name) {
            return new Builder(name);
        }

        private Builder(String name) {
            super(name);
        }

        public Builder in(String input) {
            return this.in(this.getItemFromString(input));
        }

        public Builder in(Item input) {
            this.input = input;
            return this;
        }

        public Builder biomass(int biomass) {
            this.biomass = biomass;
            return this;
        }

        public Builder out(String output) {
            return this.out(this.getItemFromString(output));
        }

        public Builder out(Item output) {
            this.output = output;
            return this;
        }

        public InfuserRecipe build() {
            return new InfuserRecipe(this.id, this.input, this.output, this.biomass);
        }
    }
}

