/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.datagen.recipes;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;

public abstract class MachineRecipeProvider<R extends Recipe<Container>>
implements DataProvider {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final DataGenerator generator;
    protected final String folder;
    protected HashMap<ResourceLocation, R> recipes = new HashMap();

    protected MachineRecipeProvider(DataGenerator generator, String folder) {
        this.generator = generator;
        this.folder = "recipes/" + folder;
    }

    public void m_6865_(HashCache cache) throws IOException {
        Path resourceRoot = this.generator.m_123916_();
        this.putRecipes();
        this.recipes.forEach((key, recipe) -> {
            Path target = this.getPath(resourceRoot, (ResourceLocation)key);
            try {
                if (!Files.exists(target.getParent(), new LinkOption[0])) {
                    Files.createDirectory(target.getParent(), new FileAttribute[0]);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String data = GSON.toJson((JsonElement)this.write(recipe));
            try (BufferedWriter writer = Files.newBufferedWriter(target, new OpenOption[0]);){
                writer.write(data);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            cache.m_123940_(target, DataProvider.f_123918_.hashUnencodedChars((CharSequence)data).toString());
        });
    }

    private Path getPath(Path pathIn, ResourceLocation id) {
        return pathIn.resolve("data/" + id.m_135827_() + "/" + this.folder + "/" + id.m_135815_() + ".json");
    }

    protected JsonObject write(R recipe) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "planttech2:" + this.m_6055_());
        return json;
    }

    abstract void putRecipes();

    void putAll(R ... recipes) {
        for (R r : recipes) {
            this.put(r);
        }
    }

    void put(R recipe) {
        this.recipes.put(recipe.m_6423_(), recipe);
    }

    protected void addItem(JsonObject json, String key, ItemStack stack) {
        this.addItem(json, key, stack.m_41720_());
    }

    protected void addItem(JsonObject json, String key, Item item) {
        this.add(json, key, "item", item.getRegistryName().toString());
    }

    protected void addItemStack(JsonObject json, String key, ItemStack stack) {
        json.add(key, new JsonParser().parse(GSON.toJson((Object)ImmutableMap.of((Object)"item", (Object)stack.m_41720_().getRegistryName().toString(), (Object)"count", (Object)String.valueOf(stack.m_41613_())))));
    }

    protected void addWithBiomass(JsonObject json, String key, Item stack, int biomass) {
        json.add(key, new JsonParser().parse(GSON.toJson((Object)ImmutableMap.of((Object)"item", (Object)stack.m_5456_().getRegistryName().toString(), (Object)"biomass", (Object)biomass))));
    }

    protected void add(JsonObject json, String key, String subKey, String subValue) {
        json.add(key, new JsonParser().parse(GSON.toJson((Object)ImmutableMap.of((Object)subKey, (Object)subValue))));
    }
}

