/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.entities.capabilities.player;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.kaneka.planttech2.entities.capabilities.player.IRadiationEffect;
import net.kaneka.planttech2.packets.PlantTech2PacketHandler;
import net.kaneka.planttech2.packets.SyncRadiationLevelMessage;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class RadiationEffect
implements ICapabilitySerializable<CompoundTag>,
IRadiationEffect {
    @CapabilityInject(value=IRadiationEffect.class)
    public static Capability<IRadiationEffect> RADIATION_CAPABILITY = null;
    private final LazyOptional<IRadiationEffect> lazyOptional = LazyOptional.of(RadiationEffect::new);
    private float level;

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == RADIATION_CAPABILITY ? this.lazyOptional.cast() : LazyOptional.empty();
    }

    public static IRadiationEffect getCap(ServerPlayer player) {
        IRadiationEffect cap = (IRadiationEffect)player.getCapability(RADIATION_CAPABILITY).orElseThrow(() -> new NullPointerException("getting capability"));
        PlantTech2PacketHandler.sendTo(new SyncRadiationLevelMessage(cap.getLevel()), player);
        return cap;
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128350_("level", ((IRadiationEffect)this.getCapability(RADIATION_CAPABILITY).orElseThrow(NullPointerException::new)).getLevel());
        return compound;
    }

    public void deserializeNBT(CompoundTag nbt) {
        ((IRadiationEffect)this.getCapability(RADIATION_CAPABILITY).orElseThrow(NullPointerException::new)).setLevel(nbt.m_128457_("level"));
    }

    @Override
    public void setLevel(float level) {
        this.level = level < 0.0f ? 0.0f : Math.min(2.0f, level);
    }

    @Override
    public float getLevel() {
        return this.level;
    }

    @Override
    public void changeLevel(float amount) {
        this.level += amount;
        this.level = Math.min(Math.max(this.level, 0.0f), 2.0f);
    }
}

