/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.enums;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public enum EnumTemperature {
    EXTREME_COLD(-1.0f, 0.0f, ChatFormatting.BLUE),
    COLD(0.0f, 0.5f, ChatFormatting.AQUA),
    NORMAL(0.5f, 1.0f, ChatFormatting.GREEN),
    WARM(1.0f, 1.5f, ChatFormatting.YELLOW),
    EXTREME_WARM(1.5f, 2.5f, ChatFormatting.RED);

    private final float min;
    private final float max;
    private final ChatFormatting color;

    private EnumTemperature(float min, float max, ChatFormatting color) {
        this.min = min;
        this.max = max;
        this.color = color;
    }

    public TextComponent getDisplayString() {
        return new TextComponent(new TranslatableComponent("temp." + this.name().toLowerCase()).m_130940_(this.color).getString());
    }

    public static boolean inRange(float value, int tolerance, List<EnumTemperature> temperatures) {
        for (EnumTemperature temperature : temperatures) {
            if (!temperature.inRange(value, tolerance)) continue;
            return true;
        }
        return false;
    }

    public boolean inRange(float value, int tolerance) {
        for (EnumTemperature temp : EnumTemperature.values()) {
            if (this.ordinal() - tolerance > temp.ordinal() || temp.ordinal() > this.ordinal() + tolerance || !(temp.min <= value) || !(temp.max > value)) continue;
            return true;
        }
        return false;
    }

    public ChatFormatting getColor() {
        return this.color;
    }

    public static EnumTemperature byValue(float value) {
        for (EnumTemperature temp : EnumTemperature.values()) {
            if (!(temp.min <= value) || !(temp.max > value)) continue;
            return temp;
        }
        return NORMAL;
    }

    @Nullable
    public static EnumTemperature byName(String name) {
        for (EnumTemperature temp : EnumTemperature.values()) {
            if (!temp.name().equals(name)) continue;
            return temp;
        }
        return null;
    }
}

