/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.events;

import net.kaneka.planttech2.PlantTechClient;
import net.kaneka.planttech2.blocks.CropBaseBlock;
import net.kaneka.planttech2.blocks.Hedge;
import net.kaneka.planttech2.items.CropSeedItem;
import net.kaneka.planttech2.items.ParticleItem;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.registries.ModItems;
import net.kaneka.planttech2.registries.ModRenderer;
import net.kaneka.planttech2.registries.ModScreens;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="planttech2", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ModBusEventsClient {
    @SubscribeEvent
    static void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(PlantTechClient::addAllItemModelsOverrides);
        ModRenderer.registerEntityRenderer();
        ModScreens.registerGUI();
    }

    @SubscribeEvent
    public static void registerColorItem(ColorHandlerEvent.Item event) {
        for (Item entry : ModItems.PARTICLES.values()) {
            event.getItemColors().m_92689_((ItemColor)new ParticleItem.ColorHandler(), new ItemLike[]{entry});
        }
        for (Item entry : ModItems.SEEDS.values()) {
            event.getItemColors().m_92689_((ItemColor)new CropSeedItem.ColorHandler(), new ItemLike[]{entry});
        }
        for (Hedge block : ModBlocks.HEDGE_BLOCKS) {
            event.getItemColors().m_92689_((ItemColor)new Hedge.ColorHandlerItem(block.getLeaves()), new ItemLike[]{block});
        }
    }

    @SubscribeEvent
    public static void registerColorBlock(ColorHandlerEvent.Block event) {
        for (CropBaseBlock cropBaseBlock : ModBlocks.CROPS.values()) {
            event.getBlockColors().m_92589_((BlockColor)new CropBaseBlock.ColorHandler(), new Block[]{cropBaseBlock});
        }
        for (Hedge hedge : ModBlocks.HEDGE_BLOCKS) {
            event.getBlockColors().m_92589_((BlockColor)new Hedge.ColorHandler(hedge.getLeaves(), hedge.getSoil()), new Block[]{hedge});
        }
    }
}

