/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.filehelper;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class DropsJSONGenerator {
    int maxLines = 500;
    int nextLine = 0;
    String[] lines = new String[this.maxLines];

    private void saveFile(String file) {
        try {
            File f = new File("json/" + file + ".json");
            f.createNewFile();
            FileWriter fw = new FileWriter(f, true);
            BufferedWriter bw = new BufferedWriter(fw);
            for (int i = 0; i < this.nextLine; ++i) {
                bw.write(this.lines[i]);
                bw.newLine();
            }
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.lines = new String[this.maxLines];
        this.nextLine = 0;
    }

    private void addLine(String line) {
        this.lines[this.nextLine] = line;
        ++this.nextLine;
    }

    private void createFile(Item item) {
        this.addLine("{");
        this.addLine("\t  \"type\": \"minecraft:block\",");
        this.addLine("\t  \"pools\": [");
        this.addLine("\t    {");
        this.addLine("\t\t  \"name\": \"" + item.getRegistryName() + "\",");
        this.addLine("\t      \"rolls\": 1,");
        this.addLine("\t      \"entries\": [");
        this.addLine("\t        {");
        this.addLine("\t          \"type\": \"minecraft:item\",");
        this.addLine("\t          \"name\": \"" + item.getRegistryName() + "\"");
        this.addLine("\t        }");
        this.addLine("\t      ],");
        this.addLine("\t      \"conditions\": [");
        this.addLine("\t        {");
        this.addLine("\t          \"condition\": \"minecraft:survives_explosion\"");
        this.addLine("\t        }");
        this.addLine("\t      ]");
        this.addLine("\t    }");
        this.addLine("\t  ]");
        this.addLine("\t}");
        this.saveFile(item.getRegistryName().toString().replace("minecraft:", "").replace("planttech2:", ""));
    }

    public void defaultValues() {
        for (Block b : ForgeRegistries.BLOCKS) {
            Item item;
            if (!b.getRegistryName().m_135827_().equals("planttech2") || (item = Item.m_41439_((Block)b)) == Items.f_41852_) continue;
            this.createFile(item);
        }
    }
}

