/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.filehelper;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.util.HashSet;

public class PlantJSONGenerator {
    private static BufferedWriter WRITER;
    private static final HashSet<String> PLANTS;
    private static final HashSet<String> TALL_PLANTS;
    private static final HashSet<String> TALL_PLANTS_SAME;

    public static void main(String[] args) throws IOException {
        for (int i = 0; i < 3; ++i) {
            for (String name : PLANTS) {
                PlantJSONGenerator.createForNormalFlower(i, name, true);
            }
            for (String name : TALL_PLANTS) {
                if (i == 1) {
                    PlantJSONGenerator.createFile(name, true, true);
                    PlantJSONGenerator.createFile(name, true, false);
                    continue;
                }
                PlantJSONGenerator.createForDoubleFlower(i, name, true);
            }
        }
    }

    private static void createForNormalFlower(int type, String name, boolean overwrite) throws IOException {
        PlantJSONGenerator.createFile(type, name, overwrite, false, false);
    }

    private static void createForDoubleFlower(int type, String name, boolean overwrite) throws IOException {
        PlantJSONGenerator.createFile(type, name, overwrite, true, false);
    }

    private static void createForDoubleSameFlower(int type, String name, boolean overwrite) throws IOException {
        PlantJSONGenerator.createFile(type, name, overwrite, true, true);
    }

    private static void createFile(int type, String name, boolean overwrite, boolean isDoubleBlock, boolean isDoubleTheSame) throws IOException {
        FileWriter w;
        String directory = "src/main/resources/assets/planttech2" + (type == 0 ? "/blockstates" : (type == 1 ? "/models/block/plants" : "/models/item"));
        File file = new File(directory + "/" + name + ".json");
        System.out.println(directory);
        if (overwrite || !file.createNewFile()) {
            w = new FileWriter(file);
            WRITER = new BufferedWriter(w);
            switch (type) {
                case 0: {
                    PlantJSONGenerator.write("{");
                    PlantJSONGenerator.write("  \"variants\": {");
                    if (isDoubleTheSame) {
                        PlantJSONGenerator.write("        \"is_top=true\": { \"model\": \"planttech2:block/plants/" + name + "\" },");
                        PlantJSONGenerator.write("        \"is_top=false\": { \"model\": \"planttech2:block/plants/" + name + "\" }");
                    } else if (isDoubleBlock) {
                        PlantJSONGenerator.write("        \"is_top=true\": { \"model\": \"planttech2:block/plants/" + name + "_top\" },");
                        PlantJSONGenerator.write("        \"is_top=false\": { \"model\": \"planttech2:block/plants/" + name + "_bottom\" }");
                    } else {
                        PlantJSONGenerator.write("        \"\": { \"model\": \"planttech2:block/plants/" + name + "\" }");
                    }
                    PlantJSONGenerator.write("    }");
                    PlantJSONGenerator.write("}");
                    break;
                }
                case 1: {
                    PlantJSONGenerator.write("{");
                    PlantJSONGenerator.write("    \"parent\": \"block/cross\",");
                    PlantJSONGenerator.write("    \"textures\": {");
                    if (isDoubleTheSame) {
                        PlantJSONGenerator.write("        \"cross\": \"planttech2:blocks/plants/" + name + "\"");
                    } else {
                        PlantJSONGenerator.write("        \"cross\": \"planttech2:blocks/plants/" + name + "\"");
                    }
                    PlantJSONGenerator.write("    }");
                    PlantJSONGenerator.write("}");
                    break;
                }
                case 2: {
                    PlantJSONGenerator.write("{");
                    PlantJSONGenerator.write("    \"parent\": \"item/generated\",");
                    PlantJSONGenerator.write("    \"textures\": {");
                    PlantJSONGenerator.write("        \"layer0\": \"planttech2:blocks/plants/" + name + (isDoubleBlock ? "_top" : "") + "\"");
                    PlantJSONGenerator.write("    }");
                    PlantJSONGenerator.write("}");
                }
            }
        } else {
            throw new FileAlreadyExistsException("File " + name + "already exist in " + directory);
        }
        WRITER.close();
        w.close();
    }

    private static void createFile(String name, boolean overwrite, boolean isTop) throws IOException {
        FileWriter w;
        String directory = "src/main/resources/assets/planttech2/models/block/plants";
        File file = new File(directory + "/" + name + (isTop ? "_top" : "_bottom") + ".json");
        if (overwrite || !file.createNewFile()) {
            w = new FileWriter(file);
            WRITER = new BufferedWriter(w);
            PlantJSONGenerator.write("{");
            PlantJSONGenerator.write("    \"parent\": \"block/cross\",");
            PlantJSONGenerator.write("    \"textures\": {");
            if (isTop) {
                PlantJSONGenerator.write("        \"cross\": \"planttech2:blocks/plants/" + name + "_top\"");
            } else {
                PlantJSONGenerator.write("        \"cross\": \"planttech2:blocks/plants/" + name + "_bottom\"");
            }
        } else {
            throw new FileAlreadyExistsException("File " + name + "already exist in " + directory);
        }
        PlantJSONGenerator.write("    }");
        PlantJSONGenerator.write("}");
        WRITER.close();
        w.close();
    }

    private static void write(String str) throws IOException {
        WRITER.write(str);
        WRITER.newLine();
    }

    static {
        PLANTS = new HashSet<String>(){
            {
                this.add("mutated_dandelion");
                this.add("mutated_poppy");
                this.add("mutated_blue_orchid");
                this.add("mutated_allium");
                this.add("mutated_azure_bluet");
                this.add("mutated_red_tulip");
                this.add("mutated_orange_tulip");
                this.add("mutated_white_tulip");
                this.add("mutated_pink_tulip");
                this.add("mutated_oxeye_daisy");
                this.add("mutated_cornflower");
                this.add("mutated_lily_of_the_valley");
            }
        };
        TALL_PLANTS = new HashSet<String>(){
            {
                this.add("mutated_lilac");
                this.add("mutated_rose_bush");
                this.add("mutated_peony");
            }
        };
        TALL_PLANTS_SAME = new HashSet<String>(){};
    }
}

