/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.filehelper;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.registries.ModItems;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class RecipeJSONGenerator {
    int maxLines = 100;
    int nextLine = 0;
    String[] lines = new String[this.maxLines];
    String[] abc = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I"};

    public void saveFile(String file) {
        try {
            File f = new File("recipes/" + file + ".json");
            f.createNewFile();
            FileWriter fw = new FileWriter(f, true);
            BufferedWriter bw = new BufferedWriter(fw);
            for (int i = 0; i < this.nextLine; ++i) {
                bw.write(this.lines[i]);
                bw.newLine();
            }
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.lines = new String[this.maxLines];
        this.nextLine = 0;
    }

    public void addLine(String line) {
        this.lines[this.nextLine] = line;
        ++this.nextLine;
    }

    public void createShapelessRecipeFile(String name, String output, int amount, String ... ingredients) {
        this.addLine("{");
        this.addLine("    \"type\": \"minecraft:crafting_shapeless\",");
        this.addLine("    \"ingredients\": [");
        int i = ingredients.length;
        int k = 0;
        for (String ingredient : ingredients) {
            ++k;
            this.addLine("        {");
            String[] withMeta = ingredient.split("-");
            if (withMeta.length < 2) {
                this.addLine("            \"item\": \"" + ingredient + "\"");
            } else {
                this.addLine("            \"item\": \"" + withMeta[0] + "\"");
            }
            if (k < i) {
                this.addLine("        },");
                continue;
            }
            this.addLine("        }");
        }
        this.addLine("    ],");
        this.addLine("    \"result\": {");
        this.addLine("        \"item\": \"" + output + "\",");
        this.addLine("        \"count\": " + amount);
        this.addLine("    }");
        this.addLine("}");
        this.saveFile(name);
    }

    public void createShapedRecipeFile(String row1, String row2, String row3, String name, String output, int amount, String ... ingredients) {
        this.addLine("{");
        this.addLine("    \"type\": \"minecraft:crafting_shaped\",");
        this.addLine("    \"pattern\": [");
        this.addLine("        \"" + row1 + "\",");
        if (!row3.equals("")) {
            this.addLine("        \"" + row2 + "\",");
            this.addLine("        \"" + row3 + "\"");
        } else {
            this.addLine("        \"" + row2 + "\"");
        }
        this.addLine("    ],");
        this.addLine("    \"key\": {");
        int i = ingredients.length;
        int k = 0;
        for (String ingredient : ingredients) {
            this.addLine("        \"" + this.abc[k] + "\": ");
            ++k;
            this.addLine("        {");
            String[] withMeta = ingredient.split("-");
            if (withMeta.length < 2) {
                this.addLine("            \"item\": \"" + ingredient + "\"");
            } else {
                this.addLine("            \"item\": \"" + withMeta[0] + "\"");
            }
            if (k < i) {
                this.addLine("        },");
                continue;
            }
            this.addLine("        }");
        }
        this.addLine("    },");
        this.addLine("    \"result\": {");
        this.addLine("        \"item\": \"" + output + "\",");
        this.addLine("        \"count\": " + amount);
        this.addLine("    }");
        this.addLine("}");
        this.saveFile(name);
    }

    public void createShapedRecipeFileItem(String row1, String row2, String row3, ItemStack output, int amount, ItemStack ... ingredients) {
        this.createShapedRecipeFileItem(row1, row2, row3, output, output.m_41720_().getRegistryName().toString().replace("minecraft:", "").replace("planttech2:", ""), amount, ingredients);
    }

    public void createShapedRecipeFileItem(String row1, String row2, String row3, ItemStack output, String filename, int amount, ItemStack ... ingredients) {
        System.out.println(filename);
        this.addLine("{");
        this.addLine("    \"type\": \"minecraft:crafting_shaped\",");
        this.addLine("    \"pattern\": [");
        this.addLine("        \"" + row1 + "\",");
        if (!row3.equals("")) {
            this.addLine("        \"" + row2 + "\",");
            this.addLine("        \"" + row3 + "\"");
        } else {
            this.addLine("        \"" + row2 + "\"");
        }
        this.addLine("    ],");
        this.addLine("    \"key\": {");
        int i = ingredients.length;
        int k = 0;
        for (ItemStack ingredient : ingredients) {
            this.addLine("        \"" + this.abc[k] + "\": ");
            this.addLine("        {");
            this.addLine("            \"item\": \"" + ingredient.m_41720_().getRegistryName() + "\"");
            if (++k < i) {
                this.addLine("        },");
                continue;
            }
            this.addLine("        }");
        }
        this.addLine("    },");
        this.addLine("    \"result\": {");
        this.addLine("        \"item\": \"" + output.m_41720_().getRegistryName() + "\",");
        this.addLine("        \"count\": " + amount);
        this.addLine("    }");
        this.addLine("}");
        this.saveFile(filename);
    }

    public void createXRecipe(ItemStack output, int amount, ItemStack input) {
        this.createShapedRecipeFileItem("A A", " A ", "A A", output, amount, input);
    }

    public void createORecipe(ItemStack output, int amount, ItemStack input) {
        this.createShapedRecipeFileItem("AAA", "A A", "AAA", output, amount, input);
    }

    public void create2x2Recipe(ItemStack output, int amount, ItemStack input) {
        this.createShapedRecipeFileItem("AA", "AA", "", output, amount, input);
    }

    public void create3x3Recipe(ItemStack output, int amount, ItemStack input) {
        this.createShapedRecipeFileItem("AAA", "AAA", "AAA", output, amount, input);
    }

    public void createChestplateRecipe(ItemStack output, int amount, ItemStack input) {
        this.createShapedRecipeFileItem("A A", "AAA", "AAA", output, amount, input);
    }

    public void createHelmetRecipe(ItemStack output, int amount, ItemStack input) {
        this.createShapedRecipeFileItem("AAA", "A A", "   ", output, amount, input);
    }

    public void createLeggingsRecipe(ItemStack output, int amount, ItemStack input) {
        this.createShapedRecipeFileItem("AAA", "A A", "A A", output, amount, input);
    }

    public void createBootsRecipe(ItemStack output, int amount, ItemStack input) {
        this.createShapedRecipeFileItem("A A", "A A", "   ", output, amount, input);
    }

    public void createRecipes() {
        this.createShapedRecipeFileItem("ABA", "BAB", "ABA", new ItemStack((ItemLike)ModItems.PLANTIUM_INGOT), 1, new ItemStack((ItemLike)Items.f_42404_), new ItemStack((ItemLike)Items.f_42749_));
        this.createShapedRecipeFileItem("AAA", "AAA", "AAA", new ItemStack((ItemLike)ModItems.PLANTIUM_INGOT), "plantium_ingot2", 1, new ItemStack((ItemLike)ModItems.PLANTIUM_NUGGET));
        this.createShapelessRecipeFile("plantium_ingot3", "planttech2:plantium_ingot", 9, "planttech2:plantium_block");
        this.createShapelessRecipeFile("plantium_nugget", "planttech2:plantium_nugget", 9, "planttech2:plantium_ingot");
        this.create3x3Recipe(new ItemStack((ItemLike)ModBlocks.PLANTIUM_BLOCK), 1, new ItemStack((ItemLike)ModItems.PLANTIUM_INGOT));
        this.createShapedRecipeFileItem("AAA", "AAA", "AAA", new ItemStack((ItemLike)ModItems.DANCIUM_INGOT), "dancium_ingot1", 1, new ItemStack((ItemLike)ModItems.DANCIUM_NUGGET));
        this.createShapelessRecipeFile("dancium_ingot2", "planttech2:dancium_ingot", 9, "planttech2:dancium_block");
        this.createShapelessRecipeFile("dancium_nugget", "planttech2:dancium_nugget", 9, "planttech2:dancium_ingot");
        this.create3x3Recipe(new ItemStack((ItemLike)ModBlocks.DANCIUM_BLOCK), 1, new ItemStack((ItemLike)ModItems.DANCIUM_INGOT));
        this.createShapedRecipeFileItem("AAA", "AAA", "AAA", new ItemStack((ItemLike)ModItems.KANEKIUM_INGOT), "kanekium_ingot1", 1, new ItemStack((ItemLike)ModItems.KANEKIUM_NUGGET));
        this.createShapelessRecipeFile("kanekium_ingot2", "planttech2:kanekium_ingot", 9, "planttech2:kanekium_block");
        this.createShapelessRecipeFile("kanekium_nugget", "planttech2:kanekium_nugget", 9, "planttech2:kanekium_ingot");
        this.create3x3Recipe(new ItemStack((ItemLike)ModBlocks.KANEKIUM_BLOCK), 1, new ItemStack((ItemLike)ModItems.KANEKIUM_INGOT));
        this.createShapedRecipeFileItem("AAA", "AAA", "AAA", new ItemStack((ItemLike)ModItems.KINNOIUM_INGOT), "kinnoium_ingot1", 1, new ItemStack((ItemLike)ModItems.KINNOIUM_NUGGET));
        this.createShapelessRecipeFile("kinnoium_ingot2", "planttech2:kinnoium_ingot", 9, "planttech2:kinnoium_block");
        this.createShapelessRecipeFile("kinnoium_nugget", "planttech2:kinnoium_nugget", 9, "planttech2:kinnoium_ingot");
        this.create3x3Recipe(new ItemStack((ItemLike)ModBlocks.KINNOIUM_BLOCK), 1, new ItemStack((ItemLike)ModItems.KINNOIUM_INGOT));
        this.createShapedRecipeFileItem("AAA", "AAA", "AAA", new ItemStack((ItemLike)ModItems.LENTHURIUM_INGOT), "lenthurium_ingot1", 1, new ItemStack((ItemLike)ModItems.LENTHURIUM_NUGGET));
        this.createShapelessRecipeFile("lenthurium_ingot2", "planttech2:lenthurium_ingot", 9, "planttech2:lenthurium_block");
        this.createShapelessRecipeFile("lenthurium_nugget", "planttech2:lenthurium_nugget", 9, "planttech2:lenthurium_ingot");
        this.create3x3Recipe(new ItemStack((ItemLike)ModBlocks.LENTHURIUM_BLOCK), 1, new ItemStack((ItemLike)ModItems.LENTHURIUM_INGOT));
        this.createShapedRecipeFileItem("A", "A", "B", new ItemStack((ItemLike)ModItems.THERMOMETER), 1, new ItemStack((ItemLike)Blocks.f_50058_), new ItemStack((ItemLike)ModItems.PLANTIUM_INGOT));
        this.createShapedRecipeFileItem("AAA", "AAA", " B ", new ItemStack((ItemLike)ModItems.ANALYSER), 1, new ItemStack((ItemLike)Blocks.f_50058_), new ItemStack((ItemLike)ModItems.PLANTIUM_INGOT));
        this.createShapedRecipeFileItem("A A", "AAA", " A ", new ItemStack((ItemLike)ModItems.WRENCH), 1, new ItemStack((ItemLike)ModItems.PLANTIUM_INGOT));
        this.createShapedRecipeFileItem("ABA", "BCB", "ABA", new ItemStack((ItemLike)ModItems.SOLARFOCUS_TIER_1), "solarfocus1", 1, new ItemStack((ItemLike)Blocks.f_50185_), new ItemStack((ItemLike)ModItems.PLANTIUM_INGOT), new ItemStack((ItemLike)Items.f_42415_));
        this.createShapedRecipeFileItem("ABA", "BCB", "ABA", new ItemStack((ItemLike)ModItems.SOLARFOCUS_TIER_2), "solarfocus2", 1, new ItemStack((ItemLike)Blocks.f_50185_), new ItemStack((ItemLike)ModItems.SOLARFOCUS_TIER_1), new ItemStack((ItemLike)Items.f_42415_));
        this.createShapedRecipeFileItem("ABA", "BCB", "ABA", new ItemStack((ItemLike)ModItems.SOLARFOCUS_TIER_3), "solarfocus3", 1, new ItemStack((ItemLike)Blocks.f_50185_), new ItemStack((ItemLike)ModItems.SOLARFOCUS_TIER_2), new ItemStack((ItemLike)Items.f_42415_));
        this.createShapedRecipeFileItem("ABA", "BCB", "ABA", new ItemStack((ItemLike)ModItems.SOLARFOCUS_TIER_4), "solarfocus4", 1, new ItemStack((ItemLike)Blocks.f_50185_), new ItemStack((ItemLike)ModItems.SOLARFOCUS_TIER_3), new ItemStack((ItemLike)Items.f_42415_));
        this.createShapedRecipeFileItem("ABA", "BCB", "ABA", new ItemStack((ItemLike)ModItems.SPEEDUPGRADE_TIER_1), "speedupgrade1", 1, new ItemStack((ItemLike)Blocks.f_50185_), new ItemStack((ItemLike)ModItems.PLANTIUM_INGOT), new ItemStack((ItemLike)Items.f_42616_));
        this.createShapedRecipeFileItem("ABA", "BCB", "ABA", new ItemStack((ItemLike)ModItems.SPEEDUPGRADE_TIER_2), "speedupgrade2", 1, new ItemStack((ItemLike)Blocks.f_50185_), new ItemStack((ItemLike)ModItems.SPEEDUPGRADE_TIER_1), new ItemStack((ItemLike)Items.f_42616_));
        this.createShapedRecipeFileItem("ABA", "BCB", "ABA", new ItemStack((ItemLike)ModItems.SPEEDUPGRADE_TIER_3), "speedupgrade3", 1, new ItemStack((ItemLike)Blocks.f_50185_), new ItemStack((ItemLike)ModItems.SPEEDUPGRADE_TIER_2), new ItemStack((ItemLike)Items.f_42616_));
        this.createShapedRecipeFileItem("ABA", "BCB", "ABA", new ItemStack((ItemLike)ModItems.SPEEDUPGRADE_TIER_4), "speedupgrade4", 1, new ItemStack((ItemLike)Blocks.f_50185_), new ItemStack((ItemLike)ModItems.SPEEDUPGRADE_TIER_3), new ItemStack((ItemLike)Items.f_42616_));
        this.createShapedRecipeFileItem("ABA", "BCB", "ABA", new ItemStack((ItemLike)ModItems.RANGEUPGRADE_TIER_1), "rangeupgrade1", 1, new ItemStack((ItemLike)Blocks.f_50185_), new ItemStack((ItemLike)ModItems.PLANTIUM_INGOT), new ItemStack((ItemLike)Items.f_42424_));
        this.createShapedRecipeFileItem("ABA", "BCB", "ABA", new ItemStack((ItemLike)ModItems.RANGEUPGRADE_TIER_2), "rangeupgrade2", 1, new ItemStack((ItemLike)Blocks.f_50185_), new ItemStack((ItemLike)ModItems.RANGEUPGRADE_TIER_1), new ItemStack((ItemLike)Items.f_42387_));
        this.createShapedRecipeFileItem("ABA", "BCB", "ABA", new ItemStack((ItemLike)ModItems.RANGEUPGRADE_TIER_3), "rangeupgrade3", 1, new ItemStack((ItemLike)Blocks.f_50185_), new ItemStack((ItemLike)ModItems.RANGEUPGRADE_TIER_2), new ItemStack((ItemLike)Items.f_42434_));
        this.createShapedRecipeFileItem("ABA", "BCB", "ABA", new ItemStack((ItemLike)ModItems.RANGEUPGRADE_TIER_4), "rangeupgrade4", 1, new ItemStack((ItemLike)Blocks.f_50185_), new ItemStack((ItemLike)ModItems.RANGEUPGRADE_TIER_3), new ItemStack((ItemLike)Items.f_42392_));
        this.create2x2Recipe(new ItemStack((ItemLike)ModBlocks.CROPBARS), 1, new ItemStack((ItemLike)Items.f_42398_));
        this.createShapedRecipeFileItem("AAA", "BCB", "AAA", new ItemStack((ItemLike)ModBlocks.MEGAFURNACE), 1, new ItemStack((ItemLike)Blocks.f_50094_), new ItemStack((ItemLike)ModItems.PLANTIUM_INGOT), new ItemStack((ItemLike)ModBlocks.PLANTIUM_BLOCK));
        this.createShapedRecipeFileItem("ABA", "A A", "AAA", new ItemStack((ItemLike)ModItems.DNA_CONTAINER_EMPTY), 16, new ItemStack((ItemLike)Blocks.f_50185_), new ItemStack((ItemLike)Blocks.f_50742_));
        this.createShapedRecipeFileItem("ABA", "ACA", "AAA", new ItemStack((ItemLike)ModBlocks.DNA_CLEANER), 1, new ItemStack((ItemLike)ModItems.PLANTIUM_INGOT), new ItemStack((ItemLike)Items.f_42484_), new ItemStack((ItemLike)ModItems.DNA_CONTAINER_EMPTY));
        this.createShapedRecipeFileItem("ABA", "ACA", "AAA", new ItemStack((ItemLike)ModBlocks.DNA_EXTRACTOR), 1, new ItemStack((ItemLike)ModItems.PLANTIUM_INGOT), new ItemStack((ItemLike)Items.f_42392_), new ItemStack((ItemLike)ModItems.DNA_CONTAINER_EMPTY));
        this.createShapedRecipeFileItem("ABA", "ACA", "AAA", new ItemStack((ItemLike)ModBlocks.DNA_COMBINER), 1, new ItemStack((ItemLike)ModItems.PLANTIUM_INGOT), new ItemStack((ItemLike)Items.f_42389_), new ItemStack((ItemLike)ModItems.DNA_CONTAINER_EMPTY));
        this.createShapedRecipeFileItem("ABA", "ACA", "AAA", new ItemStack((ItemLike)ModBlocks.DNA_REMOVER), 1, new ItemStack((ItemLike)ModItems.PLANTIUM_INGOT), new ItemStack((ItemLike)Items.f_42391_), new ItemStack((ItemLike)ModItems.DNA_CONTAINER_EMPTY));
        this.createShapedRecipeFileItem("ABA", "ACA", "AAA", new ItemStack((ItemLike)ModBlocks.SEEDCONSTRUCTOR), 1, new ItemStack((ItemLike)ModItems.PLANTIUM_INGOT), new ItemStack((ItemLike)Items.f_42390_), new ItemStack((ItemLike)ModItems.DNA_CONTAINER_EMPTY));
        this.createShapedRecipeFileItem("AAA", "B B", "CCC", new ItemStack((ItemLike)ModBlocks.COMPRESSOR), 1, new ItemStack((ItemLike)ModItems.PLANTIUM_INGOT), new ItemStack((ItemLike)Blocks.f_50039_), new ItemStack((ItemLike)ModBlocks.PLANTIUM_BLOCK));
        this.createShapedRecipeFileItem(" A ", "ABA", " A ", new ItemStack((ItemLike)ModItems.GUIDE_OVERVIEW), 1, new ItemStack((ItemLike)Items.f_42404_), new ItemStack((ItemLike)Items.f_42517_));
        this.createShapedRecipeFileItem(" A ", "ABA", " A ", new ItemStack((ItemLike)ModItems.GUIDE_PLANTS), 1, new ItemStack((ItemLike)Items.f_42577_), new ItemStack((ItemLike)Items.f_42517_));
        this.createShapedRecipeFileItem(" A ", "ABA", " A ", new ItemStack((ItemLike)ModItems.GUIDE_GENETIC_ENGINEERING), 1, new ItemStack((ItemLike)Items.f_42578_), new ItemStack((ItemLike)Items.f_42517_));
    }
}

