/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.fluids;

import net.minecraft.nbt.CompoundTag;

public class TempFluidTank {
    private int capacity;
    private int biomass;

    public TempFluidTank(int capacity, int biomass) {
        this.capacity = capacity;
        this.biomass = biomass;
    }

    public TempFluidTank(int capacity) {
        this.capacity = capacity;
        this.biomass = 0;
    }

    public int receive(int maxReceive) {
        int space = this.capacity - this.biomass;
        if (space >= maxReceive) {
            this.biomass += maxReceive;
            return maxReceive;
        }
        this.biomass = this.capacity;
        return space;
    }

    public int extract(int maxExtract) {
        if (this.biomass >= maxExtract) {
            this.biomass -= maxExtract;
            return maxExtract;
        }
        this.biomass = 0;
        return this.biomass;
    }

    public void setCapacity(int value) {
        this.capacity = value;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setBiomass(int value) {
        this.biomass = value;
    }

    public int getBiomass() {
        return this.biomass;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.capacity = nbt.m_128451_("tankcapacity");
        this.biomass = nbt.m_128451_("biomass");
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbtList = new CompoundTag();
        nbtList.m_128405_("tankcapacity", this.capacity);
        nbtList.m_128405_("biomass", this.biomass);
        return nbtList;
    }
}

