/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.fluids.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.kaneka.planttech2.fluids.capability.IBiomassFluidEnergy;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class BiomassFluidEnergy
implements ICapabilitySerializable<CompoundTag>,
IBiomassFluidEnergy {
    @CapabilityInject(value=IBiomassFluidEnergy.class)
    public static Capability<IBiomassFluidEnergy> BIOMASS_FLUID_ENERGY = null;
    private final LazyOptional<IBiomassFluidEnergy> lazyOptional = LazyOptional.of(BiomassFluidEnergy::new);
    private int currentStorage = 0;
    private int maxStorage = 1000;

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == BIOMASS_FLUID_ENERGY ? this.lazyOptional.cast() : LazyOptional.empty();
    }

    public static IBiomassFluidEnergy getTECap(BlockEntity te) {
        return (IBiomassFluidEnergy)te.getCapability(BIOMASS_FLUID_ENERGY).orElseThrow(() -> new NullPointerException("getting capability for tileentity"));
    }

    public static IBiomassFluidEnergy getItemStackCap(ItemStack stack) {
        return (IBiomassFluidEnergy)stack.getCapability(BIOMASS_FLUID_ENERGY).orElseThrow(() -> new NullPointerException("getting capability for itemstack"));
    }

    private IBiomassFluidEnergy getCap() {
        return (IBiomassFluidEnergy)this.getCapability(BIOMASS_FLUID_ENERGY).orElseThrow(NullPointerException::new);
    }

    public CompoundTag serializeNBT() {
        return BiomassFluidEnergy.write(this.getCap());
    }

    public void deserializeNBT(CompoundTag nbt) {
        BiomassFluidEnergy.read(this.getCap(), nbt);
    }

    public static CompoundTag write(IBiomassFluidEnergy cap) {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("max", cap.getMaxStorage());
        compound.m_128405_("current", cap.getCurrentStorage());
        return compound;
    }

    public static void read(IBiomassFluidEnergy cap, CompoundTag nbt) {
        cap.setMaxStorage(nbt.m_128451_("max"));
        cap.setCurrentStorage(nbt.m_128451_("current"));
    }

    @Override
    public int getCurrentStorage() {
        return this.currentStorage;
    }

    @Override
    public int getMaxStorage() {
        return this.maxStorage;
    }

    @Override
    public int extractBiomass(int amount) {
        amount = Math.abs(amount);
        if (this.getCurrentStorage() < amount) {
            this.changeCurrentStorage(-this.getCurrentStorage());
            return this.getCurrentStorage();
        }
        this.changeCurrentStorage(-amount);
        return amount;
    }

    @Override
    public void setCurrentStorage(int value) {
        this.currentStorage = value < 0 ? 0 : Math.min(value, this.maxStorage);
    }

    @Override
    public void setMaxStorage(int value) {
        this.maxStorage = value;
    }

    @Override
    public void changeCurrentStorage(int amount) {
        this.currentStorage = this.currentStorage + amount < 0 ? 0 : (this.currentStorage + amount > this.maxStorage ? this.maxStorage : (this.currentStorage += amount));
    }

    @Override
    public int recieveBiomass(int amount) {
        amount = Math.abs(amount);
        this.changeCurrentStorage(Math.abs(amount));
        return -amount;
    }

    @Override
    public void clearStorage() {
        this.currentStorage = 0;
    }

    @Override
    public boolean hasEnoughBiomass(int target) {
        return this.currentStorage >= target;
    }
}

