/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.kaneka.planttech2.items.GuideItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public abstract class GuideBaseScreen
extends Screen {
    protected static final ResourceLocation BACKGROUND = new ResourceLocation("planttech2", "textures/gui/plantencyclopaedia_big.png");
    protected static final int TEXT_COLOR = 59395;
    protected int xSize = 512;
    protected int ySize = 196;
    protected int guiLeft;
    protected int guiTop;
    protected int scrollMax;
    protected int scrollPos = 0;
    protected int fadeInTimer = 50;
    protected boolean hasSelection;
    protected boolean allowScroll;

    public GuideBaseScreen(int scrollMax, boolean allowScroll, String title) {
        super((Component)new TranslatableComponent(title));
        this.scrollMax = scrollMax;
        this.allowScroll = allowScroll;
    }

    public void m_7856_() {
        super.m_7856_();
        if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_21205_().m_41720_() instanceof GuideItem) {
            Minecraft.m_91087_().f_91074_.m_21205_().m_41721_(1);
        }
        this.hasSelection = false;
        this.guiLeft = (this.f_96543_ - 400) / 2;
        this.guiTop = (this.f_96544_ - this.ySize) / 2;
    }

    protected abstract void updateButtons();

    public void m_6305_(PoseStack pStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(pStack);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.f_96541_.m_91097_().m_118506_(BACKGROUND);
        if (this.fadeInTimer > 0) {
            --this.fadeInTimer;
            this.drawFadeInEffect(pStack);
        } else {
            this.drawBackground(pStack);
            this.drawForeground(pStack);
            this.drawButtons(pStack, mouseX, mouseY, partialTicks);
            this.drawStrings(pStack);
            this.drawTooltips(pStack, mouseX, mouseY);
        }
    }

    private void drawButtons(PoseStack mStack, int mouseX, int mouseY, float partialTicks) {
        for (Widget button : this.f_169369_) {
            button.m_6305_(mStack, mouseX, mouseY, partialTicks);
        }
    }

    protected void drawBackground(PoseStack mStack) {
        GuideBaseScreen.m_93133_((PoseStack)mStack, (int)(this.guiLeft + 100), (int)this.guiTop, (float)212.0f, (float)0.0f, (int)300, (int)this.ySize, (int)512, (int)512);
        GuideBaseScreen.m_93133_((PoseStack)mStack, (int)this.guiLeft, (int)this.guiTop, (float)0.0f, (float)0.0f, (int)150, (int)this.ySize, (int)512, (int)512);
    }

    protected abstract void drawForeground(PoseStack var1);

    private void drawFadeInEffect(PoseStack mStack) {
        float percentage = 1.0f - (float)this.fadeInTimer / 50.0f;
        GuideBaseScreen.m_93133_((PoseStack)mStack, (int)(this.guiLeft + 100), (int)this.guiTop, (float)((float)this.xSize - 300.0f * percentage), (float)0.0f, (int)((int)(300.0f * percentage)), (int)this.ySize, (int)512, (int)512);
        GuideBaseScreen.m_93133_((PoseStack)mStack, (int)this.guiLeft, (int)this.guiTop, (float)0.0f, (float)0.0f, (int)150, (int)this.ySize, (int)512, (int)512);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.allowScroll && mouseX != 0.0) {
            this.scrollPos += delta > 0.0 ? -1 : 1;
            this.scrollPos = Math.max(0, this.scrollPos);
            this.scrollPos = Math.min(this.scrollMax, this.scrollPos);
            this.updateButtons();
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    protected abstract void drawStrings(PoseStack var1);

    public void renderItem(ItemStack itemstack, int x, int y) {
        this.f_96542_.m_115203_(itemstack, this.guiLeft + x, this.guiTop + y);
    }

    public void drawTooltip(PoseStack pStack, Component lines, int mouseX, int mouseY, int posX, int posY) {
        this.drawTooltip(pStack, lines, mouseX, mouseY, posX, posY, 16, 16);
    }

    public void drawTooltip(PoseStack pStack, Component lines, int mouseX, int mouseY, int posX, int posY, int width, int height) {
        if (mouseX >= (posX += this.guiLeft) && mouseX <= posX + width && mouseY >= (posY += this.guiTop) && mouseY <= posY + height) {
            this.m_96602_(pStack, lines, mouseX, mouseY);
        }
    }

    protected abstract void drawTooltips(PoseStack var1, int var2, int var3);

    public void m_7861_() {
        if (Minecraft.m_91087_().f_91074_.m_21205_().m_41720_() instanceof GuideItem) {
            Minecraft.m_91087_().f_91074_.m_21205_().m_41721_(0);
        }
        super.m_7861_();
    }
}

